/***********************************************************************************
 File:		pacManager_api.h
 Module:		pacManager
 Purpose: 	Handle PacManager 
 Description:	This file contains all definitions and the structures of the LinkAdaptation  
 				
************************************************************************************/
#ifndef PAC_MANAGER_API_
#define PAC_MANAGER_API_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "shram.h"
#include "lmi.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"

//---------------------------------------------------------------------------------
//						Defines						
//--------------------------------------------------------------------------------- 


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
 
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct PacManagerStart_s
{
	uint32		loggerStationIndex; 
} PacManagerStart_t;

typedef struct PacManagerActivateNormal_s
{
	bool blockingEnabled;
} PacManagerActivateNormal_t;

typedef struct PacManagerFunctionEntry
{
	void (* psTaskEventAction)(K_MSG *psMsg);
	K_MSG_TYPE  kmsgType;
} PacManagerFunctionEntry_t;

typedef struct PacManagerGlobalParams_s
{
	uint32 vapIdBitMap;		
	uint32 vapSetBssBitMap;		
	uint16 numOfAddedVaps;
	uint16 operationMode;
	uint32 longFilter0Ref1RegNormal;
	uint32 longFilter0Ref2RegNormal;
} PacManagerGlobalParams_t;


typedef struct PacMngSetChannelParams
{
	Bandwidth_e bw; // values from the Bandwidth_e enum 
	uint8		sub_band; // within the 1 to 8 channels specified by chan_width, i.e., from 0 to 7	
}PacMngSetChannelParams_t;


typedef struct PacMngPreAggEtsiPpduDurationLimitsReq_s
{
	bool PreAggSetNonEtsiPpduDurationLimitsReq;
} PacMngPreAggEtsiPpduDurationLimitsReq_t;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

extern uint32 PacMngr_LoggerStationIndex;
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void PacManager_Task(K_MSG *psMsg); 
PacManagerGlobalParams_t* PacManager_GetGlobalParams(void);
void PacManagerSendCfmToVapManagerForRemoveVap(uint8 vapIndex);	
void PacManager_PostInit(void);
#if defined (ENET_INC_ARCH_WAVE600)
void isr_PacManager_UlprFifoNotEmpty(void);
void isr_PacManager_PreAggFifoNotEmpty(void);
#if defined (ENET_INC_ARCH_WAVE600D2)
void PacManager_ConfigureVapModeBitmap(uint8 vapId, bool vapMode);
void PacManagerConfigureVapModeBitmap(uint8 vapId, bool vapMode);
#endif //ENET_INC_ARCH_WAVE600D2
#endif //ENET_INC_ARCH_WAVE600

#endif /* PAC_MANAGER_API_ */

