/***********************************************************************************
 File:		PacManager.c
 Module:		PacManager
 Purpose: 	 
 Description:	 
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Tasks.h"
#include "shram.h"
#include "shram_man_queues.h"
#include "shram_man_msgs.h"
#include "ShramVapDatabase.h"
#include "int_gen.h"
#include "stringLibApi.h" 
#include "RegAccess_Api.h" 
#include "PacManager_api.h"
#include "Pac_Api.h"
#include "BeaconHandler_api.h"
#include "lminfra.h"
#include "RxHandler_InitApi.h"
#include "Dut_Api.h"
#include "Utils_Api.h"
#include "queue_utility.h"
#include "ProcessManager_Api.h"
#include "HwEventsAndErrors_Api.h"
#include "Protocol_PhyAttributes.h" 
#include "ServicesHandler_Api.h"
#include "StaDatabase_Api.h"
#include "PsManager_Api.h"
#include "Pac_Api.h"
#include "StatisticsManager_api.h"
#include "CpuLoad_Api.h"
#include "Mac2index_Api.h"
#include "TxHandler_Api.h"
#include "queue_utility.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "RxClassifier_Api.h"
#include "RxHandler_Api.h"
#include "SenderInterface_Api.h"
#include "SenderInterface.h"
#include "TxHeaderConversion_Api.h"
#include "VapDb_Descriptors.h"
#include "ShramVapDatabase.h"
#include "HwLoggerAPI.h"
#include "AutoResponse_Api.h"
#include "BaAnalyzer_Api.h"
#include "OtfAggregator_Api.h"
#include "UlPostRx_Api.h"
#include "CpuLoad_Api.h"
#include "EventsManager_api.h"
#include "ConfigurationManager_api.h"
#include "PreAggregator_Api.h"
#include "Bsrc_Api.h"
#include "MacHtExtensionsRegs.h"
#include "frame.h"
#include "TxPdAcc_Api.h"

#endif //ENET_INC_ARCH_WAVE600

#ifdef WORKAROUND_FOR_BFEE_SUB_BAND_HW_BUG
#include "PacDelRegs.h"
#endif //WORKAROUND_FOR_BFEE_SUB_BAND_HW_BUG

#ifdef WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG
#include "TxSender_ScratchPadApi.h"
#endif //WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_PAC_MANAGER
#define LOG_LOCAL_FID 1
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define EXTRACT_VAP_MANAGER_MSG(M)		pK_MSG_DATA((K_MSG *) (*((uint32 *)pK_MSG_DATA(M))))

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void PacManagerSetRxd(void);
static void PacManagerSetBssFilterStatus(uint8 vapId, RxfFilterStatus_e status);
static void PacManagerStart(K_MSG *psMsg);
static void PacManagerSetBssFilterStatus(uint8 vapId, RxfFilterStatus_e status);
static void PacManagerAddVap(K_MSG *psMsg);
static void PacManagerPostAddVap(K_MSG *psMsg);
static void PacManagerRssiActivation(K_MSG *psMsg);
static void PacManagerNormalActivation(K_MSG *psMsg);
static void PacManagerSetBss(K_MSG *psMsg);
static void PacManagerDeactivateVap(K_MSG *psMsg);
static void PacManagerPostVapActivation(K_MSG *psMsg);
static void PacManagerSendCfmToVapManager(uint8 eventIndex, uint8 vapIndex, uint8 clientId);	
static void PacManagerSetBeaconTemplate(K_MSG *psMsg);
static void PacManagerBeaconCsaStart(K_MSG *psMsg);
static void PacManagerBeaconCsaStop(K_MSG *psMsg);
static void PacManagerBeaconCsaLock(K_MSG *psMsg);
static void PacManagerBeaconCsaPd(K_MSG *psMsg);
static void PacManagerBeaconQueueIsLocked(K_MSG *psMsg);
static void PacManagerBeaconQueueIsDisabled(K_MSG *psMsg);
static void PacManagerPsSettingsFifoNotEmpty(K_MSG *psMsg);
static void PacManagerRequestSid(K_MSG *psMsg);
static void PacManagerRemoveSid(K_MSG *psMsg);
static void PacManagerUpdateVapTimingParams(K_MSG *psMsg);
static void PacManagerBeaconBlockingSet(K_MSG *pMsg);
static void PacManagerBeaconBlockingStart(K_MSG *pMsg);
static void PacManagerBeaconBlockingStop(K_MSG *pMsg);
static void PacManagerBeaconBlockingRestart(K_MSG *pMsg);
static void PacManagerBeaconBlockingTimer(K_MSG *pMsg);
static void PacManagerCpuLoadReq(K_MSG *pMsg);
static void PacManagerGetAggWithNoBaAgreement(K_MSG *psMsg);
static void PacManagerSetAggWithNoBaAgreement(K_MSG *psMsg);
static void PacManagerSetMinimalRssiThreshold(K_MSG *psMsg);
#if defined (ENET_INC_ARCH_WAVE600)
static void PacManagerAddStation(K_MSG *psMsg);
static void PacManagerRemoveStation(K_MSG *psMsg);
static void PacManagerSendCfmToStationManager(StaId stationId);
static void	PacManagerBeaconBssLoadIeAdmissionCapacity(K_MSG *psMsg);
static void PacManagerSetSnifferUdpHeader(K_MSG *psMsg);
static void PacManagerLoggerFillMsgHdrTemplate(K_MSG *psMsg);
static void PacManagerSetBand(K_MSG *psMsg);
static void PacManagerAutoRespFifoNotEmpty(K_MSG *psMsg);
static void PacManagerSetForceProtection(K_MSG *psMsg);
static void PacManagerSetMuTrainingBwLimit(K_MSG *psMsg);
static void PacManagerHandleStatusFifoEvent(K_MSG *psMsg);
static void PacManagerHandleOtfaFifoEvent(K_MSG *psMsg);
static void PacManagerHandleSetChannelEvent(K_MSG *pMsg);
static void PacManagerHandleUlprFifoNotEmptyEvent(K_MSG* pMsg);
static void PacManagerHandlePreAggFifoNotEmptyEvent(K_MSG* pMsg);
static void PacManagerPreAggEtsiPpduDurationLimitsReq(K_MSG *pMsg);
static void PacManagerSetMgmtRetryLimitReq(K_MSG *pMsg);
static void PacManagerSetApBeacnInfo(K_MSG *psMsg);


#endif // ENET_INC_ARCH_WAVE600
#if defined (ENET_INC_ARCH_WAVE600D2)
static void PacManagerBsrcNdpfReportFifoNotEmpty(K_MSG *psMsg);
#endif
#ifdef RXH_MAILBOX_TEST	
static void PacManagerRxhMailboxTest(K_MSG *psMsg);
#endif // RXH_MAILBOX_TEST

extern void vStartReq(K_MSG * ptK_MSG);
extern BeaconHandlerVapDb_t beaconHandlerVapdb[HW_NUM_OF_VAPS]; 


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
static const FunctionEntry_t afpTaskTable[TASK_PAC_MANAGER_END - TASK_PAC_MANAGER_START]=
{
	{PacManagerStart,							DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_START_REQ)},
	{PacManagerAddVap,							DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_ADD_VAP_REQ)},
	{PacManagerPostAddVap,						DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_POST_ADD_VAP_REQ)},
	{PacManagerRssiActivation,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_ACTIVATE_RSSI_REQ)},
	{PacManagerNormalActivation,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_ACTIVATE_NORMAL_REQ)},
	{PacManagerSetBss,							DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_BSS_REQ)},
	{PacManagerPostVapActivation,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_POST_VAP_ACTIVATION)},
	{PacManagerDeactivateVap,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_REMOVE_VAP_REQ)}, 
	{PacManagerSetBeaconTemplate,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_BEACON_TEMPLATE_REQ)},
	{PacManagerBeaconCsaStart,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_CSA_START)},
	{PacManagerBeaconCsaStop,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_CSA_STOP)},
	{PacManagerBeaconCsaLock,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_CSA_LOCK)},
	{PacManagerBeaconCsaPd, 					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_CSA_PD)},
	{PacManagerBeaconQueueIsLocked, 			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_QUEUE_IS_LOCKED)},
	{PacManagerBeaconQueueIsDisabled,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_QUEUE_IS_DISABLED)},
	{PacManagerPsSettingsFifoNotEmpty,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_PS_SETTINGS_FIFO_NOT_EMPTY)},
	{PacManagerRequestSid,						DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_REQUEST_SID_REQ)},
	{PacManagerRemoveSid,						DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_REMOVE_SID_REQ)},	
	{PacManagerUpdateVapTimingParams, 			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_UPDATE_VAP_TIMING_PARAMETERS)},
	{PacManagerGetAggWithNoBaAgreement,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_GET_AGG_WITH_NO_BA_FIFO)},
	{PacManagerSetAggWithNoBaAgreement, 		DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_AGG_WITH_NO_BA_FIFO)},
	{PacManagerSetMinimalRssiThreshold, 		DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_MIN_RSSI_THRESHOLD)},
	{PacManagerBeaconBlockingSet,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_BLOCKING_SET)}, 	
	{PacManagerBeaconBlockingStart,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_BLOCKING_START)}, 	
	{PacManagerBeaconBlockingStop,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_BLOCKING_STOP)}, 	
	{PacManagerBeaconBlockingRestart,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_BLOCKING_RESTART)},	
	{PacManagerBeaconBlockingTimer,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BEACON_BLOCKING_TIMER)}, 
	{PacManagerCpuLoadReq,						DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_STATISTICS_CPU_LOAD_REQ)},	
#if defined (ENET_INC_ARCH_WAVE600)	
	{PacManagerAddStation,						DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_ADD_STATION_REQ)},
	{PacManagerRemoveStation,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_REMOVE_STATION_REQ)},
	{PacManagerSetSnifferUdpHeader, 			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_SNIFFER_UDP_HDR_REQ)},
	{PacManagerLoggerFillMsgHdrTemplate, 		DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_LOGGER_FILL_MSG_HEADER_TEMPLATE_REQ)},
	{PacManagerSetBand,							DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_BAND_REQ)},
	{PacManagerAutoRespFifoNotEmpty,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_AUTO_RESPONSE_ERROR_FIFO_NOT_EMPTY)},		
	{PacManagerSetForceProtection,				DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_FORCE_PROTECTION)},
	{PacManagerSetMuTrainingBwLimit,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_MU_TRAINING_BW_LIMIT)},
	{PacManagerHandleStatusFifoEvent,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_STATUS_FIFO_NOT_EMPTY)},
	{PacManagerHandleOtfaFifoEvent, 			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_OTF_AGGR_FIFO_NOT_EMPTY)},
	{PacManagerHandleSetChannelEvent,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_CHANNEL_IND)},
	{PacManagerHandleUlprFifoNotEmptyEvent,		DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_ULPR_FIFO_NOT_EMPTY)},
	{PacManagerHandlePreAggFifoNotEmptyEvent, 	DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_PRE_AGG_FIFO_NOT_EMPTY)},
#endif //defined (ENET_INC_ARCH_WAVE600)	
#ifdef RXH_MAILBOX_TEST
	{PacManagerRxhMailboxTest, 					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_RXH_MAILBOX_TEST)},
#endif // RXH_MAILBOX_TEST
#if defined (ENET_INC_ARCH_WAVE600)
	{PacManagerBeaconBssLoadIeAdmissionCapacity,DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_UPDATE_ADMISSION_CAPACITY)},
#endif
#if defined (ENET_INC_ARCH_WAVE600D2)
	{PacManagerBsrcNdpfReportFifoNotEmpty,      DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_BSRC_NDP_FEEDBACK_REPORT_FIFO_NOT_EMPTY)},
#endif
	{PacManagerPreAggEtsiPpduDurationLimitsReq,	DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_PRE_AGG_ETSI_PPDU_DURATION_LIMIT_REQ)},
	{PacManagerSetMgmtRetryLimitReq,			DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_TX_PD_ACC_SET_RETRY_LIMIT_REQ)},
	{PacManagerSetApBeacnInfo,					DOUBLE_CHECK_MSG_TYPE(PAC_MANAGER_SET_AP_BEACON_INFO_REQ)},
};


uint32 PacMngr_LoggerStationIndex = INVALID_LOGGER_SID; 

 
PacManagerGlobalParams_t  PacManagerGlobalParameters;
/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************
PacManager_Task



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void PacManager_Task(K_MSG *psMsg)	
{
	vTaskDispatcher(psMsg, afpTaskTable, TASK_PAC_MANAGER_START, TASK_PAC_MANAGER_END);
}


/**********************************************************************************

PacManager_GetGlobalParams


Description:
------------

Input: 
-----

Returns:
--------
	
**********************************************************************************/
PacManagerGlobalParams_t* PacManager_GetGlobalParams(void)
{
	return &PacManagerGlobalParameters;
}

#if defined (ENET_INC_ARCH_WAVE600)
/**********************************************************************************
isr_PacManager_UlprFifoNotEmpty


Description:
------------
interrupt handler for UL Post Rx Fifo not empty event

Input: 
-----
	
Returns:
--------
	void - 
	
**********************************************************************************/	
void isr_PacManager_UlprFifoNotEmpty(void)
{
	ACCUMULATE_CPU_IDLE_TIME();

	/* Mask all not empty interrupts in HW event */
	
	EventManager_TurnOffEvent(EVENT_ID_ULPR_FIFO_NOT_EMPTY);
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_ULPR_FIFO_NOT_EMPTY, TASK_PAC_MANAGER, VAP_ID_DO_NOT_CARE);	
}

/**********************************************************************************
isr_PacManager_PreAggFifoNotEmpty



Description:
------------
interrupt handler for Pre Aggregator Fifo not empty event

Input: 
-----
	
Returns:
--------
	void - 
	
**********************************************************************************/	

void isr_PacManager_PreAggFifoNotEmpty(void)
{
	ACCUMULATE_CPU_IDLE_TIME();
	
	/* Mask all not empty interrupts in HW event */
	
	EventManager_TurnOffEvent(EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY);
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_PRE_AGG_FIFO_NOT_EMPTY, TASK_PAC_MANAGER, VAP_ID_DO_NOT_CARE);
}


#endif

#ifdef ENET_INC_ARCH_WAVE600D2
/**********************************************************************************
PacManager_ConfigureVapModeBitmap

Description:
------------

Input: 
-----
	
Returns:
--------
	void - 
	
**********************************************************************************/	
void PacManager_ConfigureVapModeBitmap(uint8 vapId, bool vapMode)
{
	RegMacHtExtensionsVapModeBitmap_u macHtExtensionsVapModeBitmap; 

 	RegAccess_Read(REG_MAC_HT_EXTENSIONS_VAP_MODE_BITMAP, &(macHtExtensionsVapModeBitmap.val));
	if(vapMode == VAP_MODE_AP) //AP_MODE
	{
 		Utils_ZeroBitInBitmap(&(macHtExtensionsVapModeBitmap.val), vapId); 
	}
	else //STA_MODE
	{
 		Utils_SetBitInBitmap(&(macHtExtensionsVapModeBitmap.val), vapId); 
	}
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_VAP_MODE_BITMAP, macHtExtensionsVapModeBitmap.val);
}
#endif

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
	
/**********************************************************************************
	
PacManagerSetRxd

	
Description:
------------
		
**********************************************************************************/ 

static void PacManagerSetRxd(void)
{
#ifndef ENET_INC_ARCH_WAVE600 // There is no RxD in gen6
	Pac_RxdConfigureNormalMode();
#endif
#ifdef BEEROCK_DEBUG
	ILOG0_V("[PacManagerSetRxd]---------------------------------------end]");
#endif
}

/**********************************************************************************
PacManagerSetBssFilterStatus





Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerSetBssFilterStatus(uint8 vapId, RxfFilterStatus_e status)
{
	VapDb_t* pVapDbHwEntry;

	if ((PacManagerGlobalParameters.operationMode == OPERATION_MODE_DUT) || (PacManagerGlobalParameters.operationMode == OPERATION_MODE_SNIFFER))
	{
		return;
	}
	pVapDbHwEntry = &VapDbHwEntries[vapId];
	if (pVapDbHwEntry->common.vapMode == VAP_MODE_AP)	
	{	
#if defined (ENET_INC_ARCH_WAVE600)
		Pac_RxcSetBssModeRejectFilterStatus(vapId, RXF_BSS_MODE_AP, status);
#else
		Pac_RxfSetBssModeRejectFilterStatus(vapId, RXF_BSS_MODE_AP, status);
#endif
	}
	else
	{
#if defined (ENET_INC_ARCH_WAVE600)
		Pac_RxcSetBssModeRejectFilterStatus(vapId, RXF_BSS_MODE_STA, status);
#else
		Pac_RxfSetBssModeRejectFilterStatus(vapId, RXF_BSS_MODE_STA, status);
#endif
	}
}

/**********************************************************************************
PacManagerStart




Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerStart(K_MSG *psMsg)
{
	PacManagerStart_t * pacManagerStart = (PacManagerStart_t *)(psMsg->abData);

	PacMngr_LoggerStationIndex = pacManagerStart->loggerStationIndex; 
	vStartReq(psMsg);
	/*Configure RXD*/
	PacManagerSetRxd();
	OSAL_SEND_NO_DATA_MESSAGE(BSS_MANAGE_PAC_START_CFM, TASK_BSS_MANAGE, psMsg->header.vapId);
}

/**********************************************************************************
PacManagerAddVap



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerAddVap(K_MSG *psMsg)	
{
	UMI_ADD_VAP* addVapStructurePtr = (UMI_ADD_VAP*) EXTRACT_VAP_MANAGER_MSG(psMsg);
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.
	uint16 vapMode = VAP_MODE_AP;
	uint8 vapId = addVapStructurePtr->vapId;
#if defined (ENET_INC_ARCH_WAVE600)
	VapDb_t* pVapDbHwEntry;
#endif 

	// store the operation mode of current VAP - note: in DUT and Sniffers mode only one VAP should be up
	PacManagerGlobalParameters.operationMode = addVapStructurePtr->operationMode;
	//Configure Duration table	
	Pac_DurConfigureAutoReplyRate(vapId);
	//Configure vap mode
	//TBD - Get real value from UMI_ADD_VAP params. currently only AP (0) supported not STA (1)
	// Req 2: 4.2.2.2 - save vap mode
	if (addVapStructurePtr->operationMode == OPERATION_MODE_VSTA)
	{
#if defined (ENET_INC_ARCH_WAVE600B)
		// mark the vap as station mode vap for auto response uses 
		AutoResponse_SetVapAsStaMode(vapId);
#endif
		vapMode = VAP_MODE_STA;
	}

	Pac_DurConfigureVapMode(addVapStructurePtr->vapId, vapMode);
	//configure Beacon parameters from ADD VAP structure
	// moved to PacManagerSetBss  BeaconHandler_AddVap(addVapStructurePtr);
	// moved to PacManagerSetBss  BeaconBlockingManagerAddVap(addVapStructurePtr->vapId, addVapStructurePtr->beaconInterval);
	beaconHandlerVapdb[vapId].operationMode = (UmiOperationMode_e)addVapStructurePtr->operationMode;
	
	//Increase Added VAPs counter
	PacManagerGlobalParameters.numOfAddedVaps++;
#if defined (ENET_INC_ARCH_WAVE600)
	if (PacManagerGlobalParameters.numOfAddedVaps == 1)
	{
		RxClassifier_HandleRxManagerAddVap(addVapStructurePtr);
	}
	if(addVapStructurePtr->operationMode != OPERATION_MODE_SNIFFER)
	{
		// configure HE Fragment filter
		Pac_RxcSetHeFragViolationFilter(FRAG_LEVEL_ONE_FRAG_PER_TID_IN_AMPDU, vapId); // Currently we assume we support level 2. If needed - we can ask to get the information regarding Fragmentation level support of the VAP from driver.
	}

	/* call header conversion bitmap update */
	pVapDbHwEntry = &VapDbHwEntries[addVapStructurePtr->vapId];
#ifdef ENET_INC_ARCH_WAVE600D2
	PacManager_ConfigureVapModeBitmap(addVapStructurePtr->vapId,pVapDbHwEntry->common.vapMode);
	// Initialize AID in RxC to invalid. For HE STA mode, it will be configured after association to valid AID.
	Pac_RxcSetAidForStaMode(addVapStructurePtr->vapId, 0, FALSE);
#else	
	TxHeaderConversion_ConfigureVapModeBitmap(addVapStructurePtr->vapId,pVapDbHwEntry->common.vapMode);
	OtfAggregator_ConfigureVapModeBitmap(addVapStructurePtr->vapId,pVapDbHwEntry->common.vapMode);
#endif
#endif
	//enable the appropiate ToDS FromDS filter
	PacManagerSetBssFilterStatus(vapId, RXF_FILTER_STATUS_ENABLE);

	//Indicate VAP_ID in bitmap
	PacManagerGlobalParameters.vapIdBitMap |= (1<<addVapStructurePtr->vapId);

	/* Send message to BSS manager - confirm on Add vap event  */
	PacManagerSendCfmToVapManager(VAP_MANAGER_ADD_VAP, vapId, BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
}

/**********************************************************************************
PacManagerNormalActivation


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerNormalActivation(K_MSG *psMsg)	
{
#if defined (ENET_INC_ARCH_WAVE600)
	UNUSED_PARAM(psMsg);
	ASSERT(0); // BEEROCK feature (rssi) is not supported in gen6 yet. Also - There is no RXF/RXD in gen6.
#else
	RssiParams_t* pRssiParams = (RssiParams_t *)pK_MSG_DATA(psMsg);
	uint8 vapId = pRssiParams->vapId;
			
	Pac_RxdInit();
	Pac_RxdLoadConditionMatrix();
	PacManagerSetRxd();

	Pac_RxfInit();
	Pac_RxfNormalVapId(vapId);

#ifdef	BEEROCK_DEBUG
	ILOG0_V("[PacManagerNormalActivation] -------------------------------------------end]");
#endif

	//send confirmation
	OSAL_SEND_NO_DATA_MESSAGE(RX_MANAGER_CLASSIFIER_NORMAL_MODE, TASK_RX_MANAGER,GET_DEFAULT_VAP_FOR_MY_BAND()); 
	
	/*Start Beacon Blocking Mechanism*/
	BeaconBlockingManagerStart(psMsg);
#endif
}

/**********************************************************************************
PacManagerRssiActivation


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerRssiActivation(K_MSG *psMsg)	
{
#if defined (ENET_INC_ARCH_WAVE600)
	UNUSED_PARAM(psMsg);
	ASSERT(0); // BEEROCK feature (rssi) is not supported in gen6 yet. There is no RXF/RXD in gen6.
#else	
	bool 	rssiModeEnable = ENABLED;
	RssiParams_t* pRssiParams = (RssiParams_t *)pK_MSG_DATA(psMsg);
	IEEE_ADDR* pAddr = (IEEE_ADDR*)&pRssiParams->au8Addr;
	uint8 vapId = pRssiParams->vapId;

    // Configure RXD to fit RSSI mode
	Pac_RxdConfigureRssiMode();
    // Configure RX filter to receive specific MAC address in RSSI mode
	Pac_RxfSetMACAddressfilter(vapId, pAddr, rssiModeEnable);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[PacManagerRssiActivation]----------------------------------end]");
#endif
	//send confirmation
	OSAL_SEND_NO_DATA_MESSAGE(RX_MANAGER_CLASSIFIER_RSSI_MODE, TASK_RX_MANAGER, vapId); 
	/*Stop Beacon Blocking Mechanism*/
	BeaconBlockingManagerStop(psMsg);
#endif
}

/**********************************************************************************
PacManagerPostAddVap

Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerPostAddVap(K_MSG *psMsg)	
{
	UMI_ADD_VAP* 	addVapStructurePtr = (UMI_ADD_VAP*) EXTRACT_VAP_MANAGER_MSG(psMsg);
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.
#ifndef ENET_INC_ARCH_WAVE600
	bool 			rssiModeEnable = DISABLED;
#endif

	//extract vapId
	uint8 vapId = addVapStructurePtr->vapId; 
	if (addVapStructurePtr->operationMode != OPERATION_MODE_SNIFFER)
	{
		// Configure RX filter
#if defined (ENET_INC_ARCH_WAVE600)
		Pac_RxcSetMACAddressfilter(vapId,&(addVapStructurePtr->sBSSID));
#else
		Pac_RxfSetMACAddressfilter(vapId, &(addVapStructurePtr->sBSSID), rssiModeEnable);
#endif
	}
	else /*sniffer mode*/
	{
#if defined (ENET_INC_ARCH_WAVE600)
		//configure Rxc: disable filters, disable autoreplaym, recignize all frames as designated to VAP 0
		ILOG2_V("-------- RXC set Sniffer mode configuration --------");
		Pac_RxcSnifferModeConfiguration(ConfigurationManager_GetBandForVap(vapId)); 
#else// ! ENET_INC_ARCH_WAVE600
		//configure RxF to recignize all frames as designated to VAP 0
		Pac_RxfUseFixedVapId(vapId);
		ILOG2_V("-------- RXF configured for Sniffer --------"); 
		//Enable first matrix line only and zero it in order to insure that all packets will pass the RxD filters and that CB pointer will move 
		Pac_RxdConfigureBypassMode();	
		ILOG2_V("-------- RXD configured for Sniffer --------"); 
		//configure reserved place in phy header and disable rssi abort
		Pac_RxcSetReservedStorageSize(FRAME_PREFIX_SNIFFER_RESERVED_LENGTH_IN_WORDS);
		ILOG2_V("-------- RXC reserved storage size configured for Sniffer --------");
		//disable rssi abort in rxc
		Pac_RxcDisableRssiAbort();
		ILOG2_V("-------- RXC Rssi abort disabled for Sniffer --------");
#endif 
		ILOG2_V("-------- Sniffer configuration done! --------");
	}
	// Enable RXC on the first VAP
	if (PacManagerGlobalParameters.numOfAddedVaps == 1)
	{
		Pac_RxcEnable();
	}

	/* Send message to BSS manager - confirm on Post Vap Addition event  */
	PacManagerSendCfmToVapManager(VAP_MANAGER_POST_VAP_ADDITION, vapId, BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
}

/**********************************************************************************
PacManagerSetBss


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerSetBss(K_MSG *psMsg)
{
	UMI_SET_BSS* setBssStructurePtr = (UMI_SET_BSS*) EXTRACT_VAP_MANAGER_MSG(psMsg);
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.
	uint8 vapId = setBssStructurePtr->vapId;

	/*Check if first SET BSS*/
	if ((PacManagerGlobalParameters.vapSetBssBitMap & (1 << setBssStructurePtr->vapId)) == 0)
	{
		/*Set SET BSS bit*/
		PacManagerGlobalParameters.vapSetBssBitMap |= (1 << setBssStructurePtr->vapId);
		/*Pass VHT flag to Beacon Handler*/
		BeaconHandler_SetVapVHT(setBssStructurePtr->vapId, MTLK_BFIELD_GET(setBssStructurePtr->flags, VAP_ADD_FLAGS_VHT));
	}
	/*call TIM to handle Slot time*/
	vSetSlotDuration11g(setBssStructurePtr->slotTime);
	/* Send message to BSS manager - confirm on Set Bss event  */
	PacManagerSendCfmToVapManager(VAP_MANAGER_SET_BSS, vapId, BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
}

/**********************************************************************************
PacManagerSetApBeacnInfo



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerSetApBeacnInfo(K_MSG *psMsg)
{
	UMI_SET_AP_BEACON_INFO* setApBeaconInfoStructurePtr = (UMI_SET_AP_BEACON_INFO*) pK_MSG_DATA(psMsg);
	uint8 vapId = setApBeaconInfoStructurePtr->vapId;

	/* Configure Beacon parameters from ADD VAP structure */
	BeaconHandler_AddVap(setApBeaconInfoStructurePtr);
	BeaconBlockingManagerAddVap(vapId, setApBeaconInfoStructurePtr->beaconInterval);

	if (setApBeaconInfoStructurePtr->Status == UMI_OK)
	{
		OSAL_SEND_MESSAGE(QOS_ADD_VAP, TASK_QOS, psMsg, vapId);
	}
	else
	{
		OSAL_SEND_MESSAGE(UMI_MC_SET_AP_BEACON_INFO_CFM, TASK_UM_IF_TASK, psMsg, vapId);
	}
}

/**********************************************************************************
PacManagerSetBeaconTemplate




Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerSetBeaconTemplate(K_MSG *psMsg)	
{
	BeaconHandler_TemplateUpdate(psMsg);
}

/**********************************************************************************
PacManagerDeactivateVap




Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerDeactivateVap(K_MSG *psMsg)	
{
	UMI_REMOVE_VAP* removeVapStructurePtr = (UMI_REMOVE_VAP *)EXTRACT_VAP_MANAGER_MSG(psMsg);	
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.
	uint8 vapId;
	
	vapId = removeVapStructurePtr->vapId; 

#if defined (ENET_INC_ARCH_WAVE600)
	Pac_RxcClearAddressFilter(vapId);
#else
	Pac_RxfClearAddressFilter(vapId);
#endif
	//disable the appropiate ToDS FromDS filter
	PacManagerSetBssFilterStatus(vapId, RXF_FILTER_STATUS_DISABLE);
	if (VapDbHwEntries[vapId].common.vapMode != VAP_MODE_STA)
	{
		BeaconHandler_BeaconDeactivate(psMsg);
	}
	else
	{
		FILL_VAP_MANAGER_CONFIRM_MSG(psMsg,vapId,VAP_MANAGER_REMOVE_VAP,BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
		OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psMsg,vapId);
	}
	//Decrease Added VAPs counter
	PacManagerGlobalParameters.numOfAddedVaps--;
	PacManagerGlobalParameters.vapIdBitMap &= ~(1<<vapId);
	PacManagerGlobalParameters.vapSetBssBitMap &= ~(1<<vapId);
#ifndef ENET_INC_ARCH_WAVE600
	// Disable RXC on the last VAP
	if (PacManagerGlobalParameters.numOfAddedVaps == 0)
	{
		Pac_RxcDisable();
	}	
#endif
}

/**********************************************************************************
PacManagerPostVapActivation




Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerPostVapActivation(K_MSG *psMsg)  
{
	UMI_SET_WMM_PARAMETERS* setWmmParamsStructurePtr = (UMI_SET_WMM_PARAMETERS*)EXTRACT_VAP_MANAGER_MSG(psMsg);
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.
	uint8 vapId = setWmmParamsStructurePtr->vapId;

	DEBUG_ASSERT(vapId < HW_NUM_OF_VAPS);
	//configure Beacon HW and enable beacon queues 
	if (VapDbHwEntries[setWmmParamsStructurePtr->vapId].common.vapMode != VAP_MODE_STA)
	{
		BeaconHandler_SetWmmParameters(vapId);
	}

	/* Send message to BSS manager - confirm on Post Vap Activation event  */
	PacManagerSendCfmToVapManager(VAP_MANAGER_POST_VAP_ACTIVATION, vapId, BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
}


/**********************************************************************************
PacManagerSendCfmToVapManager

Description:
------------
Send confirmation to Vap Manager for registered event

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerSendCfmToVapManager(uint8 eventIndex, uint8 vapIndex, uint8 clientId)	
{
	K_MSG* psNewMsg;  
	BSS_MANAGER_CONFIRM_EVENT* confirmEvent; 	
	
	psNewMsg = OSAL_GET_MESSAGE(sizeof(BSS_MANAGER_CONFIRM_EVENT));
	confirmEvent = ((BSS_MANAGER_CONFIRM_EVENT *)psNewMsg->abData);
	confirmEvent->vapId = vapIndex;
	confirmEvent->eventIndex = (vapManagerEvents_e)eventIndex; 
	confirmEvent->clientId = clientId; 
	OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psNewMsg, vapIndex); 
}

void PacManagerSendCfmToVapManagerForRemoveVap(uint8 vapIndex)	
{
	PacManagerSendCfmToVapManager(VAP_MANAGER_REMOVE_VAP, vapIndex, BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
}



static void PacManagerBeaconCsaStart(K_MSG *psMsg)
{
	/*Call Beacon CSA Handler*/
	BeaconHandler_BeaconCsaStart(psMsg);
}

static void PacManagerBeaconCsaStop(K_MSG *psMsg)
{
	/*Call Beacon CSA Handler*/
	BeaconHandler_BeaconCsaStop(psMsg);
}

static void PacManagerBeaconCsaLock(K_MSG *psMsg)
{
	BeaconHandler_BeaconCsaLock(psMsg);
}

static void PacManagerBeaconCsaPd(K_MSG *psMsg)
{
	/*Call Beacon CSA Handler*/
	BeaconHandler_BeaconCsaPd(psMsg);
}

static void PacManagerBeaconQueueIsLocked(K_MSG *psMsg)
{
	BeaconHandler_QueueIsLocked(psMsg);
}

static void PacManagerBeaconQueueIsDisabled(K_MSG *psMsg)
{
	BeaconHandler_QueueIsDisabled(psMsg);
}

static void PacManagerPsSettingsFifoNotEmpty(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
#if defined (ENET_INC_ARCH_WAVE600)
	PsManager_PsSettingsFifoNotEmpty();

#if defined(ENET_INC_LMAC0)
	HwEvents_UnMaskEvent_A_Band0(HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY);
#elif  defined (ENET_INC_LMAC1)
	HwEvents_UnMaskEvent_A_Band1(HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY);

#endif
	
#else
	ASSERT(0); // We should only be in this function if we are  in wave600. In wave500 we should have been in TX MANAGER in UM.
#endif
}


static void PacManagerRequestSid(K_MSG *psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
	UMI_REQUEST_SID* pUmiSidRequest = (UMI_REQUEST_SID*)psMsg->abData;
	pUmiSidRequest->u16SID = Mac2Index_AddStation(&pUmiSidRequest->sAddr);
	ASSERT(pUmiSidRequest->u16SID != PacMngr_LoggerStationIndex);
	pUmiSidRequest->u8Status = UMI_OK;
	OSAL_SEND_MESSAGE(STATISTICS_MANAGER_ADD_NEW_SID, TASK_STATISTICS_MANAGER, psMsg, psMsg->header.vapId);
	Pac_RxcSetStaFrameClass(pUmiSidRequest->u16SID, FRAME_CLASS_3);
#else
	ASSERT(0); // We should only be in this function if we are  in wave600.
#endif

}

static void PacManagerRemoveSid(K_MSG *psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
	UMI_REMOVE_SID* pUmiSidRemove = (UMI_REMOVE_SID*)psMsg->abData;

	Mac2Index_RemoveStationById(pUmiSidRemove->u16SID);
	pUmiSidRemove->u8Status = UMI_OK;	
	
	Pac_RxcSetStaFrameClass(pUmiSidRemove->u16SID, FRAME_CLASS_2);
	OSAL_SEND_MESSAGE(STATISTICS_MANAGER_REMOVE_SID, TASK_STATISTICS_MANAGER, psMsg, psMsg->header.vapId);
#else
	ASSERT(0); // We should only be in this function if we are  in wave600.
#endif
}

static void PacManagerUpdateVapTimingParams(K_MSG *psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
	UMI_SET_WMM_PARAMETERS* setWmmMessageParameters = (UMI_SET_WMM_PARAMETERS*) EXTRACT_VAP_MANAGER_MSG(psMsg);	
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.


	// In wave500 it is done in UM.
	TxHandler_UpdateVapTimingParameters(setWmmMessageParameters);

	FILL_VAP_MANAGER_CONFIRM_MSG(psMsg, setWmmMessageParameters->vapId, VAP_MANAGER_SET_WMM_PARAMS, BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT);
	OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psMsg, setWmmMessageParameters->vapId);

	
#else
	ASSERT(0); // We should only be in this function if we are  in wave600.
#endif
}

static void PacManagerGetAggWithNoBaAgreement(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
#if defined (ENET_INC_ARCH_WAVE600)
	K_MSG* pNewMsg = OSAL_GET_MESSAGE(sizeof(RxfFifoParameters_t));
	RxfFifoParameters_t* pFifoParameters = (RxfFifoParameters_t*)pK_MSG_DATA(pNewMsg);

	memset(pFifoParameters, 0, sizeof(RxfFifoParameters_t));
	Pac_RxcGetFifoParameters(pFifoParameters);
	
	OSAL_SEND_MESSAGE(TS_MANAGER_ILLEGAL_PACKET, TASK_TS_MANAGER, pNewMsg, GET_DEFAULT_VAP_FOR_MY_BAND());
#else
	ASSERT(0); // We should only be in this function if we are  in wave600.
#endif
}


static void PacManagerSetAggWithNoBaAgreement(K_MSG *psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
	RxfFifoParameters_t* pFifoParameters = (RxfFifoParameters_t*)pK_MSG_DATA(psMsg);

	Pac_RxcSetFifoParameters(pFifoParameters);
#if defined(ENET_INC_LMAC0)	
	HwEvents_UnMaskEvent_A_Band0(HW_EVENT_RXF_FIFO_NOT_EMPTY);
#elif defined (ENET_INC_LMAC1)
	HwEvents_UnMaskEvent_A_Band1(HW_EVENT_RXF_FIFO_NOT_EMPTY);
#endif

#else
	UNUSED_PARAM(psMsg);
	ASSERT(0); // We should only be in this function if we are  in wave600.
#endif
}

static void PacManagerSetMinimalRssiThreshold(K_MSG *psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
	UMI_RX_TH* pRxThParam = (UMI_RX_TH*)pK_MSG_DATA(psMsg);

	Pac_RxcUpdateMinimalRssiThreshold(pRxThParam->rxThValue);

	//send confirm to host
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_RX_TH_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

#else
	UNUSED_PARAM(psMsg);
	ASSERT(0); // We should only be in this function if we are  in wave600.
#endif
}

#if defined (ENET_INC_ARCH_WAVE600)
/**********************************************************************************
PacManagerAddStation


Description:
------------
Registered to ADD STA event, init STA BSRC memory

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerAddStation(K_MSG *psMsg)
{
	BssManagerStaManagerReq_t*	pStationManagerRequest      = NULL;
	K_MSG*						originalAddStationMessage   = NULL;
	UMI_STA_ADD*				addStationMessageParameters = NULL;
	StaId						stationIndex;
#ifdef ENET_INC_ARCH_WAVE600D2
	HE_MAC_PHY_CAPABILITIES_INFO *heMacPhyCapInfo = NULL;
	bool						  nfrpSupport     = FALSE;
#endif

	pStationManagerRequest      = (BssManagerStaManagerReq_t *)pK_MSG_DATA(psMsg);
	originalAddStationMessage   = pStationManagerRequest->psMsg;
	addStationMessageParameters = (UMI_STA_ADD *)pK_MSG_DATA(originalAddStationMessage);
    stationIndex 				= addStationMessageParameters->u16SID;

	//BSRC init per STA, the order is:
	// 1. Init counter to '0' - will also clear bit-selector
	// 2. unmask all TIDs
	
	// 1. Init all counters to '0'
	Bsrc_Command(stationIndex, TID_BITMAP_ALL_DATA_TIDS, 0, BSRC_COMMAND_INIT);

	// 2. Unmask all TIDs counters - selector will be cleared because BSRC set to 0
	Bsrc_Command(stationIndex, TID_BITMAP_ALL_DATA_TIDS, 0, BSRC_COMMAND_UNMASK);
	
#ifdef ENET_INC_ARCH_WAVE600D2
	//Update bsrc with support nfrp stations
	heMacPhyCapInfo = (HE_MAC_PHY_CAPABILITIES_INFO *)addStationMessageParameters->u8HE_Mac_Phy_Cap_Info;
	nfrpSupport 	= (bool)heMacPhyCapInfo->heMacCapInfo.HE_MAC_NDP_FEEDBACK_REPORT_SUPPORT;
	Bsrc_UpdateStationNfrpSupport(stationIndex, nfrpSupport);
	if ((VapDbHwEntries[addStationMessageParameters->u8VapIndex].common.vapMode == VAP_MODE_STA) && (MTLK_BFIELD_GET(addStationMessageParameters->u8FlagsExt, STA_ADD_FLAGS_EXT_IS_HE) == TRUE))
	{
		// In case of STA mode which connected to HE AP - configure RxC with AID for TF receive purpose (Should be invalid for AP mode or legacy STA mode connection).
		Pac_RxcSetAidForStaMode(addStationMessageParameters->u8VapIndex, addStationMessageParameters->u16AID, TRUE);
		// In case of STA mode which connected to HE AP - configure BAA with AID for M-BA receive purpose
		BaAnalyzer_SetAidForStaMode(addStationMessageParameters->u16AID);
	}
#endif

	// Send msg confirm back to BSS manager
	PacManagerSendCfmToStationManager(stationIndex);
}
/**********************************************************************************
PacManagerRemoveStation


Description:
------------
Registered to REMOVE STA event

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerRemoveStation(K_MSG *psMsg)
{
	BssManagerStaManagerReq_t* staManagerReq;
	UMI_STOP_TRAFFIC*		   pRemoveSta;
	uint16					   staId;
	
	staManagerReq = (BssManagerStaManagerReq_t *)pK_MSG_DATA(psMsg);
	pRemoveSta = (UMI_STOP_TRAFFIC *)pK_MSG_DATA(staManagerReq->psMsg); 	  
	staId = pRemoveSta->u16SID;
	
#ifdef ENET_INC_ARCH_WAVE600D2
	// STA has disconnected - back to invalid AID
	Pac_RxcSetAidForStaMode(staManagerReq->psMsg->header.vapId, 0, FALSE);
	BaAnalyzer_SetAidForStaMode(0);
#endif
	// Send msg confirm back to BSS manager
	PacManagerSendCfmToStationManager(staId);
}

/**********************************************************************************
PacManagerSendCfmToStationManager


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void PacManagerSendCfmToStationManager(StaId stationId)
{
	K_MSG *pMsg;
	BssManagerStaManagerCfm_t *pConfirmMessage;
	
	/*Allocate message*/
	pMsg = OSAL_GET_MESSAGE(sizeof(BssManagerStaManagerCfm_t));
	pConfirmMessage = (BssManagerStaManagerCfm_t*) pK_MSG_DATA(pMsg);
	/*Set Client ID to the registered ID*/
	pConfirmMessage->clientId = BSS_MANAGER_STA_MANAGER_PAC_CLIENT;
	/*Set STA ID*/
	pConfirmMessage->sid = stationId;
	/*Send confirmation message*/
	OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_REG_CFM, TASK_BSS_MANAGER, pMsg, VAP_ID_DO_NOT_CARE);
}

static void PacManagerBeaconBssLoadIeAdmissionCapacity(K_MSG *psMsg)
{
	BeaconHandlerUpdateBssLoadIeAdmissionCapacity(psMsg);
}
static void PacManagerSetSnifferUdpHeader(K_MSG *psMsg)
{
	UMI_ADD_STREAM_REQ_t* addStreamStructurePtr;

	addStreamStructurePtr = (UMI_ADD_STREAM_REQ_t*) pK_MSG_DATA(psMsg);
	RxHandler_SetUdpHeader(addStreamStructurePtr); 

	OSAL_SEND_MESSAGE(UMI_MC_MAN_ADD_STREAM_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

static void PacManagerLoggerFillMsgHdrTemplate(K_MSG *psMsg)
{
	HwLoggerHeader_t* hwLoggerHeaderPtr = (HwLoggerHeader_t*) pK_MSG_DATA(psMsg);

	logFillMsgHdrTemplate(hwLoggerHeaderPtr);
}


static void PacManagerSetBand(K_MSG *psMsg)
{
	UMI_HDK_CONFIG* params = (UMI_HDK_CONFIG*)pK_MSG_DATA(psMsg);

	TxSenderInterface_Send_Band(params->hdkConf.band);

	OSAL_SEND_MESSAGE(UMI_MC_MAN_HDK_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}


static void PacManagerSetForceProtection(K_MSG *psMsg)
{

	UmiDbgCliReq_t* umiDbgCliReq_p = (UmiDbgCliReq_t*)pK_MSG_DATA(psMsg);

	PreAggregator_SetForceProtection(umiDbgCliReq_p->data1,(PreAggForceProtectionMode_e)umiDbgCliReq_p->data2,umiDbgCliReq_p->data3);	

}

static void PacManagerSetMuTrainingBwLimit(K_MSG *psMsg)
{
	uint8* newBw = (uint8*)pK_MSG_DATA(psMsg);
	PreAggregator_SetMuBfTrainingBwLimit((Bandwidth_e)newBw);
}

static void PacManagerHandleStatusFifoEvent(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	baAnalyzer_StatusFifoNotEmptyEventHandler();
}

static void PacManagerHandleOtfaFifoEvent(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	OtfAggregator_ProcessReportQueue();
}



static void PacManagerAutoRespFifoNotEmpty(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	AutoResponse_ErrorFifoNotEmpty();

#if defined (ENET_INC_LMAC0)	
		HwErrors_UnMaskEvent0(HW_ERROR_AUTO_RESPONSE_ERROR_FIFO_NOT_EMPTY);
#elif defined (ENET_INC_LMAC1)
		HwErrors_UnMaskEvent1(HW_ERROR_AUTO_RESPONSE_ERROR_FIFO_NOT_EMPTY);
#endif
}



#if defined (ENET_INC_ARCH_WAVE600D2)
static void PacManagerBsrcNdpfReportFifoNotEmpty(K_MSG *psMsg)
{	
	UNUSED_PARAM(psMsg);	
	Bsrc_reportFifoNotEmptyEventHandler();
	
#if defined (ENET_INC_LMAC0)
		HwEvents_UnMaskEvent_B_Band0(HW_EVENT_BAND_REL_B_BSRC_NDP_FEEDBACK_REPORT_IRQ);
#elif defined (ENET_INC_LMAC1)
		HwEvents_UnMaskEvent_B_Band1(HW_EVENT_BAND_REL_B_BSRC_NDP_FEEDBACK_REPORT_IRQ);
#endif
}
#endif


static void PacManagerHandleSetChannelEvent(K_MSG *pMsg)
{
#if defined(WORKAROUND_FOR_BFEE_SUB_BAND_HW_BUG) || defined(WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG)
	uint32	tempValueForLowestSubband = 0;
#endif //WORKAROUND_FOR_BFEE_SUB_BAND_HW_BUG || WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG
#ifdef	WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG
	TxSender_ScratchPadApiParams_t *pScratchPadApiParams = NULL;
#endif //WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG
	uint16 txopDuration;
	uint8 band = 0;

	PacMngSetChannelParams_t *pacMngMsg = (PacMngSetChannelParams_t*)pK_MSG_DATA(pMsg);

	ASSERT(pacMngMsg->sub_band < 0x8);

	PreAggregator_SetBwToSubBandMappingReg(pacMngMsg->sub_band);

	// Set default TxOP duration for 5G or 2.4G band
	band = HDK_getBand();
	if(BAND_2_4_GHZ == band)
	{
		txopDuration = PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_DEFAULT_24G;
	}
	else
	{
		txopDuration = PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_DEFAULT_5G;
	}

	PreAggregator_SetTxopDuration(txopDuration);

#ifdef	WORKAROUND_FOR_BFEE_SUB_BAND_HW_BUG
	/* Set REG_HOB_REG2HOB_GP0 register with values according to the primary channel - perBW , 
		this register is being used by the BFEE delia recipe  */ 

	//subband calc logic is: starting_subband_per_bw = primary_subband & ~( (2^bw_enum) - 1 )

	//set sub band on the 3 LSBs, set 1 on the MSB which is the first bit of the RU size field
	tempValueForLowestSubband 	 =	((pacMngMsg->sub_band) | (0x1 << 0x7))			<< 0x0;  //1'st byte for 20Mhz 
	tempValueForLowestSubband 	|=	((pacMngMsg->sub_band) & ~0x1) 					<< 0x8;  //2'nd byte for 40Mhz
	tempValueForLowestSubband 	|=	(((pacMngMsg->sub_band) & ~0x3) | (0x1 << 0x7))	<< 0x10; //3'rd byte for 80Mhz 
	tempValueForLowestSubband 	|=	(0x0) 											<< 0x18; //4'th byte for 160Mhz 
	
	RegAccess_Write(REG_PAC_DEL_REG2HOB_GP0,tempValueForLowestSubband);
#endif //WORKAROUND_FOR_BFEE_SUB_BAND_HW_BUG

#ifdef	WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG
	/* Set sender scratchpad entries with values according to the primary channel - perBW */ 

	//logic is: starting_subband_per_bw = primary_subband & ~( (2^bw_enum) - 1 )

	tempValueForLowestSubband 	 =	(pacMngMsg->sub_band)			<< 0x0;  //1'st byte for 20Mhz 
	tempValueForLowestSubband 	|=	((pacMngMsg->sub_band) & ~0x1)	<< 0x8;  //2'nd byte for 40Mhz
	tempValueForLowestSubband 	|=	((pacMngMsg->sub_band) & ~0x3)	<< 0x10; //3'rd byte for 80Mhz 
	tempValueForLowestSubband 	|=	(0x0) 							<< 0x18; //4'th byte for 160Mhz 

	pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B0_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));

	pScratchPadApiParams->lowestSubbandAccordingToPrimarySubbandAndBw = tempValueForLowestSubband;

#endif //WORKAROUND_FOR_HE_PHY_NDP_SUB_BAND_HW_BUG

	OSAL_SEND_NO_DATA_MESSAGE(CHANNEL_SWITCH_MANAGER_SET_NOTIFY_CFM,TASK_CHANNEL_SWITCH_MANAGER,pMsg->header.vapId);
}

static void PacManagerHandleUlprFifoNotEmptyEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	UlPostRx_fifoNotEmptyEventHandler();
	EventManager_TurnOnEvent(EVENT_ID_ULPR_FIFO_NOT_EMPTY);
}

static void PacManagerHandlePreAggFifoNotEmptyEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	PreAggregator_ReportFifoNotEmptyEventHandler();
	EventManager_TurnOnEvent(EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY);
}

#endif //ENET_INC_ARCH_WAVE600

    
/***********************************************************************
* PacManagerPreAggEtsiPpduDurationLimitsReq
* 
* Description:
* ------------
* User may modify the PPDU durtation limits which are configured according to ETSI in order to perform non-etsi-complient tests e.g. voice packets of size 1500 bytes at BW = 20 MCS = 0 NSS = 0.
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void PacManagerPreAggEtsiPpduDurationLimitsReq(K_MSG *pMsg)
{
	UNUSED_PARAM(pMsg);
#ifdef ENET_INC_ARCH_WAVE600B
	PacMngPreAggEtsiPpduDurationLimitsReq_t *pacMngPreAggEtsiPpduDurationLimitsReq = (PacMngPreAggEtsiPpduDurationLimitsReq_t*) pK_MSG_DATA(pMsg);
	
	PreAggregator_SetPpduDurationLimits(pacMngPreAggEtsiPpduDurationLimitsReq->PreAggSetNonEtsiPpduDurationLimitsReq);
#endif	
}


#ifdef RXH_MAILBOX_TEST	
static void PacManagerRxhMailboxTest(K_MSG *psMsg)
{

	FwRxHandlerMailboxFifoInMessage_t* rxhMailboxMessage;

	rxhMailboxMessage = (FwRxHandlerMailboxFifoInMessage_t*) pK_MSG_DATA(psMsg);
	RxHandlerInterface_Mailbox_Push(rxhMailboxMessage); 
	OSAL_SEND_MESSAGE(UMI_DBG_RXH_MAILBOX_TEST, TASK_UM_IF_TASK, psMsg, 0);
}
#endif // RXH_MAILBOX_TEST




/**********************************************************************************

PacManagerBeaconBlockingSet 

Description:
------------
	Set the Beacon Blocking Detection mechanism - called by message from driver

Input: 
-----	
	K_MSG *pMsg	 - 
		
	
**********************************************************************************/
static void PacManagerBeaconBlockingSet(K_MSG *pMsg)
{
	BeaconBlockingManagerSet(pMsg);
	OSAL_SEND_MESSAGE(UMI_MC_MAN_BEACON_BLOCKING_INTERVAL_CFM, TASK_UM_IF_TASK, pMsg, pMsg->header.vapId);
}


/**********************************************************************************

PacManagerBeaconBlockingStart 

Description:
------------
	Start the Beacon Blocking Mechanism	- if required, called when Normal Channel is set

Input: 
-----	
	K_MSG *pMsg	 - 
		
	
**********************************************************************************/
static void PacManagerBeaconBlockingStart(K_MSG *pMsg)
{
	BeaconBlockingManagerStart(pMsg);
}

/**********************************************************************************

PacManagerBeaconBlockingStop 

Description:
------------
	Stop the Beacon Blocking Mechanism	- called when SCAN starts

Input: 
-----	
	K_MSG *pMsg	 - 
		
	
**********************************************************************************/
static void PacManagerBeaconBlockingStop(K_MSG *pMsg)
{
	BeaconBlockingManagerStop(pMsg);
}

/**********************************************************************************

PacManagerBeaconBlockingRestart 

Description:
------------
	Restart the Beacon Blocking Mechanism	- called when CCA is changed so we will report beacons state

Input: 
-----	
	K_MSG *pMsg	 - 
		
	
**********************************************************************************/
static void PacManagerBeaconBlockingRestart(K_MSG *pMsg)
{
	BeaconBlockingManagerRestart(pMsg);
}


/**********************************************************************************

PacManagerBeaconBlockingTimer 

Description:
------------
	Beacon Blocking Mechanism Timer

Input: 
-----	
	K_MSG *pMsg	 - 
		
	
**********************************************************************************/
static void PacManagerBeaconBlockingTimer(K_MSG *pMsg)
{
	BeaconBlockingManagerTimer(pMsg);
}

/***********************************************************************
* PacManagerCpuLoadReq
* 
* Description:
* ------------
* Handle the request from statistics manager tp provide the Lower MAC's cpu load
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void PacManagerCpuLoadReq(K_MSG *statisticsManagerMessage)
{
	K_MSG *pMsg = PNULL;
	/* Send signal to statistics manager with CPU load value */
	StatisticsCpuLoadCnf_t *statisticsCpuLoadCnf = NULL;

	UNUSED_PARAM(statisticsManagerMessage);
	pMsg = OSAL_GET_MESSAGE(sizeof(StatisticsCpuLoadCnf_t));
	statisticsCpuLoadCnf = (StatisticsCpuLoadCnf_t*)pK_MSG_DATA(pMsg);
#if defined(CALCULATE_CPU_IDLE_TIME)
	statisticsCpuLoadCnf->load = 100 - cpuLoadArrayLm[cpuLoadArrayLmIndex]; /* CPU load = 100% - Idle */
	statisticsCpuLoadCnf->cpu = STATISTICS_CPU_LOAD_CPUS_LOWERMAC;
#endif
#if !defined(ENET_INC_ARCH_WAVE600)	
	OSAL_SEND_MESSAGE(STATISTICS_MANAGER_CPU_LOAD_CNF, TASK_STATISTICS_MANAGER, pMsg, GET_DEFAULT_VAP_FOR_MY_BAND());	
#else
	ASSERT(0); // We should not be here in Gen6
#endif
}

/***********************************************************************
* PacManagerSetMgmtRetryLimitReq
* 
* Description:
* ------------
*
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void PacManagerSetMgmtRetryLimitReq(K_MSG *pMsg)
{
	TxPdAcc_SetMgmtRetryLimit(pMsg);
}

/**********************************************************************************


Description:
------------

	Register with Vap Manager for events
	
**********************************************************************************/

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization"
#endif


void PacManager_PostInit(void)
{
	memset(&PacManagerGlobalParameters, 0, sizeof(PacManagerGlobalParams_t));
}

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif







