/***********************************************************************************
 File:			PacketTrafficArbitrator_api.h
 Module:			Packet Traffic Arbitrator
 Purpose: 				2.4GHz coexistance
 Description:		This header is the API to the Packet Traffic Arbitrator module
				which is responsible for arbitrating air-time between WIFI and other 2.4GHz radios.
************************************************************************************/
#ifndef PACKET_TRAFFIC_ARBITRATOR_API_H_
#define PACKET_TRAFFIC_ARBITRATOR_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"

#define MTLK_PACK_ON

#include "mtlkpack.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define	PTA_GPIO_VAL_LOW			(0)
#define	PTA_GPIO_VAL_HIGH			(1)

#define PTA_CCA_NOISY				(0) /* used to set the CCA HW as noisy in order to prevent transmission while granting air time to other radios*/
#define PTA_CCA_QUIET				(1)



//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void PacketTrafficArbitratorTask_Init(void);
void PTA_Task(K_MSG *psMsg);
#ifdef PTA_TEST
void PtaTest(void);
void PtaTestDriverReq(uint8 data3);
void PtaTestEmulateGpio0Int(/* BT_ACTIVE */ uint8 btActiveVal, /* TX_DEMAND */uint8 txDemandVal);
void PtaTestReset(void);
void PtaTestRep(uint8 data2, uint8 data3);
void PtaTestModifyQosParam(uint8 data2, uint8 data3);
void PtaTestTracePtaParams(void);
void PtaTestHandler(uint8 data1, uint8 data2, uint8 data3);
#endif // PTA_TEST
uint32* PtaGetGlobalStatisticsAddress(void);
/*************************************************************************************************************
ISR
**************************************************************************************************************/
void Isr_PtaGpio0(void);
void PtaHandleTimer1Expiry(void);

/* Used for PtaQos table */
typedef enum
{
	PTA_RADIO_TYPE_ZIGBEE,
	PTA_RADIO_TYPE_BT,
	PTA_RADIO_NUM_OF_TYPES,												/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
}PtaRadioType_e;

typedef enum
{
	PTA_STATE_INIT = 0,
	PTA_STATE_IDLE = 1,
	PTA_STATE_BT_DENY = 2,
	PTA_STATE_BT_ALLOW = 3,
	PTA_STATE_BT_POLL = 4,
	PTA_STATE_ZIGBEE_DENY = 5,
	PTA_STATE_ZIGBEE_ALLOW = 6,
	PTA_STATE_ZIGBEE_TX = 7,
	PTA_STATE_ZIGBEE_RX_SHORT = 8,
	PTA_STATE_ZIGBEE_RX_MID = 9,
	PTA_STATE_ZIGBEE_RX_LONG = 10,
	PTA_STATE_ZIGBEE_POLL = 11,
	PTA_STATE_TEST = 12,
	PTA_STATE_NUM_OF_STATES					/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
}PtaStates_e;


typedef enum
{		
	PTA_EVENT_POLL_TIMER_EXPIRED_BT_ACTIVE_LOW_TX_DEMAND_LOW = 0,
	PTA_EVENT_POLL_TIMER_EXPIRED_BT_ACTIVE_LOW_TX_DEMAND_HIGH = 1,
	PTA_EVENT_POLL_TIMER_EXPIRED_BT_ACTIVE_HIGH_TX_DEMAND_HIGH = 2,
	PTA_EVENT_POLL_TIMER_EXPIRED_BT_ACTIVE_MASKED_TX_DEMAND_LOW = 3,
	PTA_EVENT_POLL_TIMER_EXPIRED_BT_ACTIVE_MASKED_TX_DEMAND_HIGH = 4,
	PTA_EVENT_GPIO0_BT_ACTIVE_HIGH_TX_DEMAND_HIGH_TH_REACHED = 5,
	PTA_EVENT_GPIO0_BT_ACTIVE_LOW_TX_DEMAND_HIGH_TH_REACHED = 6,
	PTA_EVENT_GPIO0_BT_ACTIVE_HIGH_TX_DEMAND_HIGH_TH_NOT_REACHED = 7,
	PTA_EVENT_GPIO0_BT_ACTIVE_LOW_TX_DEMAND_HIGH_TH_NOT_REACHED = 8,
	PTA_EVENT_GPIO0_BT_ACTIVE_LOW_TX_DEMAND_HIGH_ZIGBEE_OFF = 9,
	PTA_EVENT_GPIO0_BT_ACTIVE_HIGH_TX_DEMAND_HIGH_BT_OFF = 10,
	PTA_EVENT_STARVATION_TIMER_EXPIRED = 11,
	PTA_EVENT_TEST_COMMAND = 12,	
	PTA_EVENT_NUM_OF_EVENTS			/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
}PtaEvents_e;



typedef struct PtaUniqueRadioParams
{
	bool	bRadioDriverIsUp;											/* TRUE: this radio is active (some platforms may use only ZigBee) */
	uint8 	radioHoldOffValue;											/* Number of requests until PTA should grant air time: 
																			Zero - WIFI may decline forever 
																			N - WIFI must comply at request #N */
	uint8 	starvationTimeValue;										/* Guard time for other radio consecutive TX transaction [milliseconds]. On expiry, WIFI reverts back to normal operations and send error message to Driver */
	uint8 	penaltyTime;												/* After starvation timer has expired for this radio, for how long do we ignore requests from this radio (not incrementing counter) */
}PtaUniqueRadioParams_t;


typedef struct PtaParams
{
	uint16					gratuitousCtsToSelfInterval;				/* Send CTS to SELF once every X [sec]:
																			0 - Do not send. 
																			K - Send gratuitous CTS TO SELF once every K [sec] */
	uint8					gratuitousCtsToSelfPeriod;					/* in case gratuitousCtsToSelf	Interval != 0:
																			0 - Reserved and shall not be used
																			N - For how long to maintain WIFI halt in milliseconds */	
	bool					bUseRepetitionMode;							/* TRUE: use repetition mode */	
	uint32					repetitionSuspend;							/* If bUseRepetitionMode  = TRUE: Defines the inactive WIFI TX period in milliseconds */ 
	uint32					repetitionResume;							/* If bUseRepetitionMode  = TRUE: Defines the active WIFI TX period in milliseconds */
	bool	 				bAllowBeacon; 								/* TRUE: Beacon TX is allowed during other radio TX */
	bool	 				bAllowAutoRply;								/* TRUE: Auto reply (ACK/Block ACK) TX is allowed during other radio TX */
	PtaUniqueRadioParams_t	uniqueRadioParams[PTA_RADIO_NUM_OF_TYPES];	/* Unique radio parameters */	
}PtaParams_t;

typedef struct
{
	bool	enable;														/* TRUE: Repetitio mode will be activated in case at least one COEX radio is active */
	uint32	activePeriod;												/* in case enable = TRUE: holds repetitionResume  value that defines the WIFI active   period */
	uint32	inactivePeriod;												/* in case enable = TRUE: holds repetitionSuspend value that defines the WIFI inactive period */	
}PtaRepConfig_t;

#endif //PACKET_TRAFFIC_ARBITRATOR_API_H_
