/***********************************************************************************
 File:			PacketTrafficArbitratorCommon.h
 Module:			Packet Traffic Arbitrator
 Purpose: 				2.4GHz coexistance
 Description:		This header is common to the WAVE500B				
************************************************************************************/
#ifndef PACKET_TRAFFIC_ARBITRATOR_COMMON_H_
#define PACKET_TRAFFIC_ARBITRATOR_COMMON_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "PacketTrafficArbitrator_api.h"


//---------------------------------------------------------------------------------
//						Debug flags						
//---------------------------------------------------------------------------------
// Turn on/off Traffic Arbitrator module (PTA_STAT and PTA_TRACE use PTA_MONITOR code)
// #define PTA_DEBUG 
#define PTA_MONITOR
//#define PTA_TRACE
//#define PTA_REP_TRACE
#define PTA_STATS

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
/* Packet Traffic Arbitrator Hw Timer States */



typedef struct PtaDb
{
	PtaStates_e				state;
	bool					pendingDriverReq;	/* TRUE: we have a pendinf Driver command. when mooving to IDLE it shall be handled */
	UMI_SET_2_4_G_COEX		driverReq;			/* Holds the last command that the Driver sent */
	UMI_SET_2_4_G_COEX		activeParams;		/* Holds the currently used command */												
	PtaParams_t				ptaParams;			/* Holds the trnaslation from QoS value sent by Driver to parameters used for handling ZigBee and BLE\BT */
	PtaRadioType_e			radioType;			/* Which radio is currently beeing handled by PTA */
	uint8					btCounter;			/* BT hold off counter*/
	uint8					ZigBeeCounter;		/* ZigBee hold off counter*/		
}PtaDb_t;

typedef struct PtaRepetitionParams
{
	bool			enable;
	PtaRepStates	state;
	uint32			activePeriod;
	uint32			inactivePeriod;		
}PtaRepetitionParams_t;


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define PTA_GPIO_DIRECTION_OUT		(1)
#define PTA_GPIO_DIRECTION_IN		(0)

#define PTA_REP_INACTIVE_PERIOD_OFF	(0)
#define PTA_REP_ACTIVE_PERIOD_OFF	(0)

/*************************************************************************************************************
GPIO handlers
**************************************************************************************************************/
void PtaGpioDirection(uint32 gpioName, bool isDirectionOut);
uint32 PtaGpioRead(uint32 ptaGpioName);
void PtaGpioWrite(uint32 ptaGpioName, uint8 ptaGpioVal);
void PtaGpioMaskGpio0(void);
void PtaGpioInitGpioState(void);
void ptaGpioLatchClearGpio0(void);
void ptaGpioUnmsakGpio0(void);
void PtaGpioBtAllow(void);
void PtaGpioBtDeny(void);
void PtaGpioZigBeeAllow(void);
void PtaGpioZigBeeDeny(void);
bool PtaGpioReadGrant(void);
bool PtaGpioReadBtActive(void);
void PtaGpioDirectionGrant(bool isDirectionOut);
void PtaGpioDirectionWlanDeny(bool isDirectionOut);
void PtaGpioWriteGrant(uint8 ptaGpioVal);
#endif // PACKET_TRAFFIC_ARBITRATOR_COMMON_H_
