/***********************************************************************************
 File:			PacketTrafficArbitrator.h
 Module:			Packet Traffic Arbitrator
 Purpose: 				2.4GHz coexistance
 Description:		This is the header file for the Packet Traffic Arbitrator module
				which is responsible for arbitrating air-time between WIFI and other 2.4GHz radios.
************************************************************************************/
#ifndef PACKET_TRAFFIC_ARBITRATOR_H_
#define PACKET_TRAFFIC_ARBITRATOR_H_


//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "EmeraldEnvRegs.h"
#include "EventsManager_api.h"
#include "HwEventsAndErrors_Api.h"
#include "fast_mem_psd2mips.h"
#include "EmeraldEnvRegs.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//#define	PTA_GPIO_NAME_TX_DEMAND	(1)		/* WLAN_GPIO #0  (not PTA's)	*/
//#define	PTA_GPIO_NAME_PRIORITY	(2)		/* WLAN_GPIO #1  (un used) 		*/
//#define	PTA_GPIO_NAME_GRANT		(4)		/* WLAN_GPIO #2 				*/
//#define	PTA_GPIO_NAME_BT_ACTIVE	(8)		/* WLAN_GPIO #3 				*/
//#define	PTA_GPIO_NAME_RESERVED1	(16)	/* WLAN_GPIO #4  (not PTA's) 	*/
//#define	PTA_GPIO_NAME_RESERVED2	(32)	/* WLAN_GPIO #5  (not PTA's) 	*/
//#define	PTA_GPIO_NAME_BT_STATUS	(64)	/* WLAN_GPIO #6  (un used) 		*/
//#define 	PTA_GPIO_NAME_WLAN_DENY (128)	/* WLAN_GPIO #7 				*/
//#define	PTA_GPIO_NAME_RESERVED3	(256)	/* WLAN_GPIO #8  (not PTA's) 	*/
//#define	PTA_GPIO_NAME_RESERVED4	(512)	/* WLAN_GPIO #9  (not PTA's) 	*/
//#define	PTA_GPIO_NAME_RESERVED5	(1024)	/* WLAN_GPIO #10 (For LMAC1 TX_DEMAND is connected here. For LMAC0 TX_DEMAND is connected as in WAVE500 to GPIO_0 */


/* GPIO #									Alternate function				System function */
/* ============================================================================================*/
#define	PTA_GPIO_NAME_0			(1)		/* 0  -  Ext IRQ/CLKOUT						Wlan_disable							*/
#define	PTA_GPIO_NAME_1			(2)		/* 1  -  Ext IRQ/BB_PLL_LOCK output													*/
#define	PTA_GPIO_NAME_2			(4)		/* 2  -  UART TX output																*/
#define	PTA_GPIO_NAME_3			(8)		/* 3  -  UART RX input																*/
#define	PTA_GPIO_NAME_4			(16)	/* 4  -  EE_CLK  I/O																*/
#define	PTA_GPIO_NAME_5			(32)	/* 5  -  EE_DATA I/O																*/
#define	PTA_GPIO_NAME_6			(64)	/* 6  -  CLK_REQ output																*/
#define	PTA_GPIO_NAME_GRANT		(128)	/* 7  -  Grant								Grant ZigBee							*/	
#define	PTA_GPIO_NAME_PRIORITY	(256)	/* 8  -  PCIe strap option MSPS0			Priority ZigBee	(and BT in dual chip)	*/
#define	PTA_GPIO_NAME_WLAN_DENY	(512)	/* 9  -  PCIe strap option MSPS1			wlan deny 								*/
#define	PTA_GPIO_NAME_TX_DEMAND	(1024)	/* 10 -  Ext IRQ							Request									*/
#define	PTA_GPIO_NAME_BT_ACTIVE	(2048)	/* 11 -  Ext IRQ							BT is the requester						*/
#define	PTA_GPIO_NAME_12		(4096)	/* 12 - 																			*/
#define	PTA_GPIO_NAME_13		(8192)	/* 13 - 																			*/
#define	PTA_GPIO_NAME_14		(16384)	/* 14 -  Wake output																*/
#define	PTA_GPIO_NAME_15		(32768)	/* 15 - 																			*/


#define PTA_GPIO_BT_ALLOW							(PTA_GPIO_VAL_LOW)		/* Low in WLAN_DENY (GPIO 7) means we allow BT to TX */
#define PTA_GPIO_ZIGBEE_ALLOW						(PTA_GPIO_VAL_LOW)		/* Low in GRANT	(GPIO 2) means we allow ZigBee to TX */

#define PTA_GPIO_BT_DENY							(PTA_GPIO_VAL_HIGH)		/* High in WLAN_DENY (GPIO 7) means we deny BT to TX */
#define PTA_GPIO_ZIGBEE_DENY						(PTA_GPIO_VAL_HIGH)		/* High in GRANT (GPIO 2) means we deny ZigBee to TX */

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
/* Repetition emulation states */
typedef enum
{
	PTA_REP_STATE_INACTIVE,
	PTA_REP_STATE_WAIT_FOR_ACTIVE_TIMER,
	PTA_REP_STATE_WAIT_FOR_PROCESS_START,
	PTA_REP_STATE_WAIT_FOR_INACTIVE_TIMER,
	PTA_REP_STATE_WAIT_FOR_PROCESS_END,
	PTA_REP_STATE_NUM_OF_STATES,
}PtaRepStates;

//---------------------------------------------------------------------------------
//						Static Function Declaration				
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Global Function Declaration				
//---------------------------------------------------------------------------------

/*************************************************************************************************************
PTA repetition mode 
**************************************************************************************************************/
void PtaRepAssignNewParams(bool enable, uint32 activePeriod, uint32 inactivePeriod);
void PtaRepConfig(K_MSG *ptaRepMessage);
void PtaRepTimerExpiry(K_MSG *ptaRepMessage); 
void PtaRepProcessStart(K_MSG *ptaRepMessage);
void PtaRepProcessEnd(K_MSG *ptaRepMessage);
void PtaRepInit(void);
void PtaInterruptManagerConfigureMacGeneraExternalIrqInvert(void);

#endif //PACKET_TRAFFIC_ARBITRATOR_H_


