/***********************************************************************************
 File:			Pauser_Api.h
 Module:		Pauser 
 Purpose: 		To create a driver for the pauser which pauses Tx and Rx
 Description:   This file is the API of the Pauser module 
				which is responsible of pausing Tx and Rx
************************************************************************************/
#ifndef PAUSER_API_H_
#define PAUSER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Api.h"



//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum
{
	TX_PAUSER_REPETITION_TYPE_INFINITE = 0,
	TX_PAUSER_REPETITION_TYPE_LIMITED = 1,
	TX_PAUSER_REPETITION_NUM_OF_TYPES,
	TX_PAUSER_REPETITION_MAX_NUM_OF_TYPES,
} TxPauserRepetitionType_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum
{
	TX_PAUSER_PAUSE_VAPS = 0x0,
	TX_PAUSER_RESUME_VAPS = 0x1,
	TX_PAUSER_PAUSE_ACS = 0x2,
	TX_PAUSER_RESUME_ACS = 0x3,
	TX_PAUSER_PAUSE_ALL = 0x4,
	TX_PAUSER_RESUME_ALL = 0x5,
	TX_PAUSER_LAST_REGULAR_PAUSE_RESUME_COMMAND  = TX_PAUSER_RESUME_ALL,
	TX_PAUSER_START_REPETITION = 0xC,
	TX_PAUSER_END_REPETITION = 0xD,
	TX_PAUSER_NUM_OF_COMMANDS,
	TX_PAUSER_MAX_NUM_OF_COMMANDS = 0xFF,
} TxPauserCommand_e;



typedef enum TxPauseAcTypes
{
	TX_PAUSE_ALL_ACS_EXCEPT_BEACON_AND_GPHP,	
	TX_PAUSE_ALL_ACS_EXCEPT_BEACON_AND_GPLP,
	TX_PAUSE_ALL_ACS_EXCEPT_BEACON,
	TX_PAUSE_ALL_ACS_EXCEPT_GPLP,
	TX_PAUSE_ALL_ACS_EXCEPT_GPHP,
	TX_PAUSE_AC_GPLP,
	TX_PAUSE_NUM_OF_AC_TYPES,
	TX_PAUSE_MAX_NUM_OF_AC_TYPES = 0xFF,
}TxPauserAcTypes_e;

typedef enum TxPauserClients
{
	TX_PAUSE_CLIENT_LM = 0,	//must be 0, used by the LM 
	TX_PAUSE_CLIENT_TX,	
	NUM_OF_PAUSE_CLIENTS_PER_PAUSE_TYPE,

}TxPauserClients_e;


typedef struct TxHandlerPauseResumeParams
{
	TxPauserCommand_e commandType;	
	uint8 vapIndex;
	uint8 pauseAcType;
} TxPauserPauseResumeParams_t;

typedef struct TxHandlerRepetitionParams
{
	uint16 cycleCount;
	uint16 pauseDuration;
	uint16 resumeDuration;
	TxPauserRepetitionType_e repetitionType;
} TxPauserRepetitionParams_t;

typedef enum PauseState
{
	PAUSE_STATE_FREE,
	PAUSE_STATE_PAUSE,
	PAUSE_STATE_NUM_STATES,	
}PauseStates_e;

typedef struct pauseClient
{
	uint32 taskId;
	uint32 msgId;	
}pauseClient_t;

typedef struct pauseMsgData
{
	uint8 pauseType;
	uint8 pauseSubType;	// for PAUSE VAP- this is vap index, for PAUSE_AC this is the PAUSE_AC_TYPE
}pauseMsgData_t;


typedef enum PauseAcType
{
	PAUSE_TYPE_ENABLE_ONLY_GPHP_AND_BEACONS,
	PAUSE_TYPE_NUM_TYPES,	
}PauseAcType_e;




//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TxPauser_Initialize(void);
void TxPauser_PauseOrResume(TxPauserPauseResumeParams_t *pauseResumeParams);
void TxPauser_StartRepetitionMode(TxPauserRepetitionParams_t *repetitionParams);
void TxPauser_EndRepetitionMode(void);
void TxPauser_PauseAll(TxPauserPauseResumeParams_t *pauseResumeParams);
void TxPauser_ResumeAll(TxPauserPauseResumeParams_t *pauseResumeParams);
	

ISR_VOID isr_TxPauser_PauseExecuted (void);
void isr_TxPauser_RxPauseExecuted(void);



void TxPauser_PauseVap(TxPauserPauseResumeParams_t *pauseResumeParams);
void TxPauser_ResumeVap(TxPauserPauseResumeParams_t *pauseResumeParams);
void TxPauser_PauseAc(TxPauserPauseResumeParams_t *pauseResumeParams);
void TxPauser_ResumeAc(TxPauserPauseResumeParams_t *pauseResumeParams);
void TxPauser_PauseRx(void);
void TxPauser_ResumeRx(void);
void TxPauser_RxHaltRecover(void);



void TxPauser_ReadDebug(uint32 type);









#endif /* PAUSER_API_H_ */

