/***********************************************************************************
 File:			PlanManager_API.h
 Module:		Group manager 
 Purpose: 		To create and delete multi user groups
 Description:   This file is the API of the Group manager which is responsible of 
 				creating and deleting multi user groups
************************************************************************************/
#ifndef PLAN_MANAGER_API_H_
#define PLAN_MANAGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "SharedDbTypes.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"
#include "frame.h"
#include "TxSelector_Api.h"


/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/
			
#ifdef PRE_AGG_HE_MU_16TH_PHASE_NOT_SUPPORTED
// When running with phase 15 valid there is a bug which causes the last_phase indication in the STD not be set
// relevant errata is https://jira-chd.intel.com/browse/WLANVLSIIP-2925
#define MAX_NUM_OF_PHASES_IN_A_PLAN					(15)
#else
#define MAX_NUM_OF_PHASES_IN_A_PLAN					(16)
#endif //PRE_AGG_HE_MU_16TH_PHASE_NOT_SUPPORTED


/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/

typedef enum PhaseFormat_e
{
	PHASE_FORMAT_DL_DATA, 
	PHASE_FORMAT_UL_DATA, 
	PHASE_FORMAT_SOUNDING, 
	PHASE_FORMAT_PROTECTION,	
	PHASE_FORMAT_BSRP,
	PHASE_FORMAT_DL_MIXED,
	PHASE_FORMAT_UL_MIXED,
#ifdef ENET_INC_ARCH_WAVE600D2
	PHASE_FORMAT_NFRP,
#endif
} PhaseFormat_e;

typedef enum HePhaseType_e
{
	PROTECTION_PHASE_BIT_INDEX = 0,
	SOUNDING_PHASE_BIT_INDEX,
    BSRP_PHASE_BIT_INDEX,
	DATA_PHASE_BIT_INDEX,
#ifdef ENET_INC_ARCH_WAVE600D2
	NFRP_PHASE_BIT_INDEX,
#endif
} HePhaseType_e;


/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/

void PlanManager_Initialize(void);



#endif /* GROUP_MANAGER_API_H_ */

