/***********************************************************************************
 File:			PlanManager.h
 Module:		Plan Manager
 Purpose: 		
 Description:	This file contains all definitions and the structures of the PlanManager 
 			
************************************************************************************/
#ifndef PLAN_MANAGER_H_
#define PLAN_MANAGER_H_

#include "ShramPlannerResources.h"


#define PLAN_MAX_TXOP_DURATION										32000 
#define MAC_DURATION												40
#define BAR_BACK_AIR_TIME_DURATION									219	 	//438 microseconds in 2 micro resolution: SIFS + PHY Preabmle + BAR + SIFS + PHY Preamble + Block Ack (rate 6.5MHz (lowest VHT rate))


#define	POSIBLE_26_TONES_FOR_SECOND_RUS_FOR_106_TONES_MASK 			0x1F0
#define	POSIBLE_26_TONES_FOR_SECOND_RUS_FOR_484_TONES_MASK			0x3FFFF
#define	POSIBLE_52_TONES_FOR_SECOND_RUS_FOR_484_TONES_MASK			0xFF
#define	POSIBLE_106_TONES_FOR_SECOND_RUS_FOR_484_TONES_MASK			0xF			
#define	POSIBLE_52_TONES_FOR_SECOND_RUS_FOR_996_TONES_MASK			0xFFFF
#define	POSIBLE_106_TONES_FOR_SECOND_RUS_FOR_996_TONES_MASK			0xFF


#define RU_INDEX_4													4
#define	NUM_OF_26_TONES_IN_A_SUB_BAND								9
#define	NUM_OF_52_TONES_IN_A_SUB_BAND								4
#define	NUM_OF_106_TONES_IN_A_SUB_BAND								2
#define	NUM_OF_52_TONES_IN_TWO_SUB_BANDS							(NUM_OF_52_TONES_IN_A_SUB_BAND*2)
#define	NUM_OF_52_TONES_IN_THREE_SUB_BANDS							(NUM_OF_52_TONES_IN_A_SUB_BAND*3)
#define	NUM_OF_52_TONES_IN_FOUR_SUB_BANDS							(NUM_OF_52_TONES_IN_A_SUB_BAND*4)
#define	NUM_OF_106_TONES_IN_TWO_SUB_BANDS							(NUM_OF_106_TONES_IN_A_SUB_BAND*2)

#define	SUB_BAND0													0
#define	SUB_BAND1													1
#define	SUB_BAND2													2
#define	SUB_BAND3													3
#define	SUB_BAND4													4
#define	SUB_BAND5													5
#define	SUB_BAND6													6
#define	SUB_BAND7													7

typedef struct HeMuResourcePools
{
	CommonPlan_t*		planPoolptr; 
	DataPhase_t*		dataPhasePoolPtr; 
	SoundingPhase_t* 	soundingPhasePoolPtr; 
	ProtectionPhase_t* 	protectionPhasePoolPtr; 
#ifdef ENET_INC_ARCH_WAVE600D2
	NfrpPhase_t*		nfrpPhasePoolPtr; 
#endif
} HeMuResourcePools_t;



typedef struct _PlanManagerDefaultSettingValuesDb
{
	/*word 0*/
	uint32	DlCommonPhase_currentPsduMaxLengthLimit						:23; // = 6500631;
	uint32	DlCommonPhase_minimumNumberOfUsersForTransmission			:7; // = 0;
	uint32	DlCommonPhase_oneShotPhase									:1;  // = 0;
	uint32	DlCommonPhase_keepPlanLock									:1;  // = 0;
	/*word 1*/
	uint32	DlCommonPhase_partialDuration								:18; // = 0;
	uint32	DlCommonPhase_maxPpduTransmissionTimeLimit					:13; //(MAX_PSDU_TX_TIME_LIMIT>>1)
	uint32	DlCommonPhase_moveStaToSu									:1;  // = 0;
	/*word 2*/
	uint32	DlCommonPhaseTcrA_hePuncturingMap							:8; //0
	uint32	DlCommonPhase_primaryUser									:7; // 0 
	uint32	DlCommonPhase_tfParamTriggerType							:3;  // = TRIGGER_FRAME_TYPE_MU_BAR;
	uint32	DlCommonPhaseTcrA_phyMode									:3; //PHY_MODE_11AX_MU_DL
	uint32	DlCommonPhase_dlDataTxType									:2; // 0x2;// '00' - DL HE MU immediate;  '01' - DL HE MU non immediate;  '10' - DL HE MU non immediate MU-BAR 
	uint32	DlCommonPhaseTcrA_customBf									:2; //0
	uint32	DlCommonPhase_plannedData									:1;  // bit 4 in action bitmap field 
	uint32	DlCommonPhase_plannedMuBarTf								:1; // = 1;
	uint32	DlCommonPhase_tfMode										:1; // 0; // 0 - Broadcast;  1 - Unicast
	uint32	DlCommonPhase_primaryImmediateBa							:1; //0; //  vht alike mode 

	uint32	DlCommonPhaseTcrA_txLoopMode								:1; //1
	uint32	DlCommonPhaseTcrA_ulDl										:1; //0
	uint32	DlCommonPhaseTcrA_txopPs									:1; //0
	/*word 3*/
	uint32	DlCommonPhaseTcrA_macDuration								:15; //MAC_DURATION
	uint32	DlCommonPhaseTcrB_hePuncturingMap							:8; //0
	uint32	DlCommonPhaseTcrB_phyMode									:3;
	uint32	DlCommonPhaseTcrA_triggerBasedDataPktExt					:2;//0

	uint32	DlCommonPhaseTcrA_expectedRcr								:1; //0
	uint32	DlCommonPhaseTcrA_bwChange									:1; //0
	uint32	DlCommonPhaseTcrA_txopDurationFromMac						:1; //1
	uint32	DlCommonPhaseTcrA_dynamicBw 								:1; //0
	

	/*word 4*/
	uint32	DlCommonPhaseTcrB_macDuration								:15; //MAC_DURATION
	uint32	DlCommonPhaseBrdcstUserTcrB_TcrbStaAid						:11; 	/* Default DL CommonUserTCR_B_Fields 	 fields */
	uint32	DlCommonPhaseTcrB_ulDl										:1; //0
	uint32	DlCommonPhaseTcrB_txopPs									:1; //0
	uint32	DlCommonPhaseTcrB_expectedRcr								:1; //0
	uint32	DlCommonPhaseTcrB_bwChange									:1; //0
	uint32	DlCommonPhaseTcrB_customBf									:1; //0
	uint32	DlCommonPhaseTcrB_txopDurationFromMac						:1; //1

	/*word 5*/
	uint32	DlCommonPhaseBrdcstUserTcrB_BfIndex							:8; 
	uint32	DlCommonPhaseBrdcstUserTcrB_StartRu							:4;
	uint32	DlCommonPhaseBrdcstUserTcrB_RelativeUserPower				:4; 
	uint32	DlCommonPhaseBrdcstUserTcrB_SubBand							:3; 
	uint32	DlCommonPhaseBrdcstUserTcrB_RuSize							:3; 
	uint32	DlCommonPhaseBrdcstUserTcrB_Ldpc							:1; 
	uint32	DlCommonPhaseBrdcstUserTcrB_Txbf							:1; 
	uint32	DlCommonPhaseTcrB_aggregate									:1; //1
	uint32	DlCommonPhaseTcrB_dynamicBw									:1; //0
	uint32	DlCommonPhaseTcrB_scp										:1; //0;//don't care as phy mode is HE  (this field is relevant for HT/VHT)

	uint32	DlCommonPhaseTcrB_notSounding								:1; //0 
	uint32	DlCommonPhaseTcrB_spatialReuse								:1; //0

	uint32	DlCommonPhaseTcrB_triggerBasedDataLdpc						:1;//0
	uint32	DlCommonPhaseTcrB_triggerBasedDataPktExt					:1;//0
	uint32	DlCommonPhaseRcr_peDisambiguty								:1; //1
	/*word 6*/
	uint32	DlCommonTf_SpatialReuse 									:16; 
	uint32	DlCommonTf_tfTriggerType 									:4;  //TRIGGER_FRAME_TYPE_MU_BAR
	uint32	DlCommonPhaseTcrB_triggerBasedDataPeDisam					:1; //1
	uint32	DlCommonTf_CommonInfoSwOverrideEnable 						:1; //0
	uint32	DlCommonTf_UserInfoSwOverrideEnable 						:1; //0
#ifdef ENET_INC_ARCH_WAVE600D2	
	uint32	DlCommonTf_tfMoreTf											:1; //0
#else	
	uint32	DlCommonTf_CascadeIndication								:1; //0
#endif	
	uint32	DlCommonTf_CsRequired										:1; //0  should a station consider CCA before UL  - only For MU RTS should be set with 1  
	uint32	DlCommonTf_MuMimoLtfMode									:1; //0: Single Stream Pilots   1 : Mask on each spatial stream of the LTF sequence by a distinct orthogonal code
	uint32	DlCommonTf_Doppler											:1; 
	uint32	DlCommonTf_MultiTidTid										:1; 
	uint32	DlCommonTf_tfMultiTidFn0									:1; 
	uint32	DlCommonTf_tfMultiTidFn1									:1; 
	uint32	DlCommonTf_tfMultiTidFn2									:1; 
	uint32	DlCommonTf_tfMultiTidFn3									:1; 	
	/*word 7*/
	uint32	DlCommonTf_tfLsigLengthOverride								:1;   
	uint32	DlCommonTf_tfBwOverride										:1;   
	uint32	DlCommonTf_tfRuAllocationOverride							:1;   
	uint32	DlCommonTf_tfMcsOverride									:1;   
	uint32	DlCommonTf_tfDcmOverride									:1;   
	uint32	DlCommonTf_tfNssOverride									:1;   
	uint32	DlCommonTf_tfTargetRssiOverride								:1;   
	uint32	DlCommonTf_tfTidAggrLimitOverride							:1;   
	uint32	DlCommonTf_tfPreferredAcOverride							:1;   
	uint32	DlCommonTf_tfMultiTidOverride								:1;   
	uint32	DlCommonTf_tfTidInfoOverride								:1;   
	uint32	DlCommonTf_tfCompressedFnOverride							:1;   
	uint32	DlCommonTf_tfCompressedSsnOverride							:1;   
	uint32	DlCommonTf_tfMultiTidTidOverride							:1;   
	uint32	DlCommonTf_tfMultiTidFnOverride								:1;   
	uint32	DlCommonTf_tfMultiTidSsnOverride							:1;   


	
	uint32	DlPerUser_numTfRepetition									:3; //0x1
	uint32	DlPerUser_tidSelectionPolicy								:2; //0x2; 
	uint32	DlCommonTf_tfBarAckPolicy									:1; //Multi station BA or compressed BA    
	uint32	DlCommonTf_tfMultiTid										:1; 	//In UL phase should be 1
	uint32	DlCommonTf_CompressedBitmap									:1; //In UL phase should be 1
	uint32	DlCommonTf_tfGcr											:1; 
	uint32	DlCommonTf_CompressedFn0									:1; 
	uint32	DlCommonTf_CompressedFn1									:1; 
	uint32	DlCommonTf_CompressedFn2									:1; 
	uint32	DlCommonTf_CompressedFn3									:1; 
	uint32	DlCommonTf_MultiTidMuBarInformation 						:1; 
	uint32	UlCommonPhaseTcrA_triggerBasedDataLdpc						:1;//0
	uint32	UlPerUserTf_Dcm												:1;	

	/*word 8*/
	uint32	DlCommonTf_MultiTidStartingSequenceNumber					:12;
	uint32	DlCommonTf_CompressedStartingSequenceNumber 				:12; 
	uint32	DlCommonTf_ReservedBarControl								:8;
	
	/*word 9*/
	

	uint32	DlPerUser_tidAllocBitmap									:9; //TID_BITMAP_ALL_TIDS
	uint32	DlPerUser_TcraBfIndex										:8;
	uint32	DlPerUser_TcraRelativeUserPower 							:4;
	uint32	DlPerUser_tid0RrWeight										:3; //0 NA	
	uint32	DlPerUser_tid1RrWeight										:3;//0 NA
	uint32	DlPerUser_tid2RrWeight										:3;//0 NA
	uint32	DlPerUser_heMngAgg											:1; //No management in agg 
	uint32	DlPerUser_heBarAgg											:1; //No management in agg 
	/*word 10*/
	uint32	DlPerUser_tid3RrWeight										:3;//0 NA
	uint32	DlPerUser_tid4RrWeight										:3;//0 NA
	uint32	DlPerUser_tid5RrWeight										:3;//0 NA
	uint32	DlPerUser_tid6RrWeight										:3;//0 NA
	uint32	DlPerUser_tid7RrWeight										:3;//0 NA
	uint32	DlPerUser_aControlIncluded									:1; // 0 *A-Control (HT) Included  0  not included 1  included */
	uint32	DlPerUser_userRcrTxbf										:1 ;// 0x0; //NO UL BF
	uint32	DlPerUser_RcrValid											:1; //1 
	uint32	DlPerUser_TcraTxbf											:1;
	uint32	DlPerUserTf_RuAllocation 									:8;  //0x0; //override by the RCR value 
	uint32	DlPerUserTf_TidAggLimit										:3; //0x0; //override by the RCR value 
	uint32	DlPerUserTf_PreferredAc										:2;//  0x0; //override by the RCR value 
	/*word 11*/
	uint32	DlPerUserTf_BfrpTriggerDependent 							:8; //	
	uint32	DlPerUserTf_BasicTrigger 									:1;
	uint32	DlPerUserTf_Dcm												:1;
	uint32	UlCommon_partialDuration									:18; // FULL TXOP 
	uint32	UlCommon_phaseType											:3;  //0x3; //0 - Protection Phase;  1 - Sounding Phase;  2 - DL Data Phase;  3 - UL Phase 
	uint32	UlCommon_keepPlanLock										:1; 

	/*word 12*/
	uint32	UlCommonPhaseTcrA_hePuncturingMap							:8; //0
	uint32	UlCommon_minNumOfUsersForTransmission						:7; //= 2; 
	uint32	UlCommonPhaseTcrA_phyMode									:3; //PHY_MODE_11AX_MU_DL
	uint32	UlCommon_oneShotPhase										:3; 
	uint32	UlCommon_tfParamTriggerType									:3; //TRIGGER_FRAME_TYPE_BASIC
	uint32	UlCommonPhaseTcrA_customBf									:2; //0
	uint32	UlCommon_moveStaToSu										:1; // For training only 	
	uint32	UlCommon_plannedUlTf										:1; 
	uint32	UlCommon_ulDataSeqType										:1;  //1;
#ifdef ENET_INC_ARCH_WAVE600D2
	uint32	UlCommon_tfMode												:1; //1 //TfBaMode_e
	uint32	UlCommon_baMode												:1; // TfBaMode_e
#else
	uint32	UlCommon_tfBroadcastUnicastMode 							:1; //1 
	uint32	UlCommon_baBroadcastUnicastMode 							:1; //1
#endif
	uint32	UlPerUserTf_TidAggLimit0									:1; 

	/*word 13*/	
	uint32	UlCommonPhaseTcrA_macDuration								:15; //MAC_DURATION
	uint32	UlCommonPhaseTcrB_hePuncturingMap							:8; 
	uint32	UlCommonPhaseTcrA_triggerBasedDataPktExt					:2;//0

	uint32	UlCommonPhaseTcrA_txLoopMode								:1; //1
	uint32	UlCommonPhaseTcrA_ulDl										:1; //0
	uint32	UlCommonPhaseTcrA_txopPs									:1; //0


	uint32	UlCommonPhaseTcrA_expectedRcr								:1; //0
	uint32	UlCommonPhaseTcrA_bwChange									:1; //0
	uint32	UlCommonPhaseTcrA_txopDurationFromMac						:1; //1
	uint32	UlCommonPhaseTcrA_aggregate 								:1; //1

	/*word 14*/	
	uint32	UlCommonPhaseBrdcstUserTcrB_TcrbStaAid						:11; 	/* Default DL CommonUserTCR_B_Fields 	 fields */
	uint32	UlCommonPhaseBrdcstUserTcrB_BfIndex							:8; 
	uint32	UlCommonPhaseBrdcstUserTcrB_StartRu							:4;
	uint32	UlCommonPhaseBrdcstUserTcrB_RelativeUserPower				:4; 
	uint32	UlCommonPhaseBrdcstUserTcrB_SubBand							:3; 
	uint32	UlCommonPhaseTcrB_ulDl										:1; //0
	uint32	UlCommonPhaseTcrB_txopPs									:1; //0
	/*word 15*/		
	uint32	UlCommonPhaseBrdcstUserTcrB_RuSize							:3; 
	uint32	UlCommonPhaseTcrB_phyMode									:3; //PHY_MODE_11AX_MU_DL

	uint32	UlCommonPhaseTcrB_expectedRcr								:1; //0
	uint32	UlCommonPhaseTcrB_bwChange									:1; //0
	uint32	UlCommonPhaseTcrB_customBf									:1; //0
	uint32	UlCommonPhaseTcrB_txopDurationFromMac						:1; //1
	uint32	UlCommonPhaseBrdcstUserTcrB_Ldpc							:1; 
	uint32	UlCommonPhaseBrdcstUserTcrB_Txbf							:1; 
	uint32	UlCommonPhaseTcrB_aggregate									:1; //1
	uint32	UlCommonPhaseTcrB_dynamicBw									:1; //0
	uint32	UlCommonPhaseTcrB_scp										:1; //0;//don't care as phy mode is HE  (this field is relevant for HT/VHT)
	uint32	UlCommonPhaseTcrB_notSounding								:1; //0 
	uint32	UlCommonPhaseTcrB_spatialReuse								:1; //0
	uint32	UlCommonPhaseTcrB_triggerBasedDataLdpc						:1;//0
	uint32	UlCommonPhaseTcrB_triggerBasedDataPktExt					:1;//0
	uint32	UlCommonPhaseTcrB_triggerBasedDataPeDisam					:1;//0
	
	uint32	UlCommonPhaseBrdcstUserTcrA_StaAid							:11;	/* Default DL CommonUserTCR_B_Fields	 fields */
	uint32	UlCommonPhaseBrdcstUserTcrA_Ldpc							:1; 
	/*word 16*/
	uint32	UlCommonPhaseBrdcstUserTcrA_BfIndex 						:8; 
	uint32	UlCommonPhaseBrdcstUserTcrA_StartRu 						:4;
	uint32	UlCommonPhaseBrdcstUserTcrA_RelativeUserPower				:4; 
	uint32	UlCommonPhaseBrdcstUserTcrA_RuSize							:3; 
	uint32	UlCommonPhaseBrdcstUserTcrA_Txbf							:1; 
	uint32	UlCommonPhaseBrdcstUserTcrA_SubBand 						:3;
	uint32	UlCommonTf_tfTriggerType 									:4;  //TRIGGER_FRAME_TYPE_BASIC
	uint32	UlCommonTf_Doppler											:1; 
	uint32	UlCommonTf_UserInfoSwOverrideEnable 						:1; //0
#ifdef ENET_INC_ARCH_WAVE600D2		
	uint32	UlCommonTf_tfMoreTf											:1; //0
#else	
	uint32	UlCommonTf_CascadeIndication								:1; //0	
#endif
	uint32	UlCommonTf_CsRequired										:1; //0  should a station consider CCA before UL  - only For MU RTS should be set with 1  
	uint32	UlCommonTf_MuMimoLtfMode									:1; //0: Single Stream Pilots   1 : Mask on each spatial stream of the LTF sequence by a distinct orthogonal code
	/*word 17*/
	uint32	UlCommonTf_SpatialReuse 									:16;
	uint32	UlCommonPhaseTcrB_macDuration								:15; //MAC_DURATION
	uint32	UlCommonTf_CommonInfoSwOverrideEnable 						:1; //0

	/*word 18*/
	uint32	UlTf_LsigLengthOverride 									:1;		/*	TF_LsigLengthOverride */
	uint32	UlTf_BW_Override											:1; 	/*	TF_BW_Override */
	uint32	UlTf_RU_Allocation_Override									:1; 	/*	TF_RU_Allocation_Override */
	uint32	UlTf_MCS_Override											:1; 	/*	TF_MCS_Override */
	uint32	UlTf_DcmOverride											:1; 	/*	TF_DcmOverride */
	uint32	UlTf_NSS_Override											:1; 	/*	TF_NSS_Override */
	uint32	UlTf_Target_RSSI_Override									:1; 	/*	TF_Target_RSSI_Override */
	uint32	UlTf_TID_Aggr_Limit_Override								:1; 	/*	TF_TID_Aggr_Limit_Override */
	uint32	UlTf_Preferred_AC_Override									:1; 	/*	TF_Preferred_AC_Override */
	uint32	UlTf_Multi_TID_Override										:1; 	/*	TF_Multi_TID_Override */
	uint32	UlTf_TID_Info_Override										:1; 	/*	TF_TID_Info_Override */
	uint32	UlTf_Compressed_FN_Override									:1; 	/*	TF_Compressed_FN_Override */
	uint32	UlTf_Compressed_SSN_Override								:1; 	/*	TF_Compressed_SSN_Override */
	uint32	UlTf_Multi_TID_TID_Override									:1; 	/*	TF_Multi_TID_TID_Override */
	uint32	UlTf_Multi_TID_FN_Override									:1; 	/*	TF_Multi_TID_FN_Override */
	uint32	UlTf_Multi_TID_SSN_Override									:1; 	/*	TF_Multi_TID_SSN_Override */
	
	uint32	UlCommonTf_MultiTidStartingSequenceNumber					:12;
	uint32	UlCommonTf_MultiTidTid										:1; 
	uint32	UlCommonTf_tfMultiTidFn0									:1; 
	uint32	UlCommonTf_tfMultiTidFn1									:1; 
	uint32	UlCommonTf_tfMultiTidFn2									:1; 


	/*word 19*/
	uint32	UlPerUser_tidAllocBitmap									:9; //TID_BITMAP_ALL_TIDS
	uint32	UlPerUserTf_TcraBfIndex										:8;
	uint32	UlPerUserTf_maxTids											:4; 
	uint32	UlPerUserTf_numTfRepetition									:3; 	



	uint32	UlCommonTf_tfMultiTidFn3									:1;
	uint32	UlPerUserTf_RcrTxbf											:1;
	
	uint32	UlPerUserTf_RcrValid										:1;
	uint32	UlPerUserTf_TcraTxbf										:1;
	uint32	UlPerUserTf_TcraRelativeUserPower							:1;

	uint32	UlPerUserTf_TcrbLdpc										:1;
	uint32	UlPerUserTf_TcrbTxbf										:1;
	uint32	UlPerUserTf_TcrbRelativeUserPower							:1;

	/*word 20*/
#ifdef ENET_INC_ARCH_WAVE600D2		
	uint32	tfHeSigA2Reserved											:9; //shoudl be set with ones 
#else
	uint32	tfHeSigAReserved											:9; //shoudl be set with ones 
#endif	
	uint32	UlPerUserTf_RuAllocation									:8;	
	uint32	UlPerUserTf_BfrpTriggerDependent0							:8;
	uint32	UlPerUserTf_preferredAc0									:2; 
	uint32	DlCommonPhase_phaseType										:3; // = 0;
	uint32	DlCommonPhaseTcrA_scp										:1; //0;//don't care as phy mode is HE	(this field is relevant for HT/VHT)
	uint32	DlCommonPhaseTcrB_txLoopMode								:1; //1 

	/*word 21*/
	uint32	planMaxTxopDur 												:15;
	uint32	DlCommonTf_MultiTidReserved 								:12; 
	uint32	UlCommonPhaseTcrA_triggerBasedDataPeDisam					:1; //1
	uint32	UlCommonPhaseTcrB_txLoopMode								:1; //1
	uint32	planDurationUpdateMode 										:1;
	uint32	ulTfPadding													:2; 	
	/*word 22*/
	uint32	Dl_lSigLength												:12;
	uint32	Ul_lSigLength												:12;
	uint32	tfMpduMuSpacingFactor										:2;
	uint32	tfGiAndLtfType												:2;
	uint32	DlCommonPhaseTcrA_notSounding								:1; //0 
	uint32	DlCommonPhaseTcrA_spatialReuse								:1; //0
	uint32	DlCommonPhaseTcrA_triggerBasedDataLdpc						:1;//0
	uint32	DlCommonPhaseTcrA_triggerBasedDataPeDisam					:1; //1
	/*word 23*/
	uint32	ProtectionMinNumOfUsersForTx								:7; //0
	uint32	ProtectionPhaseFillerType	 								:2; //0
	uint32	DlCommonPhaseTcrA_aggregate 								:1; //1
	uint32	UlCommonPhaseTcrA_dynamicBw									:1; //0
	uint32	UlCommonPhaseTcrA_scp										:1; //0;//don't care as phy mode is HE  (this field is relevant for HT/VHT)
	uint32	UlCommonPhaseTcrA_notSounding								:1; //0 
	uint32	UlCommonPhaseTcrA_spatialReuse								:1; //0
	uint32	ProtectionPhasePlannedMuRts									:1; //0
	uint32	ProtectionPhasePlannedRtsCts 								:1; //0
	uint32	ProtectionPhasePlannedCts2Self 								:1; //1
	uint32	ProtectionPhaseKeepPlanLock									:1; //0
	uint32	ProtectionPhaseMoveStaToSu									:1; //0
	uint32	currMaxMsduAtAmsdu											:5; //7
	uint32	reserved1													:8; 

	/*word 24*/
	uint32	SoundingCommonTf_OverrideEnableParams						:18;
    uint32  UlCommonTf_tfLength                                         :12;
	uint32	reserved2													:2; 
    
#ifdef ENET_INC_ARCH_WAVE600D2
	/*word 25*/
	uint32  NfrpCommonPhase_ValidUsers310								:8;	
	uint32  NfrpCommonPhase_Reserved3									:8;		
	uint32  NfrpCommonPhase_MinimumNumberOfUsersForTransmission			:7;	
	uint32  NfrpCommonPhase_TfinfoBaseAddrDWoffset						:9;
	
	/*word 26*/
	uint32  NfrpCommonPhaseRcr_heSigAbssColor                           :6;
	uint32  NfrpCommonPhaseRcr_cbw                                      :2;
	uint32  NfrpCommonPhaseRcr_nHeltf									:3;
	uint32  NfrpCommonPhaseRcr_Reserved00 								:1;
	uint32  NfrpCommonPhaseRcr_TBmode 									:2;
	uint32  NfrpCommonPhaseRcr_NdpFbMultiplexing 						:1;
	uint32  NfrpCommonPhaseRcr_Reserved01 								:9;
	uint32  NfrpCommonPhaseRcr_heCp 									:2;
	uint32  NfrpCommonPhaseRcr_heLtf 									:2;
	uint32  NfrpCommonPhaseRcr_Reserved02 								:3;
	uint32  NfrpCommonPhaseRcr_stbc 									:1;

	/*word 27*/	
	uint32  NfrpCommonPhaseRcr_heSigAspatialReuse 						:16;
	uint32  NfrpCommonPhaseRcr_lSigLength 								:12;
	uint32  NfrpCommonPhaseRcr_ldpcExtraSymbol 							:1;
	uint32  NfrpCommonPhaseRcr_Reserved1 								:2;
	uint32  NfrpCommonPhaseRcr_peDisambiguty 							:1;	
#endif

    /*word 28*/
    uint32  DlCommonTf_tfLength                                         :12;
    uint32  reserved3                                                   :20;
} PlanManagerDefaultSettingValuesDb; 


#endif 
