/***************************************************************
 File:		PreAggregator_Api.h
 Module:	  	Aggregation builder
 Purpose: 	configures the aggregation builder module in the PAC 
 Description:  This file is the API to the aggregation builder module which is responsible for creating
 			the next transmission
***************************************************************/
#ifndef PRE_AGGREGATOR_API_H_
#define PRE_AGGREGATOR_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

#include "StaDb.h"
#include "mhi_umi_propr.h"
#include "PacketDescriptor.h"
#include "InterruptManager_Api.h"
#include "PreAggCommonReportFifo_Descriptors.h"
#include "PreAggUserReportFifo_Descriptors.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum
{
	PRE_AGGREGATOR_FORCE_PROTECTION_MODE_RTS = 0,
	PRE_AGGREGATOR_FORCE_PROTECTION_MODE_CTS2SELF,
} PreAggForceProtectionMode_e;

typedef enum
{
	PRE_AGGREGATOR_11B_OVERRIDE_PREAMBLE_ENABLED = 0,
	PRE_AGGREGATOR_11B_OVERRIDE_PREAMBLE_DISABLED,
} PreAgg11BOverridePreamble_e;

typedef enum
{
	 PRE_AGGREGATOR_11B_PREAMBLE_MODE_SHORT= 0,
	 PRE_AGGREGATOR_11B_PREAMBLE_MODE_LONG,
} PreAgg11BPreambleMode_e;

typedef enum
{
	PRE_AGGREGATOR_26_TONE_RU_SIZE,		// 2 MHz
	PRE_AGGREGATOR_52_TONE_RU_SIZE,		// 5 MHz
	PRE_AGGREGATOR_106_TONE_RU_SIZE,	// 10 MHz
	PRE_AGGREGATOR_242_TONE_RU_SIZE,	// 20 MHz
	PRE_AGGREGATOR_484_TONE_RU_SIZE,	// 40 MHz
	PRE_AGGREGATOR_996_TONE_RU_SIZE,	// 80 MHz
	PRE_AGGREGATOR_996X2_TONE_RU_SIZE,	// 160 MHz
	PRE_AGGREGATOR_NUM_OF_RU_SIZES		
}PreAggRuSizeMapping_e;

typedef enum
{	
	PRE_AGG_START_RU_0,
	PRE_AGG_START_RU_1,
	PRE_AGG_START_RU_2,
	PRE_AGG_START_RU_3,
	PRE_AGG_START_RU_4,
	PRE_AGG_START_RU_5,
	PRE_AGG_START_RU_6,
	PRE_AGG_START_RU_7,
	PRE_AGG_START_RU_8,
	PRE_AGG_START_RU_9
		
}PreAggStartRuIndex_e;

typedef enum
{
	PRE_AGG_SUB_BAND_0,
	PRE_AGG_SUB_BAND_1,
	PRE_AGG_SUB_BAND_2,
	PRE_AGG_SUB_BAND_3,
	PRE_AGG_SUB_BAND_4,
	PRE_AGG_SUB_BAND_5,
	PRE_AGG_SUB_BAND_6,
	PRE_AGG_SUB_BAND_7
	
}PreAggSubBandIndex_e;

#define PRE_AGGREGATOR_MAX_DURATION_THRESHOLD_CONFIGURATION	31

#define PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT			((0x1 << 15) - 1) //32ms (max duration limit)
#define PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_DEFAULT_5G	(13300) // 13.3msec. max
#define PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_DEFAULT_24G	(PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT) //32ms (max duration limit)
#define PRE_AGGREGATOR_TXOP_AIR_TIME_LOWER_LIMIT			(500)	// Minimum of 500usec.

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define CONVERT_BW_TO_RU_SIZE(bw) (bw + PRE_AGGREGATOR_242_TONE_RU_SIZE)

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
#if defined(ENET_INC_LMAC0) || defined(ENET_INC_LMAC1) 

void PreAggregator_SetForceProtection(uint32 vapIndex ,PreAggForceProtectionMode_e forceProtectionMode, uint32 forceProtectionOnOff);
void PreAggregator_Set11BPreambleOverride(uint32 enable11bPreambleOverride, uint32 mcs0Replacment);
void PreAggregator_Set11bPreambleMode(uint32 vapIndex, PreAgg11BPreambleMode_e preambleMode);
void PreAggregator_Get11BPreambleOverrideMode(uint32 vapIndex, bool* isOvverideEnabled, PreAgg11BPreambleMode_e* preambleMode);
void PreAggregator_SetDurationRatioThreshold (uint8 newThreshold);
void PreAggregator_SetMuBfTrainingBwLimit(Bandwidth_e newLimit);
void PreAggregator_FillConfigurationDb(uint32 vapIndex,uint32 protectionRate, uint32 protectionPhyMode, uint32 fillerRate ,uint32 fillerPhyMode);
void PreAggregator_SetBwToSubBandMappingReg(uint8 subBand);
void PreAggregator_Halt(void);
void PreAggregator_Initialize (void);
void HwEventsPreAggregator_Error (void);
void PreAggFillInParamsCalcMem(void);
void PreAggregator_GetCommonFifoReport(PreAggCommonReportFifo_t *pCommonReport);
void PreAggregator_GetUserFifoReport(PreAggUserReportFifo_t *pUserReport);
void PreAggregator_InitReportFifos(void);
void PreAggregator_ReportFifoNotEmptyEventHandler(void);
void PreAggregator_SetTxopDuration(uint16 txopDuration);
uint16 PreAggregator_GetTxopDuration(void);
void PreAggregator_SetPpduDurationLimits(bool etsiMode);

#ifdef ENET_INC_ARCH_WAVE600B
void PreAggregator_SetBfSeqAirTimeDuration(bool etsiMode);
#endif
#ifdef ENET_INC_ARCH_WAVE600D2
void PreAggregator_SetTfGenMaxNumOfStartingSS(uint8 maxNss);
#endif

#endif // #if defined(ENET_INC_LMAC0) || defined(ENET_INC_LMAC1) 

#ifdef ENET_INC_ARCH_WAVE600B
#if defined(ENET_INC_UMAC)
void PreAggregator_SetHeMuKeepUser(bool heMuKeepUserCfg);
#endif // defined(ENET_INC_UMAC)
#endif // ENET_INC_ARCH_WAVE600B


#endif /* PRE_AGGREGATOR_API_H_ */


