/***************************************************************
 File:		PreAggregator.h
 Module:	  	Aggregation builder
 Purpose: 	holds the definions for the aggregation builder module 
 Description:  This file contains the definions of the aggregation builder module which 
 			is responsible for creating the next transmission
***************************************************************/
#ifndef PRE_AGGREGATOR_H_
#define PRE_AGGREGATOR_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "PreAggCommonReportFifo_Descriptors.h"
#include "PreAggUserReportFifo_Descriptors.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define PRE_AGGREGATOR_INTERRUPT_DONE_OPERATION_INTERRUPT     0x00000001
#define PRE_AGGREGATOR_INTERRUPT_TIMER_ERROR             	  0x00000002
#define PRE_AGGREGATOR_INTERRUPT_TXHD_START_DURING_OPERATION  0x00000004
#define PRE_AGGREGATOR_INTERRUPT_FIRST_PD_NULL                0x00000008
#define PRE_AGGREGATOR_INTERRUPT_TX_SEL_PRIMARY_NOT_VALID	  0x00000010
#define PRE_AGGREGATOR_INTERRUPT_TX_SEL_NO_USP_VALID          0x00000020

//---------------------------------------------------------------------------------
//						Defines	for Pre Agg RAM					
//---------------------------------------------------------------------------------


#define DURATION_RATION_11B_MCS_0_SHIFT 	(0)
#define DURATION_RATION_11B_MCS_1_SHIFT		(5)
#define DURATION_RATION_11B_MCS_2_SHIFT		(10)
#define DURATION_RATION_11B_MCS_3_SHIFT		(15)

#define DURATION_RATION_11_A_G_20_MHZ_SHIFT	 (0)
#define DURATION_RATION_11_A_G_40_MHZ_SHIFT	 (5)
#define DURATION_RATION_11_A_G_80_MHZ_SHIFT  (10)
#define DURATION_RATION_11_A_G_160_MHZ_SHIFT (15)


#define DURATION_RATION_11_N_AC_NSS_1_SHIFT	(0)
#define DURATION_RATION_11_N_AC_NSS_2_SHIFT	(5)
#define DURATION_RATION_11_N_AC_NSS_3_SHIFT	(10)
#define DURATION_RATION_11_N_AC_NSS_4_SHIFT	(15)

#define RCR_START_RU_SHIFT					(3)
#define RCR_RU_SIZE_SHIFT					(7)
#define RCR_RU_USER_SHIFT					(10)

#define PRE_AGGREGATOR_ALL_INTERRUPTS 		(PRE_AGGREGATOR_INTERRUPT_DONE_OPERATION_INTERRUPT   | \
											PRE_AGGREGATOR_INTERRUPT_TIMER_ERROR                 | \
											PRE_AGGREGATOR_INTERRUPT_TXHD_START_DURING_OPERATION | \
											PRE_AGGREGATOR_INTERRUPT_FIRST_PD_NULL				 | \
											PRE_AGGREGATOR_INTERRUPT_TX_SEL_PRIMARY_NOT_VALID	 | \
											PRE_AGGREGATOR_INTERRUPT_TX_SEL_NO_USP_VALID)			
											
#define PRE_AGGREGATOR_CLEAR_INTERRUPT 1 
#define PRE_AGGREGATOR_START_TRIGGER   1

#define PRE_AGG_COMMON_FIFO_SIZE	16
#define PRE_AGG_USER_FIFO_SIZE		64

#define RTS_THRESHOLD_MASK_20_BITS (0XFFFFF) 


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _TxTfGeneratorNormalizedBands_t
{
	uint8 subBand0;
	uint8 subBand1;
	uint8 subBand2;
	uint8 subBand3;
} TxTfGeneratorNormalizedBands_t;

typedef struct _PreAggFullReport_t
{
	PreAggCommonReportFifo_t	commonReport;
	PreAggUserReportFifo_t 		userReport;
} PreAggFullReport_t;

#endif /*PRE_AGGREGATOR_H_ */

