/***************************************************************
 File:		HeMcsParams.h
 Module:	Aggregation builder
 Purpose: 	Definition of tables of Ncbps and Ndbps values per RU tone per MCS per DCM
 Description: This file contains tables of Ncbps and Ndbps values per RU tone per MCS per DCM
***************************************************************/
#ifndef PRE_AGG_HE_MCS_TABLES_H_
#define PRE_AGG_HE_MCS_TABLES_H_

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define PRE_AGG_MAX_HE_MCS_NUM	14
#define PRE_AGG_MAX_VHT_MCS_NUM	10

#define PRE_AGG_MAX_DCM_NUM	2
#define PRE_AGG_MAX_RU_NUM	7
#define PRE_AGG_INVERSED_DMA_ENTRIES_PER_BW 4
#define NCBPS_DIV_FACTOR 1944
#define NDBPS_DIV_FACTOR 128	

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct NcbpsNdbps
{
	uint32 ncbps;
	uint32 ndbps;
}NcbpsNdbps_t;

typedef struct Rfactor
{
	uint8 rNumerator;
	uint8 rDenominator;
}Rfactor_t;

// The rFactorValues array contains R values per MCS as specified in tables HeMcs tables in spec section 28.5
const Rfactor_t rFactorValues[PRE_AGG_MAX_HE_MCS_NUM] = { {1,2}, {1,2}, {3,4}, {1,2}, {3,4}, {2,3}, {3,4}, {5,6}, {3,4}, {5,6}, {3,4}, {5,6}, {3,4}, {5,6} };


// The table HeMcsValsPerRu contains Ncbps,Ndbps values that are taken from HeMcs tables in Spec section 28.5 - per specific Ru, Mcs and Dcm with Nss=1.

const NcbpsNdbps_t HeMcsValsPerRu[PRE_AGG_MAX_RU_NUM][PRE_AGG_MAX_HE_MCS_NUM][PRE_AGG_MAX_DCM_NUM] = 
{
	/* RU tone 26-Nss 1*/
		{
			/* mcs 0 - per dcm 0 and dcm 1*/
				/*ncbps   ndbps  */
				{  
					{24,	12}, {12,	6} 
				}, 
				/* mcs 1 - per dcm 0 and dcm 1*/
				{ 
					{48,	24}, {24,	12} 
				},
				/* mcs 2 - dcm N/A */
				{
					{48,	36}, {48,	36}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{96,	48}, {48,	24} 
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{96,	72}, {48,	36} 
				},
				/* mcs 5 - dcm N/A */
				{	
					{144,	96}, {144,	96} 	
				},
				/* mcs 6 - dcm N/A */
				{
					{144,	108}, {144,	108}	
				},
				/* mcs 7 - dcm N/A */
				{
					{144,	120}, {144,	120}	
				},
				/* mcs 8 - dcm N/A */
				{
					{192,	144}, {192,	144}	
				},
				/* mcs 9 - dcm N/A*/
				{
					{192,	160}, {192,	160}	
				},
				/* mcs 10 - Not valid */
				{
					{192,	160}, {192,	160}
				},
				/* mcs 11 - Not valid */
				{
					{192,	160}, {192,	160}	
				},
				/* mcs 12 - Not valid */
				{
					{192,	160}, {192,	160}	
				},
				/* mcs 13 - Not valid */
				{
					{192,	160}, {192,	160}	
				},
		},
		/* RU tone 52-Nss 1*/
		{

				/* mcs 0 - per dcm 0 and dcm 1*/
			
				/*ncbps   ndbps */
				{ 
					{48,	24}, 		{24,	12}  			
				},
				/* mcs 1 - per dcm 0 and dcm 1*/
				{
					{96,	48},	    {48,	24}	
				},
				/* mcs 2 - dcm N/A */
				{
					{96,	72},       	{96,	72}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{192,	96},      	{96,	48}	
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{192,	144},      	{96,	72}	
				},
				/* mcs 5 - dcm N/A */
				{	
					{288,	192},	  	{288,	192}		
				},
				/* mcs 6 - dcm N/A */
				{
					{288,	216},      	{288,	216}	
				},
				/* mcs 7 - dcm N/A */
				{
					{288,	240},      	{288,	240}	
				},
				/* mcs 8 - dcm N/A */
				{
					{384,	288},      	{384,	288}	
				},
				/* mcs 9 - dcm N/A*/
				{
					{384,	320},      	{384,	320}	
				},	
				/* mcs 10 - Not valid */
				{
					{384,	320},      	{384,	320}	
				},
				/* mcs 11 - Not valid */
				{
					{384,	320},      	{384,	320}	
				},
				
				/* mcs 12 - Not valid */
				{
					{384,	320},      	{384,	320}	
				},
				/* mcs 13 - Not valid */
				{
					{384,	320},      	{384,	320}	
				},

		},
	/* RU tone 106-Nss 1*/
		{
				/* mcs 0 - per dcm 0 and dcm 1*/
				
				/*ncbps   ndbps */
				{ 
					{102,	51},		{51,	25}
				},
				/* mcs 1 - per dcm 0 and dcm 1*/
				{
					{204,	102},	    {102,	51}	
				},
				/* mcs 2 - dcm N/A */
				{
					{204,	153},       {204,	153}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{408,	204},      	{204,	102}	
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{408,	306},      	{204,	153}	
				},
				/* mcs 5 - dcm N/A */
				{	
					{612,	408},	  	{612,	408}		
				},
				/* mcs 6 - dcm N/A */
				{
					{612,	459},      	{612,	459}	
				},
				/* mcs 7 - dcm N/A */
				{
					{612,	510},      	{612,	510}	
				},
				/* mcs 8 - dcm N/A */
				{
					{816,	612},      	{816,	612}	
				},
				/* mcs 9 - dcm N/A*/
				{
					{816,	680},      	{816,	680}	
				},	
				/* mcs 10 - Not valid */
				{
					{816,	680},      	{816,	680}	
				},
				/* mcs 11 - Not valid */
				{
					{816,	680},      	{816,	680}	
				},
				/* mcs 12 - Not valid */
				{
					{816,	680},      	{816,	680}	
				},
				/* mcs 13 - Not valid */
				{
					{816,	680},      	{816,	680}	
				},
		},	
	/* RU tone 242-Nss 1*/
		{
				/* mcs 0 - per dcm 0 and dcm 1*/
				
				/*ncbps   ndbps  */
				{ 
					{234,	117},		{117,	58}
				},
				/* mcs 1 - per dcm 0 and dcm 1*/
				{
					{468,	234},	    {234,	117}	
				},
				/* mcs 2 - dcm N/A */
				{
					{468,	351},      	{468,	351}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{936,	468},      	{468,	234}	
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{936,	702},      	{468,	351}	
				},
				/* mcs 5 - dcm N/A */
				{	
					{1404,	936},	  	{1404,	936}		
				},
				/* mcs 6 - dcm N/A */
				{
					{1404,	1053},      {1404,	1053}	
				},
				/* mcs 7 - dcm N/A */
				{
					{1404,	1170},      {1404,	1170}	
				},
				/* mcs 8 - dcm N/A */
				{
					{1872,	1404},      {1872,	1404}	
				},
				/* mcs 9 - dcm N/A*/
				{
					{1872,	1560},      {1872,	1560}	
				},	
				/* mcs 10 - Not valid */
				{
					{2340,	1755},      {2340,	1755}	
				},
				/* mcs 11 - Not valid */
				{
					{2340,	1950},      {2340,	1950}	
				},
				/* mcs 12 - Not valid */
				{
					{2808,	2106},       {2808,	2106}	
				},
				/* mcs 13 - Not valid */
				{
					{2808,	2340},       {2808,	2340}	
				},
		},
	/* RU tone 484-Nss 1*/
		{
				/* mcs 0 - per dcm 0 and dcm 1*/
				
				/*ncbps   ndbps */
				{ 
					{468,	234},		{234,	117}
				},
				/* mcs 1 - per dcm 0 and dcm 1*/
				{
					{936,	468},	    {468,	234}	
				},
				/* mcs 2 - dcm N/A */
				{
					{936,	702},       {936,	702}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{1872,	936},      	{936,	468}	
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{1872,	1404},      {936,	702}	
				},
				/* mcs 5 - dcm N/A */
				{	
					{2808,	1872},	  	{2808,	1872}		
				},
				/* mcs 6 - dcm N/A */
				{
					{2808,	2106},      {2808,	2106}	
				},
				/* mcs 7 - dcm N/A */
				{
					{2808,	2340},      {2808,	2340}	
				},
				/* mcs 8 - dcm N/A */
				{
					{3744,	2808},      {3744,	2808}	
				},
				/* mcs 9 - dcm N/A*/
				{
					{3744,	3120},      {3744,	3120}	
				},	
				/* mcs 10 - Not valid */
				{
					{4680,	3510},      {4680,	3510}	
				},
				/* mcs 11 - Not valid */
				{
					{4680,	3900},      {2340,	3900}	
				},
				/* mcs 12 - Not valid */
				{
					{5616,	4212},       {5616,	4212}	
				},
				/* mcs 13 - Not valid */
				{
					{5616,	4680},       {5616,	4680}	
				},
		},
	/* RU tone 996-Nss 1*/
		{
				/* mcs 0 - per dcm 0 and dcm 1*/
				
				/*ncbps   ndbps */
				{ 
					{980,	490},		{490,	245}
				},
				/* mcs 1 - per dcm 0 and dcm 1*/
				{
					{1960,	980},	    {980,	490}	
				},
				/* mcs 2 - dcm N/A */
				{
					{1960,	1470},      {1960,	1470}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{3920,	1960},      {1960,	980}	
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{3920,	2940},      {1960,	1470}	
				},
				/* mcs 5 - dcm N/A */
				{	
					{5880,	3920},	  	{5880,	3920}		
				},
				/* mcs 6 - dcm N/A */
				{
					{5880,	4410},      {5880,	4410}	
				},
				/* mcs 7 - dcm N/A */
				{
					{5880,	4900},      {2808,	4900}	
				},
				/* mcs 8 - dcm N/A */
				{
					{7840,	5880},      {7840,	5880}	
				},
				/* mcs 9 - dcm N/A*/
				{
					{7840,	6533},      {7840,	6533}	
				},	
				/* mcs 10 - Not valid */
				{
					{9800,	7350},      {9800,	7350}	
				},
				/* mcs 11 - Not valid */
				{
					{9800,	8166},      {9800,	8166}	
				},
				/* mcs 12 - Not valid */
				{
					{11760,	8820},      {11760, 8820}	
				},
				/* mcs 13 - Not valid */
				{
					{11760,	9800},     {11760,	9800}	
				},
		},
	/* RU tone 996 x 2-Nss 1*/
		{
				/* mcs 0 - per dcm 0 and dcm 1*/
								
				/*ncbps   ndbps  */
				{ 
					{1960,	980},		{980,	49}
				},
				/* mcs 1 - per dcm 0 and dcm 1*/
				{
					{3920,	1960},		{1960,	980} 
				},
				/* mcs 2 - dcm N/A */
				{
					{3920,	2940},		{3920,	2940}
				},
				/* mcs 3 - per dcm 0 and dcm 1*/
				{
					{7840,	3920},		{3920,	1960} 
				},
				/* mcs 4 - per dcm 0 and dcm 1*/
				{
					{7840,	5880},		{3920,	2940} 
				},
				/* mcs 5 - dcm N/A */
				{	
					{11760,	7840},		{11760,	7840} 	
				},
				/* mcs 6 - dcm N/A */
				{
					{11760,	8820},		{11760,	8820} 
				},
				/* mcs 7 - dcm N/A */
				{
					{11760,	9800},		{11760,	9800} 
				},
				/* mcs 8 - dcm N/A */
				{
					{15680,	11760},		{15680,	11760} 
				},
				/* mcs 9 - dcm N/A*/
				{
					{15680,	13066},		{15680,	13066} 
				},	
				/* mcs 10 - Not valid */
				{
					{19600,	14700},	   {19600,	14700} 
				},
				/* mcs 11 - Not valid */
				{
					{19600,	16333},	   {19600,	16333} 
				},
				/* mcs 12 - Not valid */
				{
					{23520,	17640},    {23520,  17640}	
				},
				/* mcs 13 - Not valid */
				{
					{23520,	19600},    {23520,	19600}	
				},
		}
};

const NcbpsNdbps_t VhtMcsValsPerBw[NUM_OF_BW_VALUES][PRE_AGG_MAX_VHT_MCS_NUM] =
{
		// bw 20 MHz
		{
			// mcs 0
			/*ncbps   ndbps   */
			
			{ 52,	26},
			/* mcs 1 */
			{104,	52},
			
			/* mcs 2  */
			{104,	78},
		
			/* mcs 3 */
			{208,	104},
		
			/* mcs 4 */
			{208,	156},
			
			/* mcs 5  */
			{312,	208},
		
			/* mcs 6  */
			{312,	234},
			
			/* mcs 7 */
			{312,	260},
			
			/* mcs 8  */
			{416,	312},
			
			/* mcs 9 -invalid*/
			{255,	255},
			
		},

		// bw 40 MHz
		{
			
			/*ncbps   ndbps   */
			
			// mcs 0
			{108,	54},
			
			/* mcs 1 */
			
			{216,	108},
			
			/* mcs 2*/
			
			{216,	162},
			
			/* mcs 3 */
			
			{432,	216},
		
			/* mcs 4 */
			
			{432,	324},
			
			/* mcs 5  */
				
			{648,	432},	
			
			/* mcs 6  */
			
			{648,	486}, 
			
			/* mcs 7  */
			
			{648,	540},
			
			/* mcs 8  */
		
			{864,	648},
			
			/* mcs 9 */
			
			{864,	720},
				
		},
		
		// bw 80 MHz
		{
			// mcs 0
			/*ncbps   ndbps   */
		
			{234,	117},
			
			/* mcs 1 */
			
			{468,	234},
			
			/* mcs 2  */
			
			{468,	351},
			
			/* mcs 3 */
			
			{936,	468},
			
			/* mcs 4 */
			
			{936,	702},
			
			/* mcs 5 */
			
			{1404,	936},	
			
			/* mcs 6 */
			
			{1404,	1053}, 
			
			/* mcs 7 */
			
			{1404,	1170}, 
			
			/* mcs 8  */
			
			{1872,	1404}, 
			
			/* mcs 9 */
			
			{1872,	1560},
				
		},
		
		// bw 160 MHz
		{
			// mcs 0
			/*ncbps   ndbps   */
			{468,	234},

			/* mcs 1 */
			
			{936,	468},
			
			/* mcs 2 */
			{936,	702},
		
			/* mcs 3*/
			
			{1872,	936},
			
			/* mcs 4 */
			
			{1872,	1404},
			
			/* mcs 5 */
			
			{2808,	1872},	
			
			/* mcs 6  */
			
			{2808,	2106},
			
			/* mcs 7  */
			
			{2808,	2340}, 
			
			/* mcs 8  */
			
			{3744,	2808}, 
			
			/* mcs 9 */
		
			{3744,	3120},	
		}
};

#endif /*PRE_AGG_HE_MCS_TABLES_H_*/

