/***************************************************************
 File:		PreAggregator.c
 Module:	  	Pre Aggregator
 Purpose: 	holds all the implementation of the pre aggregator API functions
 Description:  This module contains the implementation of the functions of the aggregation builder module 
 			which is responsible for creating the next transmission 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "PreAggregator_Api.h"
#include "PreAggregator.h"
#include "PreAggRegs.h"
#include "MacRabRegs.h"
#include "AggrDb.h"
#include "ShramPreAggregator.h"
#include "PreAggRtsMem_Descriptors.h"
#include "HwDrivers_Api.h"
#include "ErrorHandler_Api.h"
#include "ShramStd.h"
#include "ShramPacketDescriptors.h"
#include "Pac_Api.h"
#include "lm.h"
#include "enet_pas.h"
#include "RegAccess_Api.h"
#include "Protocol_AirTimeAndDuration.h"
#include "SharedDbTypes.h"
#include "ShramGroupDatabase.h"
#include "loggerAPI.h"
#include "HwQManager_API.h"
#include "PacketDescriptor.h"
#include "shram_man_queues.h"
#include "int_gen.h"
#include "linkAdaptation_api.h"
#include "CpuLoad_Api.h"
#include "TxHandler_Api.h"
#include "ShramPlannerResources.h"
#include "PreAggregatorHeMcsTables.h"
#include "PreAggParamsCalc_Descriptors.h"
#include "TfGeneratorRegs.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_TX_HW_ACCELERATORS
#define LOG_LOCAL_FID   1

#define	PRE_AGGREGATOR_ENABLE_MINIMUM_TIMER 	(1)
#define	PRE_AGGREGATOR_MINIMUM_TIMER_IN_US	 	(2)

#define PRE_AGG_DMA_TOTAL_TP_UNIT_SIZE			(125) // Kb/s
#define PRE_AGG_INVERSE_DMA_RATE_SHIFT			(22)

#define PRE_AGG_MAX_NUM_OF_COMMON_REPORTS		255 // 8 bits field

#define PRE_AGG_BW_40MHZ_TO_SUB_BAND_MAPPING_MASK (0x3)
#define PRE_AGG_BW_80MHZ_TO_SUB_BAND_MAPPING_MASK (0xF)
#define PRE_AGG_SUB_BAND_MASK_40MHZ_SIZE		(2)
#define PRE_AGG_SUB_BAND_MASK_80MHZ_SIZE		(4)
#define PRE_AGG_SUB_BAND_FIELD_MASK				(0x7)
#define PRE_AGG_SUB_BAND_FIELD_IMASK			(0x3F8)


/* Msdu Density Default VAlues*/
#define PRE_AGGREGATOR_MSDU_DENSITY_THRESHOLD_DEFAULT_VALUE			(2400/ONE_EIGTH_US_IN_NS) /* Min Packet size for the for the system to serve in steady state /Max Rate =>
																						 512[Byte] / 1.7[Gbps] = 2.4[uS] = 2400 [ns] in 1/8 usec units */
#define PRE_AGGREGATOR_MSDU_DENSITY_RSRVD_INIT_DEFAULT_VALUE		(20000/ONE_EIGTH_US_IN_NS) /*20us in 1/8 usec units*/
#define PRE_AGGREGATOR_MSDU_DENSITY_MAX_INCREASE_DEFAULT_VALUE		(7000/ONE_EIGTH_US_IN_NS) /* 1500B frame in 1.7Gbps:1500[Byte] / 1.7[Gbps] = 7[uS] in 1/8 usec units*/
#define PRE_AGGREGATOR_MSDU_DENSITY_MAX_RSRVD_PERIOD_DEFAULT_VALUE 	(2*PRE_AGGREGATOR_MSDU_DENSITY_RSRVD_INIT_DEFAULT_VALUE) /* 40usec in 1/8 units*/
#define PRE_AGGREGATOR_MSDU_DENSITY_ZLD_MIN_LIMIT					(0)


/* Prrotection Configuration*/
#define	PRE_AGGREGATOR_ENABLE_TX_SEQ_DUR_OFDM_DEC_6_US  				(1)
#define	PRE_AGGREGATOR_DISABLE_TX_SEQ_DUR_OFDM_DEC_6_US 				(0)
#define	PRE_AGGREGATOR_ENABLE_TX_MPDU_DUR_OFDM_DEC_6_US 				(1)
#define	PRE_AGGREGATOR_DISABLE_TX_MPDU_DUR_OFDM_DEC_6_US				(0)

#define	PRE_AGGREGATOR_PROTECTION_DEFAULT_LENGTH 						(1501)

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_0						(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_1						(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_2						(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_3						(0x1F)

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_20_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_20_MHZ				(0x1F)

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_40_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_40_MHZ				(0x1F)

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_80_MHZ				(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_80_MHZ				(0x1F)

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_160_MHZ			(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_160_MHZ			(0x1F)


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_20_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_20_MHZ	(0x1F)



#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_40_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_40_MHZ	(0x1F)


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_80_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_80_MHZ	(0x1F)

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_160_MHZ	(0x1F)
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_160_MHZ	(0x1F)




#define PRE_AGGREGATOR_DURTION_RATIO_TH_11B				((PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_0 << DURATION_RATION_11B_MCS_0_SHIFT)					| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_1 << DURATION_RATION_11B_MCS_1_SHIFT)					| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_2 << DURATION_RATION_11B_MCS_2_SHIFT)					| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11B_MCS_3 << DURATION_RATION_11B_MCS_3_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))
													 
#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
														(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) 	| \
														(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
														(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
														(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) 	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT)	| \
													 	(PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7_160_MHZ << DURATION_RATION_11_A_G_160_MHZ_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))
																
#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))
#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))
																
#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_20_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_40_MHZ	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_40_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_80_MHZ	((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))
																
#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))
																
#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))
																
#define	PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_80_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)		|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_160_MHZ ((PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_1_160_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_2_160_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_3_160_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)	|\
																(PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_NSS_4_160_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

/*	BF Report Analyzer Delta MCS Values as defined in SAS*/
#define PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_INFORM_LMAC_LOW	(0xF)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_INFORM_LMAC_HIGH	(0xF)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_DO_NOTHING_LOW	(0x1)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_DO_NOTHING_HIGH	(0xF)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_INFORM_LMAC_LOW	(0x3)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_INFORM_LMAC_HIGH	(0x3)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_DO_NOTHING_LOW	(0x1)
#define PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_DO_NOTHING_HIGH	(0x3)

/*	BF Report SNR TH Values as defined in SAS.
 * 	Each 8 bits represents signed value which are read by the HW. 
 *  FW initialize registers to Pre Agg, each register represents 4 such signed values (32 bits).  
 *  Since it is register value, from FW point of view the final value that will be written to register is unsigned.
 */
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_0	(0xACu)	/*-84*/ 
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_1	(0xB8u)	/*-72*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_2	(0xC2u)	/*-62*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_3	(0xCFu)	/*-49*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_4	(0xDCu)	/*-36*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_5	(0xE8u)	/*-24*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_6	(0xF3u)	/*-13*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_7	(0xF7u)	/*-9*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_8	(0x8u)	/* 8*/
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_9	(0xDu)	/*14*/

// RCR RU definitions for BW 20 MHz - 2 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_2USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_2USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_5 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 20 MHz - 3 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_3USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_3USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_2 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define	PRE_AGG_USER2_RCR_RU_3USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_5 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 20 MHz - 4 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_4USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_4USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_2 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define	PRE_AGG_USER2_RCR_RU_4USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_5 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define	PRE_AGG_USER3_RCR_RU_4USERS_20MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_7 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_52_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 40 MHz - 2 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_2USERS_40MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_2USERS_40MHZ ( PRE_AGG_SUB_BAND_1 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 40 MHz - 3 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_3USERS_40MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_3USERS_40MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_5 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_3USERS_40MHZ ( PRE_AGG_SUB_BAND_1 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 40 MHz - 4 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_4USERS_40MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_4USERS_40MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_5 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_4USERS_40MHZ ( PRE_AGG_SUB_BAND_1 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER3_RCR_RU_4USERS_40MHZ ( PRE_AGG_SUB_BAND_1 | (PRE_AGG_START_RU_5 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_106_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 80 MHz - 2 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_2USERS_80MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_2USERS_80MHZ ( PRE_AGG_SUB_BAND_2 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 80 MHz - 3 users in DL MU MIMO
#ifdef ENET_INC_ARCH_WAVE600B
// According to standard, each 20MHz in TF spectrum must come with at least one RU allocation.
#define PRE_AGG_USER0_RCR_RU_3USERS_80MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_3USERS_80MHZ ( PRE_AGG_SUB_BAND_2 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_3USERS_80MHZ ( PRE_AGG_SUB_BAND_3 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#else
#define PRE_AGG_USER0_RCR_RU_3USERS_80MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_3USERS_80MHZ ( PRE_AGG_SUB_BAND_1 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_3USERS_80MHZ ( PRE_AGG_SUB_BAND_2 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#endif

// RCR RU definitions for BW 80 MHz - 4 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_4USERS_80MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_4USERS_80MHZ ( PRE_AGG_SUB_BAND_1 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_4USERS_80MHZ ( PRE_AGG_SUB_BAND_2 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER3_RCR_RU_4USERS_80MHZ ( PRE_AGG_SUB_BAND_3 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_242_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))


// RCR RU definitions for BW 160 MHz - 2 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_2USERS_160MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_996_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_2USERS_160MHZ ( PRE_AGG_SUB_BAND_4 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_996_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

// RCR RU definitions for BW 160 MHz - 3 users in DL MU MIMO
#ifdef ENET_INC_ARCH_WAVE600B
// According to standard, each 20MHz in TF spectrum must come with at least one RU allocation.
#define PRE_AGG_USER0_RCR_RU_3USERS_160MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_996_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_3USERS_160MHZ ( PRE_AGG_SUB_BAND_4 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_3USERS_160MHZ ( PRE_AGG_SUB_BAND_6 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#else
#define PRE_AGG_USER0_RCR_RU_3USERS_160MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_3USERS_160MHZ ( PRE_AGG_SUB_BAND_2 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_3USERS_160MHZ ( PRE_AGG_SUB_BAND_4 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#endif

// RCR RU definitions for BW 160 MHz - 4 users in DL MU MIMO
#define PRE_AGG_USER0_RCR_RU_4USERS_160MHZ ( PRE_AGG_SUB_BAND_0 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER1_RCR_RU_4USERS_160MHZ ( PRE_AGG_SUB_BAND_2 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER2_RCR_RU_4USERS_160MHZ ( PRE_AGG_SUB_BAND_4 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))
#define PRE_AGG_USER3_RCR_RU_4USERS_160MHZ ( PRE_AGG_SUB_BAND_6 | (PRE_AGG_START_RU_0 << RCR_START_RU_SHIFT) | (PRE_AGGREGATOR_484_TONE_RU_SIZE << RCR_RU_SIZE_SHIFT))

		
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_0_TO_3	((PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_0) 		| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_1 << 8)	| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_2 << 16)	| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_3 << 24))
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_4_TO_7	((PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_4) 		| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_5 << 8) 	| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_6 << 16) 	| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_7 << 24))
#define PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_8_TO_9	((PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_8)		| \
													(PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_9 << 8))

#define	DURATION_THRESHOLD_WORD_FORMAT_FACTOR 				0x8421


#define PRE_AGGREGATOR_11B_1M_MCS_INDEX 4
	
#define PHY_PREAMBLE_TIME_LEGACY									1280 //20micro-  in scale of 1/64 microseconds
#define PHY_PREAMBLE_TIME_HT										2304 //minimal value (one stream) , in scale of 1/64 microseconds
#define PHY_PREAMBLE_TIME_VHT										2560  //minimal value (one stream), in scale of 1/64 microseconds
#define SENDER_INIT_TIME_SINGLE_USER 								480//7.5 micro, in scale of 1/64 microseconds
#define SENDER_INIT_TIME_MULTY_USER 								960//15 micro, in scale of 1/64 microseconds
#define SENDER_INIT_TIME											SENDER_INIT_TIME_MULTY_USER
#define PHY_PREAMBLE_TIME											PHY_PREAMBLE_TIME_HT
#define PRE_AGGREGATOR_MU_TRAINING_DURATION				 			32000 // 345// 5.4 microseconds in scale of 1/64 microseconds
#define PRE_AGGREGATOR_MU_TRAINING_CTS2SELF_PROTECTION_METHOD		2//80Mhz 
#define PRE_AGGREGATOR_MU_TRAINING_NO_PROTECTION_METHOD				0
#define PRE_AGGREGATOR_MU_TRAINING_RTS_CTS_FORMAT 					3//Dynamic BW - only in case the training protection is RTS-CTS  (0x2)
#define PRE_AGGREGATOR_MU_NAX_NSTS									3 
#define PRE_AGGREGATOR_IGNORE_DYNAMIC_BW_20MHZ						0 
#define PRE_AGGREGATOR_BF_MU_TRAINING_FILLER_TYPE					0x01 	//CTS2SELF filler for BF MU training 
#define PRE_AGGREGATOR_MU_BAR_BACK_AIR_TIME_DURATION				438	 	//438 microseconds: SIFS + PHY Preabmle + BAR + SIFS + PHY Preamble + Block Ack (rate 6.5MHz (lowest VHT rate))
#define PRE_AGGREGATOR_MU_PSDU_LENGTH_RTS_CTS2SELD_THRE_SUM_MAX_N	0 	 


#define TRIGGER_FRAME_GENERATOR_NUM_OF_ENTRIES						64// size of TxTfGenerator memory in words of 32 bit

// PPDU duration limits (for ETSI) - 2 usec resolution
#define PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL				0x1FFF // No limit

#define PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_BE_VAL			2700 
#define PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_BK_VAL			2700 
#define PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_VO_VAL			800 
#define PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_VI_VAL			1800 

#define PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_BE_VAL		2550 
#define PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_BK_VAL		2550 
#define PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_VO_VAL		550 
#define PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_VI_VAL		2050 

#define PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_BE_VAL		2700 
#define PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_BK_VAL		2700 
#define PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_VO_VAL		800 
#define PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_VI_VAL		1800 

// BF sequence air time - 1 usec resolution
#define PRE_AGGREGATOR_BF_SEQ_AIR_TIME_DEFAULT_VAL					6000
#define PRE_AGGREGATOR_BF_SEQ_AIR_TIME_ETSI_VAL						6500

#ifdef WORKAROUND_FOR_HW_BUG_IN_PRE_AGG
#define TOMI_DL_HE_MU_IMMEDAITE_CFG_DEFAULT_VAL 0x02 // 10 // {TOMI DL MU Enable, TOMI UL MU Enable}
#define TOMI_DL_HE_MU_VHT_ALIKE_CFG_DEFAULT_VAL 0x00 // 00 // {TOMI DL MU Enable, TOMI UL MU Enable}
#define TOMI_DL_HE_MU_MU_BAR_CFG_DEFAULT_VAL	0x02 // 10 // {TOMI DL MU Enable, TOMI UL MU Enable}
#endif
#define TOMI_UL_HE_MU_CFG_DEFAULT_VAL			0x03 // 11 // {TOMI DL MU Enable, TOMI UL MU Enable}


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
#if defined(ENET_INC_LMAC0) || defined(ENET_INC_LMAC1) 

static PreAggRtsMem_t 					*PreAggRtsMem;
static PreAggParamsCalc_t				*PreAggParamsCalcMem;
static TxTfGeneratorNormalizedBands_t	*TxTfGenMem;

static PreAggCommonReportFifo_t *preAggCommonFifoPtr;
static PreAggUserReportFifo_t	*preAggUserFifoPtr;

static PreAggCommonReportFifo_t preAggLastCommonFifoReport;
static uint8 preAggCommonFifoReadIndex;
static uint8 preAggUserFifoReadIndex;

const PreAggRtsMem_t preAggRamValues =
{
	/* 11 B Duration Ratio*/
	{
		PRE_AGGREGATOR_DURTION_RATIO_TH_11B
	},
	/* 11 A\G Duration Ratio*/
	{
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_0,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_1,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_2,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_3,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_4,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_5,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_6,
		PRE_AGGREGATOR_DURTION_RATIO_TH_11_A_G_MCS_7
	},
	/* 11 N\AC  Duration Ratio*/
	{
		{
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_20_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_20_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_20_MHZ,	
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_20_MHZ
		},                                                        
		{                                                         
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_40_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_40_MHZ
		},                                                        
		{                                                         
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_80_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_80_MHZ
		} ,	
		{ 
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_0_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_1_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_2_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_3_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_4_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_5_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_6_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_7_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_8_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_9_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_10_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_11_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_12_160_MHZ,
			PRE_AGGREGATOR_DURTION_RATIO_TH_11_N_AC_AX_MCS_13_160_MHZ
		}
		
	},
	/* users RCR RU fields init */
	{
		{
			{
				/* RCR RU BW 20 - 2 users*/
				{
					{PRE_AGG_USER0_RCR_RU_2USERS_20MHZ | (PRE_AGG_USER1_RCR_RU_2USERS_20MHZ << RCR_RU_USER_SHIFT)},
					{ 0 },
				},
				/* RCR RU BW 20 - 3 users*/
				{
					{PRE_AGG_USER0_RCR_RU_3USERS_20MHZ | (PRE_AGG_USER1_RCR_RU_3USERS_20MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_3USERS_20MHZ | 0},
				},
				/* RCR RU BW 20 - 4 users */
				{
					{PRE_AGG_USER0_RCR_RU_4USERS_20MHZ | (PRE_AGG_USER1_RCR_RU_4USERS_20MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_4USERS_20MHZ | (PRE_AGG_USER3_RCR_RU_4USERS_20MHZ << RCR_RU_USER_SHIFT)},
				}
			}
		},
		{
			{
				/* RCR RU BW 40 - 2 users */
				{	
					{PRE_AGG_USER0_RCR_RU_2USERS_40MHZ | (PRE_AGG_USER1_RCR_RU_2USERS_40MHZ << RCR_RU_USER_SHIFT)},
					{0},
				},
				/* RCR RU BW 40 - 3 users */
				{	
					{PRE_AGG_USER0_RCR_RU_3USERS_40MHZ | (PRE_AGG_USER1_RCR_RU_3USERS_40MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_3USERS_40MHZ | 0},
				},
				/* RCR RU BW 40 - 4 users */
				{	
					{PRE_AGG_USER0_RCR_RU_4USERS_40MHZ | (PRE_AGG_USER1_RCR_RU_4USERS_40MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_4USERS_40MHZ | (PRE_AGG_USER3_RCR_RU_4USERS_40MHZ << RCR_RU_USER_SHIFT)},
				},
			}
		},
		{
			{
				/*RCR RU BW 80 - 2 users*/
				{
					{PRE_AGG_USER0_RCR_RU_2USERS_80MHZ | (PRE_AGG_USER1_RCR_RU_2USERS_80MHZ << RCR_RU_USER_SHIFT)},
					{0},
				},
					
				/*RCR RU BW 80 - 3 users*/
				{
					{PRE_AGG_USER0_RCR_RU_3USERS_80MHZ | (PRE_AGG_USER1_RCR_RU_3USERS_80MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_3USERS_80MHZ | 0},
				},
				/*RCR RU BW 80 - 4 users*/
				{
					{PRE_AGG_USER0_RCR_RU_4USERS_80MHZ | (PRE_AGG_USER1_RCR_RU_4USERS_80MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_4USERS_80MHZ | (PRE_AGG_USER3_RCR_RU_4USERS_80MHZ << RCR_RU_USER_SHIFT)},
				}
			}
		},
		{
			{
				/*RCR RU BW 160 - 2 users*/
				{
					{PRE_AGG_USER0_RCR_RU_2USERS_160MHZ | (PRE_AGG_USER1_RCR_RU_2USERS_160MHZ << RCR_RU_USER_SHIFT)},
					{0},
				},
				/*RCR RU BW 160 - 3 users*/
				{
					{PRE_AGG_USER0_RCR_RU_3USERS_160MHZ | (PRE_AGG_USER1_RCR_RU_3USERS_160MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_3USERS_160MHZ | 0},
				},
				/*RCR RU BW 160 - 4 users*/
				{
					{PRE_AGG_USER0_RCR_RU_4USERS_160MHZ | (PRE_AGG_USER1_RCR_RU_4USERS_160MHZ << RCR_RU_USER_SHIFT)},
					{PRE_AGG_USER2_RCR_RU_4USERS_160MHZ | (PRE_AGG_USER3_RCR_RU_4USERS_160MHZ << RCR_RU_USER_SHIFT)},
				}
			}
		}
	}
};

const uint8 preAggBwMapping[NUM_OF_BW_VALUES] = {9,18,36,72}; //from standard - lilia to elaborate
const uint8 preAggRuMapping[PRE_AGG_MAX_RU_NUM+1] = {1, 2, 4, 9, 18, 36, 72, 255}; // this mapping contains 8 entires, the last one with invalid value. because the memory of 


const TxTfGeneratorNormalizedBands_t TxTFGenNormalizedSubBands[TRIGGER_FRAME_GENERATOR_NUM_OF_ENTRIES] = 
{
								/* RuSize, StartRu*/
		{0, 9, 19, 28},			//	0		0
		{1, 10, 20, 29},		//	0		1	
		{2, 11, 21, 30},		//	0		2
		{3, 12, 22, 31},		//	0		3
		{4, 13, 23, 32},		//	0		4
		{5, 14, 24, 33},		//	0		5
		{6, 15, 25, 34},		//	0		6
		{7, 16, 26, 35},		//	0		7
		{8, 17, 27, 36},		//	0		8
		{255, 18, 255, 255},	//	0		9
		{37, 41, 45, 49},		//	1		0
		{255, 255, 255, 255},	//	1		1
		{38, 42, 46, 50},		//	1		2
		{255, 255, 255, 255},	//	1		3
		{255, 255, 255, 255},	//	1		4
		{39, 43, 47, 51},		//	1		5	
		{255, 255, 255, 255},	//	1		6
		{40, 44, 48, 52},		//	1		7
		{255, 255, 255, 255},	//	1		8
		{255, 255, 255, 255},	//	1		9
		{53, 55, 57, 59},		//	2		0
		{255, 255, 255, 255},	//	2		1
		{255, 255, 255, 255},	//	2		2
		{255, 255, 255, 255},	//	2		3
		{255, 255, 255, 255},	//	2		4
		{54, 56, 58, 60},		//	2		5
		{255, 255, 255, 255},	//	2		6
		{255, 255, 255, 255},	//	2		7
		{255, 255, 255, 255},	//	2		8
		{255, 255, 255, 255},	//	2		9
		{61, 62, 63, 64},		//	3		0
		{255, 255, 255, 255},	//	3		1
		{255, 255, 255, 255},	//	3		2
		{255, 255, 255, 255},	//	3		3
		{255, 255, 255, 255},	//	3		4
		{255, 255, 255, 255},	//	3		5
		{255, 255, 255, 255},	//	3		6
		{255, 255, 255, 255},	//	3		7
		{255, 255, 255, 255},	//	3		8
		{255, 255, 255, 255},	//	3		9
		{65, 255, 66, 255},		//	4		0
		{255, 255, 255, 255},	//	4		1
		{255, 255, 255, 255},	//	4		2
		{255, 255, 255, 255},	//	4		3
		{255, 255, 255, 255},	//	4		4
		{255, 255, 255, 255},	//	4		5
		{255, 255, 255, 255},	//	4		6
		{255, 255, 255, 255},	//	4		7
		{255, 255, 255, 255},	//	4		8
		{255, 255, 255, 255},	//	4		9
		{67, 255, 255, 255},	// 	5		0
		{255, 255, 255, 255},	//	5		1
		{255, 255, 255, 255},	//	5		2
		{255, 255, 255, 255},	//	5		3
		{255, 255, 255, 255},	//	5		4
		{255, 255, 255, 255},	//	5		5
		{255, 255, 255, 255},	//	5		6
		{255, 255, 255, 255},	//	5		7
		{255, 255, 255, 255},	//	5		8
		{255, 255, 255, 255},	//	5		9
		{68, 255, 255, 255},	//	6		0
		{255, 255, 255, 255},	//	6		1
		{255, 255, 255, 255},	//	6		2
		{255, 255, 255, 255},	//	6		3
		
};

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Debug Section									
/----------------------------------------------------------------------------------*/
uint32 AAA_PreAggInterruptStatusVal = 0;


/*---------------------------------------------------------------------------------
/						Static Functions Declarartions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

PreAggregator_FillConfigurationDb


Description:
------------
	Fill aggregation builder configuration Ram in Shram with:
		1) cts2self Bytes TH
		2)
		3)
		4)
	

Input:
-----
	vapIndex - VAp Index
	protectionRate - Rate of the protection frames
Output:
-------
	None
**********************************************************************************/
void PreAggregator_FillConfigurationDb(uint32 vapIndex,uint32 protectionRate, uint32 protectionPhyMode, uint32 fillerRate ,uint32 fillerPhyMode )
{
	AggrDb_t *configurationDb = &PreAggregatorConfigurationDb[vapIndex];
	RegPreAggMaxPsduSizeHe_u maxPsduSize;
	RegAccess_Read(REG_PRE_AGG_MAX_PSDU_SIZE_HE,&maxPsduSize.val);
	
	configurationDb->cts2SelfByteLengthThreshold = MAX(maxPsduSize.bitFields.maxPsduSizeHe & RTS_THRESHOLD_MASK_20_BITS, RTS_THRESHOLD_MASK_20_BITS); //masking is due to hw bug WLANVLSIIP-3970 - bit field size is only 20 bits, psdu max is 0x3fffff 
	configurationDb->rtsCtsByteLengthThreshold 	 = MAX(maxPsduSize.bitFields.maxPsduSizeHe & RTS_THRESHOLD_MASK_20_BITS, RTS_THRESHOLD_MASK_20_BITS); //MAX action is to prevent threshold from being '0', e.g if maxPsduSize is 0x400000.

	/* Fill the protection Air Time Duration */
	if(protectionPhyMode == PHY_MODE_11B)
	{
		configurationDb->cts2SelfAirTimeDuration	 = Protocol_GetAckCts11bAirTime(protectionRate)+ SIFS_TIME_11B; 
		configurationDb->rtsCtsfAirTimeDuration		 = Protocol_GetRtsCfEnd11bAirTime(protectionRate) + SIFS_TIME_11B + configurationDb->cts2SelfAirTimeDuration;
	}
	else
	{
		configurationDb->cts2SelfAirTimeDuration	 = Protocol_GetAckCts11agAirTime(protectionRate)+ SIFS_TIME_11A; //60
		configurationDb->rtsCtsfAirTimeDuration		 = Protocol_GetRtsCfEnd11agAirTime(protectionRate) + SIFS_TIME_11A + configurationDb->cts2SelfAirTimeDuration; //128
	}

	/* Fill the filler Air Time Duration which can be different from protection duration */
	if(fillerPhyMode == PHY_MODE_11B)
	{
		configurationDb->fillerCts2SelfAirTimeDuartion	= Protocol_GetAckCts11bAirTime(fillerRate)+ SIFS_TIME_11B;
		configurationDb->fillerRtsCtsAirTimeDuartion	= Protocol_GetRtsCfEnd11bAirTime(fillerRate) + SIFS_TIME_11B + configurationDb->cts2SelfAirTimeDuration;
		configurationDb->fillerNdpAckAirTimeDuartion	= Protocol_GetNdp11bAirTime(fillerRate) + SIFS_TIME_11B + configurationDb->fillerCts2SelfAirTimeDuartion;
	}
	else
	{
		
		configurationDb->fillerCts2SelfAirTimeDuartion	= Protocol_GetAckCts11agAirTime(fillerRate)+ SIFS_TIME_11A;
		configurationDb->fillerRtsCtsAirTimeDuartion	= Protocol_GetRtsCfEnd11agAirTime(fillerRate) + SIFS_TIME_11A + configurationDb->cts2SelfAirTimeDuration;
		configurationDb->fillerNdpAckAirTimeDuartion	= Protocol_GetNdp11agAirTime(fillerRate) + SIFS_TIME_11A  + configurationDb->fillerCts2SelfAirTimeDuartion;
	}
}


/**********************************************************************************

PreAggregator_SetForceProtection  

Description:
------------



Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_SetForceProtection(uint32 vapIndex, PreAggForceProtectionMode_e forceProtectionMode, uint32 forceProtectionOnOff)
{
	RegPreAggForceCts2SelfVap_u forceCts2SelfVapReg;
	RegPreAggForceRtsCtsVap_u forceRtsCtsVapReg;
	uint32 maskVal;

	maskVal = (1 << vapIndex);			

	if(forceProtectionMode == PRE_AGGREGATOR_FORCE_PROTECTION_MODE_RTS)
	{			
		forceRtsCtsVapReg.val = (forceProtectionOnOff << vapIndex);
		forceCts2SelfVapReg.val = 0x0;
		RegAccess_WriteMasked(REG_PRE_AGG_FORCE_RTS_CTS_VAP, maskVal, forceRtsCtsVapReg.val);		
		RegAccess_WriteMasked(REG_PRE_AGG_FORCE_CTS2SELF_VAP, maskVal, forceCts2SelfVapReg.val); //zero the other protection mode	
	}
	else
	{		
		forceCts2SelfVapReg.val = (forceProtectionOnOff << vapIndex);		
		forceRtsCtsVapReg.val = 0x0;
		RegAccess_WriteMasked(REG_PRE_AGG_FORCE_CTS2SELF_VAP, maskVal, forceCts2SelfVapReg.val);
		RegAccess_WriteMasked(REG_PRE_AGG_FORCE_RTS_CTS_VAP, maskVal, forceRtsCtsVapReg.val); //zero the other protection mode	
	}	
}


/**********************************************************************************

PreAggregator_Set11BPreambleOverride  


Description:
------------
trigger the aggregation builder module to start its operation


Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_Set11BPreambleOverride(uint32 enable11bPreambleOverride, uint32 mcs0Replacment)
{
	RegPreAggPreamble11BTypeControl_u preamble11bTypeControlReg;
		
	preamble11bTypeControlReg.val = 0;

	/* Configure 11B preamble to be taken from aggregation bulder instead of DB*/
	preamble11bTypeControlReg.bitFields.preamble11BTypeEn = enable11bPreambleOverride;
	preamble11bTypeControlReg.bitFields.preamble11BMcs000Replacement = mcs0Replacment;
	
	RegAccess_Write(REG_PRE_AGG_PREAMBLE_11B_TYPE_CONTROL, preamble11bTypeControlReg.val);
}

/**********************************************************************************

PreAggregator_Set11bPreambleMode  


Description:
------------
trigger the aggregation builder module to start its operation


Input:
-----
	vapIndex
	preambleMode

	
**********************************************************************************/
void PreAggregator_Set11bPreambleMode(uint32 vapIndex, PreAgg11BPreambleMode_e preambleMode)
{
	RegPreAggPreamble11BTypeVap_u preamble11BTypeVapReg;
	uint32 maskVal;

	preamble11BTypeVapReg.val = (preambleMode << vapIndex);
	maskVal = (1 << vapIndex);
		
	RegAccess_WriteMasked(REG_PRE_AGG_PREAMBLE_11B_TYPE_VAP, maskVal, preamble11BTypeVapReg.val);
}
/**********************************************************************************

PreAggregator_Get11BPreambleOverrideMode  


Description:
------------
Return  preamble mode per vap if preamble11BTypeEn is enabled else return 0

Input:
-----
	vapIndex

	
**********************************************************************************/

void  PreAggregator_Get11BPreambleOverrideMode(uint32 vapIndex, bool* isOvverideEnabled, PreAgg11BPreambleMode_e* preambleMode)
{
	RegPreAggPreamble11BTypeVap_u preamble11BTypeVapReg;
	RegPreAggPreamble11BTypeControl_u preamble11bTypeControlReg;
	
	RegAccess_Read(REG_PRE_AGG_PREAMBLE_11B_TYPE_CONTROL,&preamble11bTypeControlReg.val);
	RegAccess_Read(REG_PRE_AGG_PREAMBLE_11B_TYPE_VAP, &preamble11BTypeVapReg.val);
	
	*preambleMode = (PreAgg11BPreambleMode_e)((preamble11BTypeVapReg.val >> vapIndex) & 0x1);
	*isOvverideEnabled = preamble11bTypeControlReg.bitFields.preamble11BTypeEn;
}


/**********************************************************************************

HwEventsPreAggregator_Error  


Description:
------------
interrupt routine that handles errors scenarios and done operation in the aggregation builder operation

Input:
-----
	None
Output:
-------
	None
**********************************************************************************/
void HwEventsPreAggregator_Error(void)
{
	RegPreAggPreAggStatusIrq_u interruptStatusRegister;

	interruptStatusRegister.val = 0;
	
	// Read the status register (check which error occurred) 
	RegAccess_Read(REG_PRE_AGG_PRE_AGG_STATUS_IRQ, &interruptStatusRegister.val);

	AAA_PreAggInterruptStatusVal = interruptStatusRegister.val;

	FATAL("isr_PreAggregator_ErrorOrDone");	 
}

/**********************************************************************************

PreAggFillInParamsCalcMem  


Description:
------------
fills in PreAgg Params calc memory with inital values

Input:
-----
	None
Output:
-------
	None
**********************************************************************************/

void PreAggFillInParamsCalcMem(void)
{
	uint8 ruIndex=0;
	uint8 mcsIndex = 0;
	uint8 dcm = 0;
	uint8 tableIndex = 0;
	uint8 dmaIndex = 0;
	uint8 bwIndex = 0;
	PreAggParamsCalcHe_t heSymbolSize;
	PreAggParamsCalcVht_t vhtSymbolSize; 
	PreAggParamsCalcMu_t inversedDmaRate;
	uint16 convertedDmaTotalTp;

	heSymbolSize.word0 = 0;
	vhtSymbolSize.word0 = 0;
	inversedDmaRate.word0 = 0;
	
	
	for(ruIndex = 0; ruIndex < PRE_AGG_MAX_RU_NUM; ruIndex++)
	{
		for(mcsIndex = 0; mcsIndex < PRE_AGG_MAX_HE_MCS_NUM; mcsIndex++)
		{
			for(dcm=0; dcm < PRE_AGG_MAX_DCM_NUM; dcm++)
			{	
				// calculate index in he symbols table based on formula: Ru*14*2 + mcs*2 + dcm
				tableIndex = (((ruIndex*PRE_AGG_MAX_HE_MCS_NUM ) << 1) + (mcsIndex << 1) + dcm);
				// calculate heSymbolSize1 based on formula: Roundup(Ncbps/1944)*1944*R/8.
				//Ncbps,Ndbps and R values are taken from tables in 802.11ax Spec section 28.5 - per specific Ru, Mcs and Dcm with Nss=1.
				heSymbolSize.heSymbolSize1 = ((HeMcsValsPerRu[ruIndex][mcsIndex][dcm].ncbps + NCBPS_DIV_FACTOR)/ NCBPS_DIV_FACTOR)*NCBPS_DIV_FACTOR;
				heSymbolSize.heSymbolSize1 = ((heSymbolSize.heSymbolSize1 * rFactorValues[mcsIndex].rNumerator) >> 3) / rFactorValues[mcsIndex].rDenominator;
				// calculate 	
				heSymbolSize.heSymbolSize2 = ((HeMcsValsPerRu[ruIndex][mcsIndex][dcm].ndbps + NDBPS_DIV_FACTOR)/NDBPS_DIV_FACTOR) << 4;
				// fill in NUM_HE_SYMBOL_SIZE entires of he symbol size table
				memcpy32(&PreAggParamsCalcMem->he[tableIndex].word0 , &heSymbolSize.word0, 1);
				
			}
		}
	}
		// fill in NUM_VHT_SYMBOL_SIZE entries of vht symbol size table
		// index in vht symbols table is calculated based on formula: MCs*4+bw
		// calculate vhtSymbolSize1 based on formula: Roundup(Ncbps/1944)*1944*R/8.
		// calculate vhtSymbolSize2 based on formula: Roundup(Ndbps/128)*16
		// Ncbps,Ndbps and R values are taken from tables in 802.11 Spec section 21.5 - per BW and Mcs with Nss=1.
	for(mcsIndex = 0; mcsIndex < PRE_AGG_MAX_VHT_MCS_NUM; mcsIndex ++)
	{

		for (bwIndex = 0; bwIndex < NUM_OF_BW_VALUES; bwIndex++)
		{
			tableIndex = (mcsIndex* NUM_OF_BW_VALUES) + bwIndex;
			vhtSymbolSize.vhtSymbolSize1 = ((VhtMcsValsPerBw[bwIndex][mcsIndex].ncbps + NCBPS_DIV_FACTOR)/ NCBPS_DIV_FACTOR)*NCBPS_DIV_FACTOR;
			vhtSymbolSize.vhtSymbolSize1 = ((vhtSymbolSize.vhtSymbolSize1 * rFactorValues[mcsIndex].rNumerator) >> 3) / rFactorValues[mcsIndex].rDenominator;
			vhtSymbolSize.vhtSymbolSize2 = ((VhtMcsValsPerBw[bwIndex][mcsIndex].ndbps + NDBPS_DIV_FACTOR)/NDBPS_DIV_FACTOR) << 4;
			memcpy32(&PreAggParamsCalcMem->vht[tableIndex].word0, &vhtSymbolSize.word0, 1);
		}
	}
	//	fill in Inversed DMA rate memory
	memset32(PreAggParamsCalcMem->mu, 1, NUM_HE_DMA_RATE);


	convertedDmaTotalTp = ConfigurationManager_GetTotalDmaTp()/PRE_AGG_DMA_TOTAL_TP_UNIT_SIZE;

	if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND)
	{
		// In dual band mode - each channel of DMA should get only half of the BW.
		convertedDmaTotalTp = convertedDmaTotalTp / 2;
	}
	
	for(bwIndex = 0; bwIndex < NUM_OF_BW_VALUES; bwIndex++)
	{
		ruIndex = 0;
		for(dmaIndex = 0; dmaIndex < PRE_AGG_INVERSED_DMA_ENTRIES_PER_BW; dmaIndex++)	
		{
			tableIndex = (dmaIndex + (bwIndex*PRE_AGG_INVERSED_DMA_ENTRIES_PER_BW));
			inversedDmaRate.inversedDmaRate1 = (preAggBwMapping[bwIndex] << PRE_AGG_INVERSE_DMA_RATE_SHIFT )/(convertedDmaTotalTp*preAggRuMapping[ruIndex]);
			ruIndex++;
			inversedDmaRate.inversedDmaRate2 = (preAggBwMapping[bwIndex] << PRE_AGG_INVERSE_DMA_RATE_SHIFT )/(convertedDmaTotalTp*preAggRuMapping[ruIndex]);
			ruIndex++;
			memcpy32(&PreAggParamsCalcMem->mu[tableIndex].word0, &inversedDmaRate.word0, 1);
		}
	}
}

/**********************************************************************************

PreAggregator_SetBwToSub
BandMappingReg  


Description:
------------
initialize register bw_2_sub_band_Mapping based on parameters from setChannelRequest message
which was forwarded from HostApd

Input:
-----
bw - requested bw
sub_band - requested primary sub_band
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

void PreAggregator_SetBwToSubBandMappingReg(uint8 subBand)
{
	RegPreAggBw2SubBandMapping_u bw2SubBandMappingReg;
	PreAggRtsMemPerBw_2_t rcrRuPerBwTemp;
	PreAggRtsMemPerBw_2_t *rcrRuPerBw = NULL;
	
	
	// need to update bw_2_sub_band_mapping register and sub_band field for each USER RCR RU field for all BWs
	// USER RCR RU Field structure: sub_band - bits [0..2], start_ru: bits [3..6], ru_size: bits[7..9] 

	bw2SubBandMappingReg.bitFields.bw2SubBandMapP20Mhz = (1 << subBand);
	bw2SubBandMappingReg.bitFields.bw2SubBandMapP40Mhz = (PRE_AGG_BW_40MHZ_TO_SUB_BAND_MAPPING_MASK << ((subBand/PRE_AGG_SUB_BAND_MASK_40MHZ_SIZE) << 1));
	bw2SubBandMappingReg.bitFields.bw2SubBandMapP80Mhz = (PRE_AGG_BW_80MHZ_TO_SUB_BAND_MAPPING_MASK << ((subBand/PRE_AGG_SUB_BAND_MASK_80MHZ_SIZE) << 2));
	bw2SubBandMappingReg.bitFields.bw2SubBandMapP160Mhz = 0xFF;

	// write value to register
	RegAccess_Write(REG_PRE_AGG_BW_2_SUB_BAND_MAPPING, bw2SubBandMappingReg.val);


	/* configuration for BW = 20*/
	rcrRuPerBw = &PreAggRtsMem->perBw2[BANDWIDTH_TWENTY];
	memcpy32(&rcrRuPerBwTemp, rcrRuPerBw, CONVERT_BYTES_TO_WORDS(sizeof(PreAggRtsMemPerBw_2_t)));
	//in case of BW 20, the sub_band provided is configured in sub_band field
	// mask applied in order to make sure that only 3 LSB bits of sub_band are overwritten

	// configure case of 2 users in DL MU MIMO
	rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	// configure case of 3 users in DL MU MIMO
	rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	// configure case of 4 users in DL MU MIMO
	rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;
	rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | subBand;

	// copy changed values back to RCR ru memory - access to memory only in words
	memcpy32(rcrRuPerBw, &rcrRuPerBwTemp, CONVERT_BYTES_TO_WORDS(sizeof(PreAggRtsMemPerBw_2_t)));


	/* configuration for BW = 40*/

	rcrRuPerBw = &PreAggRtsMem->perBw2[BANDWIDTH_FOURTY];
	memcpy32(&rcrRuPerBwTemp, rcrRuPerBw, CONVERT_BYTES_TO_WORDS(sizeof(PreAggRtsMemPerBw_2_t)));

	// for sub bands 0,1 - division result by 2 is 0, shift result is zero - bits 0,1 are set
	// for sub bands 2,3 - division result by 2 is 1. mask is shifted by 2 - bits 2,3 are set
	// for sub bands 4,5 - division result by 2 is 2. mask is shifted by 4 - bits 4,5 are set
	// for sub bands 6,7 - division result by 2 is 3. mask is shifted by 6 - bits 6,7 are set
	switch(subBand)
	{
		case PRE_AGG_SUB_BAND_0:
		case PRE_AGG_SUB_BAND_1:
			
			// configure case of 2 users in DL MU MIMO - each gets 20 MHz
			rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0;
			rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_1;
			// configure case of 3 users in DL MU MIMO - each gets 10 MHz. first 2 users go to first sub band and third one to the second sub band
			rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0; 
			rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0;
			rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_1;
			// configure case of 4 users in DL MU MIMO - each egts 10 Mhz. First two users are in first sub band, second 2 users are in second sub band
			rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0;
			rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0;
			rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_1;
			rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_1;
			break;
			
		case PRE_AGG_SUB_BAND_2:
		case PRE_AGG_SUB_BAND_3:
			// configure case of 2 users in DL MU MIMO - each gets 20 MHz
			rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_3;
			// configure case of 3 users in DL MU MIMO - each gets 10 MHz. first 2 users go to first sub band and third one to the second sub band
			rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2; 
			rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_3;
			// configure case of 4 users in DL MU MIMO - each egts 10 Mhz. First two users are in first sub band, second 2 users are in second sub band
			rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_3;
			rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_3;
			break;
			
		case PRE_AGG_SUB_BAND_4:
		case PRE_AGG_SUB_BAND_5:
			// configure case of 2 users in DL MU MIMO - each gets 20 MHz
			rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4;
			rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_5;
			// configure case of 3 users in DL MU MIMO - each gets 10 MHz. first 2 users go to first sub band and third one to the second sub band
			rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4; 
			rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4;
			rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_5;
			// configure case of 4 users in DL MU MIMO - each egts 10 Mhz. First two users are in first sub band, second 2 users are in second sub band
			rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4;
			rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4;
			rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_5;
			rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_5;
			break;
			
		case PRE_AGG_SUB_BAND_6:
		case PRE_AGG_SUB_BAND_7:
			// configure case of 2 users in DL MU MIMO - each gets 20 MHz
			rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_7;
			// configure case of 3 users in DL MU MIMO - each gets 10 MHz. firs 2 users go to first sub band and third one to the second sub band
			rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6; 
			rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_7;
			// configure case of 4 users in DL MU MIMO - each egts 10 Mhz. First two users are in first sub band, second 2 users are in second sub band
			rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_7;
			rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_7;
			break;

		default:					
			FATAL("PreAggregator_SetBwToSubBandMappingReg: BW Fourty - Sub-band not supported");
	}

	// copy changed values back to RCR ru memory - access to memory only in words
	memcpy32(rcrRuPerBw, &rcrRuPerBwTemp, CONVERT_BYTES_TO_WORDS(sizeof(PreAggRtsMemPerBw_2_t)));


	/* configuration for BW = 80*/

	rcrRuPerBw = &PreAggRtsMem->perBw2[BANDWIDTH_EIGHTY];
	memcpy32(&rcrRuPerBwTemp, rcrRuPerBw, CONVERT_BYTES_TO_WORDS(sizeof(PreAggRtsMemPerBw_2_t)));

	// for sub bands 0,1,2,3 - division result by 4 is 0, shift result is zero - bits 0,1,2,3 are set
	// for sub bands 4,5,6,7 - division result by 4 is 1. mask is shifted by 4 - bits 4,5,6,7 are set
	switch(subBand)
	{
		case PRE_AGG_SUB_BAND_0:
		case PRE_AGG_SUB_BAND_1:
		case PRE_AGG_SUB_BAND_2:
		case PRE_AGG_SUB_BAND_3:		
			// configure case of 2 users in DL MU MIMO - each gets 40 MHz 
			rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0;
			rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			// configure case of 3 users in DL MU MIMO - each gets 20 MHz. 
			rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0; 
			rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_1;
			rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			// configure case of 4 users in DL MU MIMO - each gets 20 Mhz. 
			rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_0;
			rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_1;
			rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_2;
			rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_3;
			break;
			
		case PRE_AGG_SUB_BAND_4:
		case PRE_AGG_SUB_BAND_5:
		case PRE_AGG_SUB_BAND_6:
		case PRE_AGG_SUB_BAND_7:
			// configure case of 2 users in DL MU MIMO - each gets 40 MHz
			rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4;
			rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[0].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			// configure case of 3 users in DL MU MIMO - each gets 20 MHz. 
			rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4; 
			rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_5;
			rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[1].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			// configure case of 4 users in DL MU MIMO - each gets 20 Mhz.
			rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user0RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_4;
			rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user1RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_5;
			rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user2RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_6;
			rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields = (rcrRuPerBwTemp.rcrRu[2].user3RcrRuFields & PRE_AGG_SUB_BAND_FIELD_IMASK) | PRE_AGG_SUB_BAND_7;
			break;
			
		default:
			FATAL("PreAggregator_SetBwToSubBandMappingReg: BW Eight - Sub-band not supported");
		}
	
	// copy changed values back to RCR ru memory - access to memory only in words
	memcpy32(rcrRuPerBw, &rcrRuPerBwTemp, CONVERT_BYTES_TO_WORDS(sizeof(PreAggRtsMemPerBw_2_t)));
	
	/*no need to configure rcrRuPerBw in PreAggRtsMem for BW = 160 and 80+80 - those cases already preconfigured in initialization of this memory*/

}


void PreAggregator_GetCommonFifoReport(PreAggCommonReportFifo_t *pCommonReport)
{
	RegPreAggPreAggCmnRptFifoRdEntriesNum_u numOfReadEntries;
	
	numOfReadEntries.val = 0;
	numOfReadEntries.bitFields.preAggCmnRptFifoRdEntriesNum = 1;
	memcpy32(pCommonReport, &preAggCommonFifoPtr[preAggCommonFifoReadIndex], (sizeof(PreAggCommonReportFifo_t) >> 2));
	// increment index and handle wrap-around if needed
	preAggCommonFifoReadIndex++;
	if(preAggCommonFifoReadIndex > (PRE_AGG_COMMON_FIFO_SIZE - 1))
	{
		preAggCommonFifoReadIndex = 0;
	}

	RegAccess_Write(REG_PRE_AGG_PRE_AGG_CMN_RPT_FIFO_RD_ENTRIES_NUM, numOfReadEntries.val);
}

void PreAggregator_GetUserFifoReport(PreAggUserReportFifo_t *pUserReport)
{
	memcpy32(pUserReport, &preAggUserFifoPtr[preAggUserFifoReadIndex], (sizeof(PreAggUserReportFifo_t) >> 2));

	SLOG0(0, 0, PreAggUserReportFifo_t, &preAggUserFifoPtr[preAggUserFifoReadIndex]);
	
	// increment index and handle wrap-around if needed
	preAggUserFifoReadIndex++;
	if(preAggUserFifoReadIndex > (PRE_AGG_USER_FIFO_SIZE - 1))
	{
		preAggUserFifoReadIndex = 0;
	}
}

void PreAggregator_ReportFifoNotEmptyEventHandler(void)
{

	RegPreAggPreAggCmnRptFifoNumEntriesCount_u commonReportsNumber;
	RegPreAggPreAggUsrRptFifoNumEntriesCount_u userReportsNum;
	RegPreAggPreAggUsrRptFifoRdEntriesNum_u numOfExtractedUserReports;
	uint8 i;
	PreAggFullReport_t preAggReport;
	uint8 previousTransactionNumber = 0;


	commonReportsNumber.val = 0;
	userReportsNum.val = 0;

	RegAccess_Read(REG_PRE_AGG_PRE_AGG_CMN_RPT_FIFO_NUM_ENTRIES_COUNT, &commonReportsNumber.val);
	RegAccess_Read(REG_PRE_AGG_PRE_AGG_USR_RPT_FIFO_NUM_ENTRIES_COUNT, &userReportsNum.val);
	
	// only PreAgg UserFifoNotEmpty interrupt is enabled
	for(i=0; i < userReportsNum.bitFields.preAggUsrRptFifoNumEntriesCount; i++)
	{ 
		PreAggregator_GetUserFifoReport(&preAggReport.userReport);
		if(preAggLastCommonFifoReport.preAggTransactionNumber!=preAggReport.userReport.preAggTransactionNumber)
		{
			// at least one common report must be in the FIFO when new user reports were sent
			DEBUG_ASSERT(commonReportsNumber.bitFields.preAggCmnRptFifoNumEntriesCount!=0);
			previousTransactionNumber = preAggLastCommonFifoReport.preAggTransactionNumber; 
			PreAggregator_GetCommonFifoReport(&preAggLastCommonFifoReport);
			// at this point transactionNumber at both reports types must be matching
			DEBUG_ASSERT(preAggLastCommonFifoReport.preAggTransactionNumber == preAggReport.userReport.preAggTransactionNumber);
			DEBUG_ASSERT(((previousTransactionNumber + 1) % (PRE_AGG_MAX_NUM_OF_COMMON_REPORTS + 1)) == preAggLastCommonFifoReport.preAggTransactionNumber);

			//TODO: there is a HW bug in A0 decribed in https://jira-chd.intel.com/browse/WLANVLSIIP-2943.
			// if new common report is read, the user report that was read is the first user report of this common report.
			// due to HW bug first user report is not valid (contains garbage) and should be dropped by FW.
			// before forwarding the report to relevant module first check if this is not a first user report - real first user report is found in second report
			// last user report is lost in case of BW = 160 MHZ. 
			// last user report can be received for BW <160 MHZ if one extra dummy user will be defined in Plan but won't be transmitted.
			SLOG0(0, 0, PreAggCommonReportFifo_t, &preAggLastCommonFifoReport);
		}
		// copy the common part to the full report 
		memcpy32(&preAggReport.commonReport, &preAggLastCommonFifoReport, (sizeof(PreAggCommonReportFifo_t) >> 2));
#ifdef ENET_INC_ARCH_WAVE600B
		linkAdaptationProcessPreAggReport(&preAggReport);
#endif
	}
	numOfExtractedUserReports.val = 0;
	numOfExtractedUserReports.bitFields.preAggUsrRptFifoRdEntriesNum = userReportsNum.bitFields.preAggUsrRptFifoNumEntriesCount;
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_USR_RPT_FIFO_RD_ENTRIES_NUM, numOfExtractedUserReports.val);	
}


/**********************************************************************************

PreAggregator_InitReportFifos  


Description:
------------
initialize common and user report fifos pointers

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_InitReportFifos()
{
	memset(&preAggLastCommonFifoReport, 0, sizeof(PreAggCommonReportFifo_t)); 
	preAggLastCommonFifoReport.preAggTransactionNumber = 0xFF;

	preAggCommonFifoReadIndex = 0;
	preAggUserFifoReadIndex = 0;
	
#if defined(ENET_INC_LMAC0) 
		
	preAggCommonFifoPtr = TxPreAggregatorCommonFifo;
	preAggUserFifoPtr = TxPreAggregatorUserFifo;
#endif
	
#if defined(ENET_INC_LMAC1) 
		
	preAggCommonFifoPtr = TxPreAggregatorCommonFifoB1;
	preAggUserFifoPtr = TxPreAggregatorUserFifoB1;
#endif

	memset(preAggCommonFifoPtr,	0, (sizeof(PreAggCommonReportFifo_t)*PRE_AGG_COMMON_FIFO_SIZE));
	memset(preAggUserFifoPtr,	0, (sizeof(PreAggUserReportFifo_t)*PRE_AGG_USER_FIFO_SIZE));
}

#ifdef ENET_INC_ARCH_WAVE600B
/**********************************************************************************

PreAggregator_SetPpduDurationLimits  


Description:
------------


Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_SetPpduDurationLimits(bool etsiMode)
{

	RegPreAggMaxSuPpduDurationLimit1_u suPpduDurationLimit1Reg;
	RegPreAggMaxSuPpduDurationLimit2_u suPpduDurationLimit2Reg;
	RegPreAggMaxVhtMuPpduDurationLimit1_u vhtMuPpduDurationLimit1Reg;
	RegPreAggMaxVhtMuPpduDurationLimit2_u vhtMuPpduDurationLimit2Reg;
	RegPreAggMaxHeMuPpduDurationLimit1_u heMuPpduDurationLimit1Reg;
	RegPreAggMaxHeMuPpduDurationLimit2_u heMuPpduDurationLimit2Reg;

	suPpduDurationLimit1Reg.val = 0;
	suPpduDurationLimit2Reg.val = 0;
	vhtMuPpduDurationLimit1Reg.val = 0;
	vhtMuPpduDurationLimit2Reg.val = 0;
	heMuPpduDurationLimit1Reg.val = 0;
	heMuPpduDurationLimit2Reg.val = 0;

	if (etsiMode == FALSE)
	{
		suPpduDurationLimit1Reg.bitFields.maxSuPpduDurationLimitBe = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		suPpduDurationLimit1Reg.bitFields.maxSuPpduDurationLimitBk = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		suPpduDurationLimit2Reg.bitFields.maxSuPpduDurationLimitVo = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		suPpduDurationLimit2Reg.bitFields.maxSuPpduDurationLimitVi = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		
		vhtMuPpduDurationLimit1Reg.bitFields.maxVhtMuPpduDurationLimitBe = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		vhtMuPpduDurationLimit1Reg.bitFields.maxVhtMuPpduDurationLimitBk = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		vhtMuPpduDurationLimit2Reg.bitFields.maxVhtMuPpduDurationLimitVo = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		vhtMuPpduDurationLimit2Reg.bitFields.maxVhtMuPpduDurationLimitVi = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		
		heMuPpduDurationLimit1Reg.bitFields.maxHeMuPpduDurationLimitBe = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		heMuPpduDurationLimit1Reg.bitFields.maxHeMuPpduDurationLimitBk = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		heMuPpduDurationLimit2Reg.bitFields.maxHeMuPpduDurationLimitVo = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
		heMuPpduDurationLimit2Reg.bitFields.maxHeMuPpduDurationLimitVi = PRE_AGGREGATOR_PPDU_DURATION_LIMIT_DEFAULT_VAL;
	}
	else
	{
		suPpduDurationLimit1Reg.bitFields.maxSuPpduDurationLimitBe = PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_BE_VAL;
		suPpduDurationLimit1Reg.bitFields.maxSuPpduDurationLimitBk = PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_BK_VAL;
		suPpduDurationLimit2Reg.bitFields.maxSuPpduDurationLimitVo = PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_VO_VAL;
		suPpduDurationLimit2Reg.bitFields.maxSuPpduDurationLimitVi = PRE_AGGREGATOR_SU_PPDU_DURATION_LIMIT_ETSI_VI_VAL;
		
		vhtMuPpduDurationLimit1Reg.bitFields.maxVhtMuPpduDurationLimitBe = PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_BE_VAL;
		vhtMuPpduDurationLimit1Reg.bitFields.maxVhtMuPpduDurationLimitBk = PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_BK_VAL;
		vhtMuPpduDurationLimit2Reg.bitFields.maxVhtMuPpduDurationLimitVo = PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_VO_VAL;
		vhtMuPpduDurationLimit2Reg.bitFields.maxVhtMuPpduDurationLimitVi = PRE_AGGREGATOR_VHT_MU_PPDU_DURATION_LIMIT_ETSI_VI_VAL;
		
		heMuPpduDurationLimit1Reg.bitFields.maxHeMuPpduDurationLimitBe = PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_BE_VAL;
		heMuPpduDurationLimit1Reg.bitFields.maxHeMuPpduDurationLimitBk = PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_BK_VAL;
		heMuPpduDurationLimit2Reg.bitFields.maxHeMuPpduDurationLimitVo = PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_VO_VAL;
		heMuPpduDurationLimit2Reg.bitFields.maxHeMuPpduDurationLimitVi = PRE_AGGREGATOR_HE_MU_PPDU_DURATION_LIMIT_ETSI_VI_VAL;
	}
	
	RegAccess_Write(REG_PRE_AGG_MAX_SU_PPDU_DURATION_LIMIT_1, suPpduDurationLimit1Reg.val); 	
	RegAccess_Write(REG_PRE_AGG_MAX_SU_PPDU_DURATION_LIMIT_2, suPpduDurationLimit2Reg.val);

	RegAccess_Write(REG_PRE_AGG_MAX_VHT_MU_PPDU_DURATION_LIMIT_1, vhtMuPpduDurationLimit1Reg.val);		
	RegAccess_Write(REG_PRE_AGG_MAX_VHT_MU_PPDU_DURATION_LIMIT_2, vhtMuPpduDurationLimit2Reg.val);
	
	RegAccess_Write(REG_PRE_AGG_MAX_HE_MU_PPDU_DURATION_LIMIT_1, heMuPpduDurationLimit1Reg.val);		
	RegAccess_Write(REG_PRE_AGG_MAX_HE_MU_PPDU_DURATION_LIMIT_2, heMuPpduDurationLimit2Reg.val);
}

/**********************************************************************************

PreAggregator_SetPpduDurationLimits  


Description:
------------


Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_SetBfSeqAirTimeDuration(bool etsiMode)
{

	RegPreAggBfSeqAirTimeDuration_u bfSeqAirTimeDurationReg;

	bfSeqAirTimeDurationReg.val = 0;

	if (etsiMode == FALSE)
	{
		bfSeqAirTimeDurationReg.bitFields.bfSeqAirTimeDuration = PRE_AGGREGATOR_BF_SEQ_AIR_TIME_DEFAULT_VAL;
	}
	else
	{
		bfSeqAirTimeDurationReg.bitFields.bfSeqAirTimeDuration = PRE_AGGREGATOR_BF_SEQ_AIR_TIME_ETSI_VAL;
	}
	RegAccess_Write(REG_PRE_AGG_BF_SEQ_AIR_TIME_DURATION, bfSeqAirTimeDurationReg.val);
}


#endif
#ifdef ENET_INC_ARCH_WAVE600D2
void PreAggregator_SetTfGenMaxNumOfStartingSS(uint8 maxNss)
{
	RegTfGeneratorTfGenParams0_u tfGenParams0Reg;

	tfGenParams0Reg.val = 0;
	tfGenParams0Reg.bitFields.startingSpatialStreamMaxValue = maxNss;
	RegAccess_Write(REG_TF_GENERATOR_TF_GEN_PARAMS_0, tfGenParams0Reg.val);
}
#endif

/**********************************************************************************

PreAggregator_SetTxopDuration  


Description:
------------
	Aggregation Builder TXOP air time duration limit cofiguration

Input:
-----
	uint16 txopDuration
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_SetTxopDuration(uint16 txopDuration)
{
	RegPreAggTxopAirTimeDuration_u regPreAggTxopAirTimeDuration;
	regPreAggTxopAirTimeDuration.val = 0;
	
	regPreAggTxopAirTimeDuration.bitFields.txopAirTimeDuration = txopDuration;
	RegAccess_Write(REG_PRE_AGG_TXOP_AIR_TIME_DURATION, regPreAggTxopAirTimeDuration.val);
}

/**********************************************************************************

PreAggregator_GetTxopDuration  


Description:
------------
	Aggregation Builder TXOP air time duration limit get

Input:
-----
			
Output:
-------
	uint32 txopDuration

Returns:
--------
	void - 
	
**********************************************************************************/
uint16 PreAggregator_GetTxopDuration()
{
	RegPreAggTxopAirTimeDuration_u regPreAggTxopAirTimeDuration;
	uint16 txopDuration = 0;

	regPreAggTxopAirTimeDuration.val = 0;
	RegAccess_Read(REG_PRE_AGG_TXOP_AIR_TIME_DURATION, &regPreAggTxopAirTimeDuration.val);

	txopDuration = (uint16)(regPreAggTxopAirTimeDuration.bitFields.txopAirTimeDuration & PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT);
	
	return txopDuration;
}

/**********************************************************************************

PreAggregator_Initialize  


Description:
------------
initialize the global tables and internal registers of the aggregation builder module

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void PreAggregator_Initialize()
{		
	RegPreAggPreAggStatusIrqMask_u interruptMaskRegister;
	RegPreAggPreAggTimerMinMax_u timerMinMaxReg;
	RegPreAggTxDurCalcControl_u txDurationCalcControl;
	RegPreAggAggConfigDb_u aggrConfigDbReg;	
	RegPreAggAggConfigDb4BOffset_u aggrConfigDbOffsetReg;	
	RegPreAggBfRptAnalyzerDeltaMcsNss_u bfRptAnalyzerDeltaMcsNss;
	RegPreAggMuMaxNsts_u	muMxNstsReg; 
	RegPreAggRtsCts2SelfControl_u	rtsCts2SelfControlReg; 
	RegPreAggMuMultUsrsTrainingControl_u muBfTrainingCtrlReg; 
	RegPreAggMuBarBackAirTimeDuration_u muBaAirTimeDurReg;
	RegPreAggMuGrpDbAddr_u muGrpDbAddrReg; 
	RegPreAggPreAggEnable_u preAggEnableReg;
	RegPreAggTxopAirTimeDuration_u regPreAggTxopAirTimeDuration;
	RegPreAggTcrBaseAddr1_u tcrBaseAddr1;
	RegPreAggTcrBaseAddr2_u tcrBaseAddr2;
	RegPreAggRcrBaseAddr_u rcrBaseAddr;
	RegPreAggPlanIndexToPointerLutBaseAddr_u planIndexToPointerLutBaseAddr;
	RegPreAggBarWinSizeConfig_u barWinSizeConfig;
	RegPreAggInvPhyDmaRatioSu_u phyDmaRatio;
	RegPreAggInvPhyDmaRatioMuMimo2Users_u phyDmaRatioMuMimo2Users;
	RegPreAggInvPhyDmaRatioMuMimo3Users_u phyDmaRatioMuMimo3Users;
	RegPreAggInvPhyDmaRatioMuMimo4Users_u phyDmaRatioMuMimo4Users;
	uint16 convertedDmaTotalTp;
	RegPreAggPreAggCmnRptFifoBaseAddr_u preAggCommonFifoRegister;
	RegPreAggPreAggCmnRptFifoDepthMinusOne_u preAggCommonFifoDepth;
	RegPreAggPreAggUsrRptFifoBaseAddr_u	preAggUserFifoRegister;
	RegPreAggPreAggUsrRptFifoDepthMinusOne_u preAggUserFifoDepth;
	RegPreAggPreAggRptFifoEn_u preAggReportEnableRegister;
	RegPreAggRdDbTcrsData80211PdType_u preAggRdDbTcrsData80211PdType;
#ifdef PRE_AGG_HE_MU_REGS_CONFIG_FIX
	RegPreAggHeMuDlUlDataPhaseDbConfig_u heMuDlUlDataPhaseDbConfig; 
	RegPreAggHeMuProtectionSoundingPhaseDbConfig_u heMuProtectionSoundingPhaseDbConfig;
#endif 	//PRE_AGG_HE_MU_REGS_CONFIG_FIX	
	RegPreAggPsduByteLenCalcParams_u psduByteLenCalcParams;

#ifdef TRIGGER_FRAME_GENERATOR_RU_ALLOCATION_WORKAROUND
	RegTfGeneratorTfGenRuAllocationParams_u tfGeneratorTfGenRuAllocationParams;
#endif //TRIGGER_FRAME_GENERATOR_RU_ALLOCATION_WORKAROUND
#ifdef ENET_INC_ARCH_WAVE600B
	RegPreAggPrimaryAcMngMap_u primaryAcMngMap;
	RegPreAggHeMuKeepUserCfg_u heMuKeepUser;
    RegTfGeneratorTfGenIntErrorEn_u regTfGenIntErrorEn;
#endif
	RegPreAggTomiMuDisableCfg_u	regPreAggTomiMuDisableCfg;
#ifndef ENET_INC_ARCH_WAVE600D2	
	RegPreAggHeMoMimoConfig_u regPreAggHeMoMimoConfig;
#endif

	interruptMaskRegister.val = 0;
	timerMinMaxReg.val = 0; 
	txDurationCalcControl.val = 0;
	aggrConfigDbReg.val = 0;
	aggrConfigDbOffsetReg.val = 0;
	bfRptAnalyzerDeltaMcsNss.val = 0;
	tcrBaseAddr1.val = 0;
	tcrBaseAddr2.val = 0;
	rcrBaseAddr.val = 0;
	muMxNstsReg.val = 0;
	rtsCts2SelfControlReg.val = 0;
	muBfTrainingCtrlReg.val = 0; 
	muBaAirTimeDurReg.val =0; 
	muGrpDbAddrReg.val = 0; 
	preAggEnableReg.val = 0;
	regPreAggTxopAirTimeDuration.val = 0;
	barWinSizeConfig.val = 0;
	phyDmaRatio.val = 0;
	phyDmaRatioMuMimo2Users.val = 0;
	phyDmaRatioMuMimo3Users.val = 0;
	phyDmaRatioMuMimo4Users.val = 0;
	preAggCommonFifoRegister.val = 0;
	preAggCommonFifoDepth.val = 0;
	preAggUserFifoRegister.val = 0;
	preAggUserFifoDepth.val = 0;
	preAggReportEnableRegister.val = 0;
	preAggRdDbTcrsData80211PdType.val = 0;
#ifndef ENET_INC_ARCH_WAVE600D2
	regPreAggHeMoMimoConfig.val = 0;
#endif

#ifdef PRE_AGG_HE_MU_REGS_CONFIG_FIX
	heMuDlUlDataPhaseDbConfig.val = 0;
	heMuProtectionSoundingPhaseDbConfig.val = 0; 
#endif //PRE_AGG_HE_MU_REGS_CONFIG_FIX 
	psduByteLenCalcParams.val = 0;
#ifdef ENET_INC_ARCH_WAVE600B
	primaryAcMngMap.val = 0;
	heMuKeepUser.val = 0;
    regTfGenIntErrorEn.val = 0;
#endif
	interruptMaskRegister.bitFields.operationTimerErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.txhdStartDuringOperationIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstPdPointerNullIrqMask = 0x1;
	interruptMaskRegister.bitFields.txSelPrimaryNotValidErrIrqMask = 0x1;
	interruptMaskRegister.bitFields.txSelNoUspValidErrIrqMask = 0x1;
#ifdef ENET_INC_ARCH_WAVE600B
	interruptMaskRegister.bitFields.cmnRptFifoFullDropIrqMask = 0x1;
	interruptMaskRegister.bitFields.cmnRptFifoDecLessThanZeroIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstUsrRptFifoFullDropIrqMask = 0x1;
	interruptMaskRegister.bitFields.usrRptFifoDecLessThanZeroIrqMask = 0x1;
	interruptMaskRegister.bitFields.nonFirstUsrRptFifoFullDropIrqMask = 0x1;
	interruptMaskRegister.bitFields.numOfSelctedTidsAboveMaxIrqMask = 0x1;
	interruptMaskRegister.bitFields.seqStartDuringOperationIrqMask = 0x1;
	interruptMaskRegister.bitFields.noPhaseValidInPlanIrqMask = 0x1;
	interruptMaskRegister.bitFields.noUsersValidInPhaseIrqMask = 0x1;
#endif
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_STATUS_IRQ_MASK, interruptMaskRegister.val);

	timerMinMaxReg.bitFields.preAggTimerMinEn = PRE_AGGREGATOR_ENABLE_MINIMUM_TIMER;
	timerMinMaxReg.bitFields.preAggTimerMin	  = System_ConvertUsToSystemClk(PRE_AGGREGATOR_MINIMUM_TIMER_IN_US); 
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_TIMER_MIN_MAX, timerMinMaxReg.val);

	/* Set  dur calculation to be aware of signal extension in case of ofdm transmission*/
	txDurationCalcControl.bitFields.txSeqDurMainOfdmAdd6MicroEn = PRE_AGGREGATOR_DISABLE_TX_SEQ_DUR_OFDM_DEC_6_US;
	txDurationCalcControl.bitFields.txMpduDurFieldOfdmDec6MicroEn = PRE_AGGREGATOR_DISABLE_TX_MPDU_DUR_OFDM_DEC_6_US;
	RegAccess_Write(REG_PRE_AGG_TX_DUR_CALC_CONTROL, txDurationCalcControl.val);
	
	/* Init  internal Aggreagtion Builder Ram -Ratio between protection frame and protected data */
#if defined(ENET_INC_LMAC0) 	
	PreAggRtsMem = (PreAggRtsMem_t *)(B0_PRE_AGG_PRE_AGG_MEM);
	PreAggParamsCalcMem = (PreAggParamsCalc_t *)(B0_PRE_AGG_TOP_PARAMS_CALC_MEM);
	TxTfGenMem = (TxTfGeneratorNormalizedBands_t*)(B0_TF_GENERATOR_MEM_BASE_ADDR);
#elif defined (ENET_INC_LMAC1) 
	PreAggRtsMem = (PreAggRtsMem_t *)(B1_PRE_AGG_PRE_AGG_MEM);
	PreAggParamsCalcMem = (PreAggParamsCalc_t *)(B1_PRE_AGG_TOP_PARAMS_CALC_MEM);
	TxTfGenMem = (TxTfGeneratorNormalizedBands_t*)(B1_TF_GENERATOR_MEM_BASE_ADDR);
#endif
	memcpy32((void *)PreAggRtsMem, (void *)&preAggRamValues, sizeof(PreAggRtsMem_t) >> 2);
	memcpy32((void *)TxTfGenMem, (void *)&TxTFGenNormalizedSubBands, TRIGGER_FRAME_GENERATOR_NUM_OF_ENTRIES);
	// this function initializes PreAggParamsCalcMem memory
	PreAggFillInParamsCalcMem();
	
	/* Init Pre Agg configuration in shram - Rts\Cts duration, Threshholds, filler duration*/
	memset32(PreAggregatorConfigurationDb,0,sizeof(AggrDb_t) >> 2);
	aggrConfigDbReg.bitFields.aggConfigDbBaseAddr = (uint32)&PreAggregatorConfigurationDb;
	aggrConfigDbReg.bitFields.aggConfigDbEntry4BSize = (sizeof(AggrDb_t) >> 2);
	RegAccess_Write(REG_PRE_AGG_AGG_CONFIG_DB, aggrConfigDbReg.val);
	aggrConfigDbOffsetReg.bitFields.aggConfigDb4BOffset = 0;
	RegAccess_Write(REG_PRE_AGG_AGG_CONFIG_DB_4B_OFFSET, aggrConfigDbOffsetReg.val);

	/*Aggregation Builder TXOP air time duration limit cofiguration*/
	regPreAggTxopAirTimeDuration.bitFields.txopAirTimeDuration = PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT;
	RegAccess_Write(REG_PRE_AGG_TXOP_AIR_TIME_DURATION, regPreAggTxopAirTimeDuration.val);

#ifdef ENET_INC_ARCH_WAVE600D2
	muMxNstsReg.bitFields.txMuMaxNsts = PRE_AGGREGATOR_MU_NAX_NSTS; //this is the theoretical maximum per transmission, used to validate number of NSSs used in a single transmission
	muMxNstsReg.bitFields.rxMuMaxNsts = PRE_AGGREGATOR_MU_NAX_NSTS; //this is the theoretical maximum per transmission, used to validate number of NSSs used in a single transmission
	RegAccess_Write(REG_PRE_AGG_MU_MAX_NSTS, muMxNstsReg.val);
#else
	muMxNstsReg.bitFields.muMaxNsts = PRE_AGGREGATOR_MU_NAX_NSTS; //this is the theoretical maximum per transmission, used to validate number of NSSs used in a single transmission
	RegAccess_Write(REG_PRE_AGG_MU_MAX_NSTS, muMxNstsReg.val);
#endif	

	rtsCts2SelfControlReg.bitFields.ignoreDynamicBw20Mhz =	PRE_AGGREGATOR_IGNORE_DYNAMIC_BW_20MHZ; 
	rtsCts2SelfControlReg.bitFields.muPsduLengthRtsCts2SelfThrSumMaxN =	PRE_AGGREGATOR_MU_PSDU_LENGTH_RTS_CTS2SELD_THRE_SUM_MAX_N;
	RegAccess_Write(REG_PRE_AGG_RTS_CTS2SELF_CONTROL, rtsCts2SelfControlReg.val);

	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingAirTimeDuration = PRE_AGGREGATOR_MU_TRAINING_DURATION; 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingBwLimit = BANDWIDTH_EIGHTY; //only initial value - this field has an API to be configured in runtime 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingFillerType = PRE_AGGREGATOR_BF_MU_TRAINING_FILLER_TYPE; 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingProtection = PRE_AGGREGATOR_MU_TRAINING_NO_PROTECTION_METHOD; 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingRtsCtsFormat = PRE_AGGREGATOR_MU_TRAINING_RTS_CTS_FORMAT; 
	RegAccess_Write(REG_PRE_AGG_MU_MULT_USRS_TRAINING_CONTROL,muBfTrainingCtrlReg.val);

	muBaAirTimeDurReg.bitFields.muBarBackAirTimeDuration = PRE_AGGREGATOR_MU_BAR_BACK_AIR_TIME_DURATION;
	RegAccess_Write(REG_PRE_AGG_MU_BAR_BACK_AIR_TIME_DURATION,muBaAirTimeDurReg.val);
		

	muGrpDbAddrReg.bitFields.muGrpDbBaseAddr = (uint32)(&GroupDbHwEntries[0]);
	muGrpDbAddrReg.bitFields.muGrpDbEntry4BSize = (sizeof(MuGrpDb_t) >> 2);
	RegAccess_Write(REG_PRE_AGG_MU_GRP_DB_ADDR,muGrpDbAddrReg.val);

	
	/*Aggregation BF Report Analyzer  Delta MCS & NSS*/
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsCpuRaFillerLow	= PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_INFORM_LMAC_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsCpuRaFillerHigh	= PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_INFORM_LMAC_HIGH;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsDoNothingLow	= PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_DO_NOTHING_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsDoNothingHigh	= PRE_AGGREGATOR_BF_REPORT_DELTA_MCS_DO_NOTHING_HIGH;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssCpuRaFillerLow	= PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_INFORM_LMAC_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssCpuRaFillerHigh	= PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_INFORM_LMAC_HIGH;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssDoNothingLow	= PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_DO_NOTHING_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssDoNothingHigh	= PRE_AGGREGATOR_BF_REPORT_DELTA_NSS_DO_NOTHING_HIGH;
	RegAccess_Write(REG_PRE_AGG_BF_RPT_ANALYZER_DELTA_MCS_NSS,bfRptAnalyzerDeltaMcsNss.val);
	
	/*Aggregation BF Report Analyzer  SNR TH*/
	RegAccess_Write(REG_PRE_AGG_BF_RPT_ANALYZER_SNR_THRESHOLD_MCS0TO3,PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_0_TO_3);
	RegAccess_Write(REG_PRE_AGG_BF_RPT_ANALYZER_SNR_THRESHOLD_MCS4TO7,PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_4_TO_7);
	RegAccess_Write(REG_PRE_AGG_BF_RPT_ANALYZER_SNR_THRESHOLD_MCS8TO9,PRE_AGGREGATOR_BF_REPORT_SNR_TH_MCS_8_TO_9 << 0x1);	

	/*Configure which PD types use Data TCRs DB and which 80211 TCRs DB */
	preAggRdDbTcrsData80211PdType.bitFields.rdDbTcrsData80211PdType = ((0x1 << PD_TYPE_DATA) | (0x1 << PD_TYPE_DATA_WPA_PT) | (0x1 << PD_TYPE_MU_TRAINING));
	RegAccess_Write(REG_PRE_AGG_RD_DB_TCRS_DATA_802_11_PD_TYPE, preAggRdDbTcrsData80211PdType.val);	

#if defined(ENET_INC_LMAC0) 	
	/*update tcr base address for the first & 2nd set of TCRs*/
	tcrBaseAddr1.bitFields.tcrBaseAddr1 = (uint32)(&TxPreAggregatorGeneratedTcrsDataStructure1); //only first 22 bits are relevant
	RegAccess_Write(REG_PRE_AGG_TCR_BASE_ADDR1, tcrBaseAddr1.val);

	tcrBaseAddr2.bitFields.tcrBaseAddr2 = (uint32)(&TxPreAggregatorGeneratedTcrsDataStructure2); //only first 22 bits are relevant
	RegAccess_Write(REG_PRE_AGG_TCR_BASE_ADDR2, tcrBaseAddr2.val);

	/*update tcr base address for the first set of TCRs*/
	rcrBaseAddr.bitFields.rcrBaseAddr = (uint32)(&TxPreAggregatorGeneratedRcrsDataStructure); //only first 22 bits are relevant
	RegAccess_Write(REG_PRE_AGG_RCR_BASE_ADDR, rcrBaseAddr.val);
#elif defined (ENET_INC_LMAC1) 
	/*update tcr base address for the first & 2nd set of TCRs*/
	tcrBaseAddr1.bitFields.tcrBaseAddr1 = (uint32)(&TxPreAggregatorGeneratedTcrsDataStructure1_B1); //only first 22 bits are relevant
	RegAccess_Write(REG_PRE_AGG_TCR_BASE_ADDR1, tcrBaseAddr1.val);
	
	tcrBaseAddr2.bitFields.tcrBaseAddr2 = (uint32)(&TxPreAggregatorGeneratedTcrsDataStructure2_B1); //only first 22 bits are relevant
	RegAccess_Write(REG_PRE_AGG_TCR_BASE_ADDR2, tcrBaseAddr2.val);
	
	/*update tcr base address for the first set of TCRs*/
	rcrBaseAddr.bitFields.rcrBaseAddr = (uint32)(&TxPreAggregatorGeneratedRcrsDataStructure_B1); //only first 22 bits are relevant
	RegAccess_Write(REG_PRE_AGG_RCR_BASE_ADDR, rcrBaseAddr.val);
#endif	

	/*Set preamble override enable, configure to replace non valid rate rate 000 (short preamble 1M with long preamble 1M)*/
	PreAggregator_Set11BPreambleOverride(ENABLED, PRE_AGGREGATOR_11B_1M_MCS_INDEX);

	/*Enable PreAgg*/
	preAggEnableReg.bitFields.preAggEnable = 0x1;
	preAggEnableReg.bitFields.preAggMuEnable = 0x1;

	/*Initialize the Plans Indexes to Plans pointers register */
	planIndexToPointerLutBaseAddr.bitFields.planIndexToPointerLutBaseAddr = (uint32)(&heMuPlanLUT);
	RegAccess_Write(REG_PRE_AGG_PLAN_INDEX_TO_POINTER_LUT_BASE_ADDR, planIndexToPointerLutBaseAddr.val);
	
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_ENABLE, preAggEnableReg.val);

	barWinSizeConfig.bitFields.dontCalcBarWinSize = 0;
	RegAccess_Write(REG_PRE_AGG_BAR_WIN_SIZE_CONFIG, barWinSizeConfig.val);

	/*set DMA ratio - this value will influence in side of AGG built by Pre Agg and OTFA, which should correspond our DMA rate*/

	
	convertedDmaTotalTp = ConfigurationManager_GetTotalDmaTp()/PRE_AGG_DMA_TOTAL_TP_UNIT_SIZE;

	if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND)
	{
		// In dual band mode - each channel of DMA should get only half of the BW.
		convertedDmaTotalTp = convertedDmaTotalTp / 2;
	}

	phyDmaRatio.bitFields.invPhyDmaRatioSu = (0x1 << PRE_AGG_INVERSE_DMA_RATE_SHIFT) / convertedDmaTotalTp;
	RegAccess_Write(REG_PRE_AGG_INV_PHY_DMA_RATIO_SU, phyDmaRatio.val);

	/*In MU configuration, the calculation is same as in SU but need to multiply by num of users*/
	phyDmaRatioMuMimo2Users.bitFields.invPhyDmaRatioMuMimo2Users = 2 * ((0x1 << PRE_AGG_INVERSE_DMA_RATE_SHIFT) / convertedDmaTotalTp);
	RegAccess_Write(REG_PRE_AGG_INV_PHY_DMA_RATIO_MU_MIMO_2USERS, phyDmaRatioMuMimo2Users.val);

	phyDmaRatioMuMimo3Users.bitFields.invPhyDmaRatioMuMimo3Users = 3 * ((0x1 << PRE_AGG_INVERSE_DMA_RATE_SHIFT) / convertedDmaTotalTp);
	RegAccess_Write(REG_PRE_AGG_INV_PHY_DMA_RATIO_MU_MIMO_3USERS, phyDmaRatioMuMimo3Users.val);

	phyDmaRatioMuMimo4Users.bitFields.invPhyDmaRatioMuMimo4Users = 4 * ((0x1 << PRE_AGG_INVERSE_DMA_RATE_SHIFT) / convertedDmaTotalTp);
	RegAccess_Write(REG_PRE_AGG_INV_PHY_DMA_RATIO_MU_MIMO_4USERS, phyDmaRatioMuMimo4Users.val);

#ifdef PRE_AGG_HE_MU_REGS_CONFIG_FIX
	// fix incorrect default values in these pre-agg registers - details in https://jira-chd.intel.com/browse/WLANVLSIIP-2931
	heMuDlUlDataPhaseDbConfig.bitFields.dlDataPhasePerUser4BOffset 		=	0x1B; 
	heMuDlUlDataPhaseDbConfig.bitFields.dlDataPhasePerUserEntry4BSize 	=	0x6; 
	heMuDlUlDataPhaseDbConfig.bitFields.ulDataPhasePerUser4BOffset 		=	0x1D; 
	heMuDlUlDataPhaseDbConfig.bitFields.ulDataPhasePerUserEntry4BSize 	=	0x6; 
	RegAccess_Write(REG_PRE_AGG_HE_MU_DL_UL_DATA_PHASE_DB_CONFIG, heMuDlUlDataPhaseDbConfig.val);

	heMuProtectionSoundingPhaseDbConfig.bitFields.protectionPhasePerUser4BOffset		= 0x13;
	heMuProtectionSoundingPhaseDbConfig.bitFields.soundingPhasePerUserEntry4BSize		= 0x3;
	heMuProtectionSoundingPhaseDbConfig.bitFields.soundingPhasePerUser4BOffset			= 0x1D; 
	heMuProtectionSoundingPhaseDbConfig.bitFields.protectionPhasePerUserEntry4BSize		= 0x2; 
	RegAccess_Write(REG_PRE_AGG_HE_MU_PROTECTION_SOUNDING_PHASE_DB_CONFIG, heMuProtectionSoundingPhaseDbConfig.val);
#endif //PRE_AGG_HE_MU_REGS_CONFIG_FIX 

	RegAccess_Read(REG_PRE_AGG_PSDU_BYTE_LEN_CALC_PARAMS, &psduByteLenCalcParams.val);
	// this field is changed to contain units of 64 bytes. so for value of 0x20 - the actual number of bytes for management TID is 0x20 x 64 = 2048 bytes
#ifdef ENET_INC_ARCH_WAVE600B
    psduByteLenCalcParams.bitFields.management64BCounterCfg = 0x20;
#else
	psduByteLenCalcParams.bitFields.managementByteCounterCfg = 0x20;
#endif
#ifdef PRE_AGG_HE_MU_REGS_CONFIG_FIX
	psduByteLenCalcParams.bitFields.extraBytesForMpduHdrCfg = 0x84;
#endif //PRE_AGG_HE_MU_REGS_CONFIG_FIX
	RegAccess_Write(REG_PRE_AGG_PSDU_BYTE_LEN_CALC_PARAMS, psduByteLenCalcParams.val);

	/* init pre aggregator fifos based addresses*/
#if defined(ENET_INC_LMAC0) 

	preAggCommonFifoRegister.bitFields.preAggCmnRptFifoBaseAddr = 	CONVERT_PHYSICAL_TO_SHRAM_OFFSET(&TxPreAggregatorCommonFifo[0]);
	preAggUserFifoRegister.bitFields.preAggUsrRptFifoBaseAddr = 	CONVERT_PHYSICAL_TO_SHRAM_OFFSET(&TxPreAggregatorUserFifo[0]);
		
#endif
	
#if defined(ENET_INC_LMAC1) 

	preAggCommonFifoRegister.bitFields.preAggCmnRptFifoBaseAddr = 	CONVERT_PHYSICAL_TO_SHRAM_OFFSET(&TxPreAggregatorCommonFifoB1[0]);
	preAggUserFifoRegister.bitFields.preAggUsrRptFifoBaseAddr = 	CONVERT_PHYSICAL_TO_SHRAM_OFFSET(&TxPreAggregatorUserFifoB1[0]);
		
#endif

	RegAccess_Write(REG_PRE_AGG_PRE_AGG_CMN_RPT_FIFO_BASE_ADDR, preAggCommonFifoRegister.val);
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_USR_RPT_FIFO_BASE_ADDR, preAggUserFifoRegister.val);

	preAggCommonFifoDepth.bitFields.preAggCmnRptFifoDepthMinusOne = (PRE_AGG_COMMON_FIFO_SIZE - 1);
	preAggUserFifoDepth.bitFields.preAggUsrRptFifoDepthMinusOne = (PRE_AGG_USER_FIFO_SIZE - 1);
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_CMN_RPT_FIFO_DEPTH_MINUS_ONE, preAggCommonFifoDepth.val);
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_USR_RPT_FIFO_DEPTH_MINUS_ONE, preAggUserFifoDepth.val);

#ifdef PRE_AGG_REPORT_FIFO_WORKAROUND
	// Currently this interrupt not enabled - because of HW bug in A0. When this fifo is empty the interrupt will still be received
	// and handled
	preAggReportEnableRegister.bitFields.preAggRptFifoEn = 0x0;
	preAggReportEnableRegister.bitFields.preAggCmnRptFifoNotEmptyEn = 0x0;
	preAggReportEnableRegister.bitFields.preAggUsrRptFifoNotEmptyEn = 0x0;
#else
	preAggReportEnableRegister.bitFields.preAggRptFifoEn = 0x1;
	preAggReportEnableRegister.bitFields.preAggCmnRptFifoNotEmptyEn = 0x0;
	preAggReportEnableRegister.bitFields.preAggUsrRptFifoNotEmptyEn = 0x1;
#endif //PRE_AGG_REPORT_FIFO_WORKAROUND
	RegAccess_Write(REG_PRE_AGG_PRE_AGG_RPT_FIFO_EN, preAggReportEnableRegister.val);


#ifdef TRIGGER_FRAME_GENERATOR_RU_ALLOCATION_WORKAROUND
	//Set the TF generator register with Mask of the 7 upper bits (LSB is set by FW according to primary/secondary channel)
	tfGeneratorTfGenRuAllocationParams.val = 0x0; 
	tfGeneratorTfGenRuAllocationParams.bitFields.ruAllocationMask = 0x7f;
	tfGeneratorTfGenRuAllocationParams.bitFields.ruAllocationOffset = 0xd;
	RegAccess_Write(REG_TF_GENERATOR_TF_GEN_RU_ALLOCATION_PARAMS, tfGeneratorTfGenRuAllocationParams.val);
#endif //TRIGGER_FRAME_GENERATOR_RU_ALLOCATION_WORKAROUND
#ifdef ENET_INC_ARCH_WAVE600B
	// Management AC mapping For ETSI. Need to be configured the same as configured in Tx Selector (TxSelector_SelectModeConfig)
	primaryAcMngMap.bitFields.primaryAcMngMap = ACCESS_CATEGORY_BE;
	RegAccess_Write(REG_PRE_AGG_PRIMARY_AC_MNG_MAP, primaryAcMngMap.val);

	// Enable 20MHz Occupancy (Keep User)
	heMuKeepUser.bitFields.heMuKeepUserCfg = TRUE;
#ifdef ENET_INC_ARCH_WAVE600D2
	heMuKeepUser.bitFields.heMuUpdateDlMimoBaCfg = TRUE;	
	heMuKeepUser.bitFields.heMuUpdateUlMimoTfBaCfg = TRUE;	
#else
	heMuKeepUser.bitFields.heMuKeepUserUpdateMimoBaCfg = TRUE;	
#endif
	RegAccess_Write(REG_PRE_AGG_HE_MU_KEEP_USER_CFG, heMuKeepUser.val);

    // Enable TF generator interrupts
    regTfGenIntErrorEn.bitFields.tfrgGoWhileActiveMismatchEn 		= TRUE;
    regTfGenIntErrorEn.bitFields.tfrgTfModeMismatchEn 				= TRUE;
    regTfGenIntErrorEn.bitFields.tfrgEmptyTidMismatchEn 			= TRUE;
    regTfGenIntErrorEn.bitFields.tfrgRuIndexLutOorEn 				= TRUE;
#ifdef ENET_INC_ARCH_WAVE600D2	
	regTfGenIntErrorEn.bitFields.tfrgStartingSpatialStreamThrOvfEn 	= TRUE;
#endif
    RegAccess_Write(REG_TF_GENERATOR_TF_GEN_INT_ERROR_EN, regTfGenIntErrorEn.val);
#endif

#ifdef WORKAROUND_FOR_HW_BUG_IN_PRE_AGG
	// Set correct default values
	regPreAggTomiMuDisableCfg.val = 0x0;
	regPreAggTomiMuDisableCfg.bitFields.tomiDlHeMuImmedaiteCfg = TOMI_DL_HE_MU_IMMEDAITE_CFG_DEFAULT_VAL;
	regPreAggTomiMuDisableCfg.bitFields.tomiDlHeMuVhtAlikeCfg = TOMI_DL_HE_MU_VHT_ALIKE_CFG_DEFAULT_VAL;
	regPreAggTomiMuDisableCfg.bitFields.tomiDlHeMuMuBarCfg = TOMI_DL_HE_MU_MU_BAR_CFG_DEFAULT_VAL;
	regPreAggTomiMuDisableCfg.bitFields.tomiUlHeMuCfg = TOMI_UL_HE_MU_CFG_DEFAULT_VAL;
	RegAccess_Write(REG_PRE_AGG_TOMI_MU_DISABLE_CFG, regPreAggTomiMuDisableCfg.val);
#endif
#ifdef ENET_INC_ARCH_WAVE600B
	RegAccess_Read(REG_PRE_AGG_TOMI_MU_DISABLE_CFG, &regPreAggTomiMuDisableCfg.val);
	regPreAggTomiMuDisableCfg.bitFields.tomiUlHeMuDataCfg = TOMI_UL_HE_MU_CFG_DEFAULT_VAL; 
	RegAccess_Write(REG_PRE_AGG_TOMI_MU_DISABLE_CFG, regPreAggTomiMuDisableCfg.val);
#endif

	//for A0 & B0 need to set UL BA MCS BW Reduction Compensation to 0
	//The register will be removed in dash 2.
#ifndef ENET_INC_ARCH_WAVE600D2	
	regPreAggHeMoMimoConfig.bitFields.baNcsBwReducCompensation = 0x0;
	RegAccess_Write(REG_PRE_AGG_HE_MO_MIMO_CONFIG, regPreAggHeMoMimoConfig.val);
#endif	
}

void PreAggregator_SetDurationRatioThreshold (uint8 newThreshold)
{
	uint32 wordFormatThreshold = 0; 

	ASSERT(newThreshold < (PRE_AGGREGATOR_MAX_DURATION_THRESHOLD_CONFIGURATION+1)); 
	/* the threshold should be concatenated in 5 bits at resolution of 32 bits
		We can achive this format by multiply the value with DURATION_THRESHOLD_WORD_FORMAT_FACTOR (0x8421)*/
	wordFormatThreshold = newThreshold*DURATION_THRESHOLD_WORD_FORMAT_FACTOR;  
	memset32(PreAggRtsMem,wordFormatThreshold,((sizeof(PreAggRtsMem_t) - (sizeof(PreAggRtsMemPerBw_2_t)*NUM_OF_BW_VALUES))>>2));
}

void PreAggregator_Halt(void)
{
	RegPreAggPreAggEnable_u preAggEnableReg;

	preAggEnableReg.val = 0;

	preAggEnableReg.bitFields.preAggEnable = 0;
	preAggEnableReg.bitFields.preAggMuEnable = 0;

	RegAccess_Write(REG_PRE_AGG_PRE_AGG_ENABLE	,preAggEnableReg.val);
}

void PreAggregator_SetMuBfTrainingBwLimit(Bandwidth_e newLimit)
{
	RegPreAggMuMultUsrsTrainingControl_u muBfTrainingCtrlReg; 
	
	ASSERT(newLimit < BANDWIDTH_EIGHTY_EIGHTY); // only two bits in the register 

	RegAccess_Read(REG_PRE_AGG_MU_MULT_USRS_TRAINING_CONTROL, &(muBfTrainingCtrlReg.val));
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingBwLimit= newLimit;
	RegAccess_Write(REG_PRE_AGG_MU_MULT_USRS_TRAINING_CONTROL, muBfTrainingCtrlReg.val);
}
#endif // defined(ENET_INC_LMAC0) || defined(ENET_INC_LMAC1) 


#if defined(ENET_INC_UMAC)
#ifdef ENET_INC_ARCH_WAVE600B
void PreAggregator_SetHeMuKeepUser(bool heMuKeepUserCfg)
{
	RegPreAggHeMuKeepUserCfg_u heMuKeepUser;
	uint8	                   bandId;
	
	for (bandId = CONFIGURATION_MANAGER_BAND_0; bandId < ConfigurationManager_GetNumOfActiveBands(); bandId++)
	{	
		RegAccess_ReadPerBand(REG_PRE_AGG_HE_MU_KEEP_USER_CFG, &(heMuKeepUser.val), bandId);
		heMuKeepUser.bitFields.heMuKeepUserCfg = heMuKeepUserCfg; // Enable/Disable 20MHz Occupancy (Keep User)
		RegAccess_WritePerBand(REG_PRE_AGG_HE_MU_KEEP_USER_CFG, heMuKeepUser.val, bandId);
	}
}
#endif // ENET_INC_ARCH_WAVE600B
#endif // defined(ENET_INC_UMAC)



