/***********************************************************************************
 File:			ProcessManager_Api.h
 Module:		Process manager
 Purpose: 		Coordinate and schedule all processes in the system
 Description:	This header is the API to the process manager module 
				which is responsible for scheduling and prioritizing all processes 
				in the system.It is also the sole owner of all services related to 
				these processes.
************************************************************************************/
#ifndef PROCESS_MANAGER_CDB_API_H_
#define PROCESS_MANAGER_CDB_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
#ifdef ENET_INC_ARCH_WAVE600
void ProcessManagerCdbInit(void);
#endif
extern void ProcessManagerCdb_TaskEntry(K_MSG *processManagerMsg);

#endif //PROCESS_MANAGER_CDB_API_H_
