/***********************************************************************************
 File:			ProcessManager_Api.h
 Module:		Process manager
 Purpose: 		Coordinate and schedule all processes in the system
 Description:	This header is the API to the process manager module 
				which is responsible for scheduling and prioritizing all processes 
				in the system.It is also the sole owner of all services related to 
				these processes.
************************************************************************************/
#ifndef PROCESS_MANAGER_API_H_
#define PROCESS_MANAGER_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum
{
	//PROCESS_ID_NULL,
	PROCESS_ID_ADD_VAP,
	PROCESS_ID_REMOVE_VAP,
	PROCESS_ID_SET_BSS,
	PROCESS_ID_SET_WMM_PARAMS,
	PROCESS_ID_ONLINE_CALIBRATION,
	PROCESS_ID_CHANNEL_SWITCH,
	PROCESS_ID_CALIBRATE,
	PROCESS_ID_HDK_USER_DEMAND,
	PROCESS_ID_HDK_OTHER_CORE_CALIBRATING,
	PROCESS_ID_HDK_SET_ANT_CONFIGURATION,	
	/***************************************/
	/* TBD - Should be removed as part of new init sequence*/
	PROCESS_ID_ACTIVATE,
	/*************************************/
	PROCESS_ID_COC,
	PROCESS_ID_DUT,
	PROCESS_ID_CHANGE_RADIO_STATE,
	PROCESS_ID_ERP,
	PROCESS_ID_DUTY_CYCLE,
#ifdef PTA_BUILD_IN_PLAT
	PROCESS_ID_PTA,
#endif	
	NUM_OF_PROCESSES,
	PROCESS_ID_INVALID = 0xFF,
	MAX_NUM_OF_PROCESSES = 0xFF,
} ProcessId_e;

typedef enum
{
	PROCESS_STATUS_REQUEST_ACCEPTED,	
	PROCESS_STATUS_REQUEST_REJECTED,
	PROCESS_STATUS_EXECUTION_COMPLETED,
	PROCESS_STATUS_EXECUTION_ABORTED,
	PROCESS_NUM_OF_STATUS,
	PROCESS_MAX_NUM_OF_STATUS = 0xFF,
} ProcessStatus_e;

/*Service data is used to pass additional data for running services, one byte per-service*/
#define PAUSE_ACVAP_SUBTYPE_MASK_SHIFT		(0)
#define PAUSE_ACVAP_SUBTYPE_MASK			(0xFF)
#define CTS2SELF_DURATION_MASK_SHIFT		(8)
#define CTS2SELF_DURATION_MASK				(0xFF00)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct ProcessRequestParams_
{
	void *requesterParams;	
	uint32 preProcessServiceBitmap;
	uint32 postProcessServiceBitmap;
	uint32 serviceData;	/*Each service can add a some specific data, one byte per service*/
	K_MSG_TYPE startProcessMsg;/* Msg Id of  Process Handler*/
	K_MSG_TYPE endProcessMsg;  /* Msg Id of  Process  Finalize Handler*/	
	K_TASKID returnTask;
	uint8 processId;
	bool updateParamsBeforeFinalizing;
	bool dualBandProcess;
	bool processMsgHandledByCdbProcessMan;
	uint8 vapId;
} ProcessRequestParams_t;

typedef struct processmanger
{
	void *requesterParams;
	ProcessStatus_e processStatus;
} ProcessManagerReturnParams_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void ProcessManager_TaskEntry(K_MSG *processManagerMsg);
void ProcessManager_Init(void);
K_MSG *ProcessManager_GetDummyMessage(void);

#endif //PROCESS_MANAGER_API_H_
