/***************************************************************
 File:		PsManager_Api.h
 Module:	  	Ps Manager  interface
 Purpose: 	interfaceof the PS Manager
 Description:  	This file is the API to the PS Manager module  
***************************************************************/
#ifndef PS_MANAGER_API_H_
#define PS_MANAGER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#if !defined (ENET_INC_ARCH_WAVE600)
#include "PacketDescriptor.h"
#endif  //!ENET_INC_ARCH_WAVE600
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct PsManagerFifoParams_s
{
	uint16 currentIndexInFifo;
	uint16 numOfValidEntries;
} PsManagerFifoParams_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
#if !defined (ENET_INC_ARCH_WAVE600)
void PsManager_TransmitNdpCfm(TxPd_t* pPacketDesc);
#endif
void PsManager_GetFifoParameters(PsManagerFifoParams_t *fifoParams);
void PsManager_SetFifoParameters(PsManagerFifoParams_t *fifoParams);
void PsManager_PsSettingsFifoNotEmpty(void);
void PsManager_Init(void);

#endif /* PS_MANAGER_API_H_ */


