/***********************************************************************************
 File:			Qos_Api.h
 Module:		Qos 
 Purpose: 		To handle discarded packets by the Ager and releasing PDs when number
                of free PDs is low
 Description:   This file is the API of the Qos module which is responsible 
 				to handle discarded packets by the Ager and releasing PDs when number
                of free PDs is low
************************************************************************************/
#ifndef QOS_API_H_
#define QOS_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "HwQManager_API.h"
#include "protocol.h"

/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/
#define QOS_MAXIMUM_NUMBER_OF_PD_LIMIT_VALUES 8

/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/


typedef struct QosSingleCheckMessageParameters_s
{
	uint16 pdLimitValues[QOS_MAXIMUM_NUMBER_OF_PD_LIMIT_VALUES];
	uint8 startingTtl;
	uint8 numberOfPdsLimits;
	uint16 freePdsHysteresisNumber;
} QosSingleCheckMessageParameters_t;

typedef struct QosPeriodicCheckMessageParameters_s
{
	uint8 acTtlCriteria[ACCESS_CATEGORY_NUM];
	uint16 minimumPdsToStartCheckForAc[ACCESS_CATEGORY_NUM];
	uint8 agerPeriod;
	uint8 reserved[3];
} QosPeriodicCheckMessageParameters_t;

/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
extern void Qos_TaskEntry(K_MSG *QosMessage);
void Qos_Initialize(void);
void QosSetAgerParams(uint32 data1,  uint32 data2, uint32 data3);

#endif /* QOS_API_H_ */

