/***********************************************************************************
 File:			Qos.h
 Module:		Qos 
 Purpose: 		To handle discarded packets by the Ager and releasing PDs when number
                of free PDs is low
 Description:	This file contains all the definitions and structures of the Qos 
 				module which is responsible to handle discarded packets by the Ager 
 				and releasing PDs when number of free PDs is low
************************************************************************************/
#ifndef QOS_H_
#define QOS_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "mhi_umi.h"
#include "shram.h"
#include "ConfigurationManager_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define QOS_NUMBER_OF_QOS_AGING_UNITS 32
#define QOS_DELAY_BETWEEN_AGER_LIST_FLUSH 2
#define QOS_SINGLE_CHECK_TIMER_IN_MILISECONDS 10
#define QOS_UNLOCK_CHECK_TIMER_IN_MILISECONDS 10
#define QOS_DECREASE_TTL_CRITERIA_SHIFT 1
#define QOS_TTL_UNITS_TO_QOS_AGING_UNITS_SHIFT 2 /* The QoS againg uints are 0-31: divide TTL uints by 4 */
#define QOS_AGING_UNITS_BITMAP_SET 1
#define QOS_MAXIMUM_AGING_UNIT_DEFAULT_VALUE -1
#define QOS_ADD_TO_GET_HIGHEST_VALUE_IN_CELL 3
#define QOS_MINIMUM_NUMBER_OF_STATIONS_AND_VAPS_FOR_FORCE_LOCK 8
#define QOS_FORCE_LOCK_CRITERIA_SHIFT 1
#define QOS_UNLOCK_QUEUE_SAFETY_TIME_GAP_IN_MICROSECONDS 10000
#define QOS_INVALID_STATION_INDEX 0xFF
#define QOS_INVALID_TID_INDEX 0xFF
#define QOS_MAXIMUM_AGING_INTERVAL_VALUE (HOST_INTERFACE_ACCELERATOR_CONVERT_TTL_UNITS_TO_TIME_UNITS((QOS_NUMBER_OF_QOS_AGING_UNITS - 1) << QOS_TTL_UNITS_TO_QOS_AGING_UNITS_SHIFT))

//TBD these parameters are valid till the new FW confiugration will be implemented 
#define QOS_DEFAULT_NUMBER_OF_PD_LIMITS 4
#define QOS_DEFAULT_FREE_PDS_HYSTERESIS (NUM_OF_TX_DESC >> 3) 
#define QOS_DEFAULT_STARTING_TTL_SHIFT 1 

//
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct QosPeriodicCheckParameters_s
{
#ifdef ENET_INC_ARCH_WAVE600
	uint32 	qosAgingUnitsBitmap;
	uint16	beaconIntervals[HW_NUM_OF_VAPS];
	uint8 	qosAgingUnitsCounters[QOS_NUMBER_OF_QOS_AGING_UNITS];
#else
	uint32 	qosAgingUnitsBitmap;
	uint16 	beaconIntervals[HW_NUM_OF_VAPS];	
	uint8 	qosAgingUnitsValues[HW_NUM_OF_STATIONS + HW_NUM_OF_VAPS];
	uint8 	qosAgingUnitsCounters[QOS_NUMBER_OF_QOS_AGING_UNITS];

	int8  maximumQosAgingUnit;
	uint8 reserved[3];
#endif
} QosPeriodicCheckParameters_t;
typedef struct QoSPdThresholdConfig_s
{
 	uint16				 minPdDiff;		/*Minimum allowed Difference between Minimum and maximum PDs on queues with same AC in Dynamic Mode*/
	QoSPdThresholdMode_e mode;
	uint8				 minPdAmount;	/*Minimum Amount of PDs on a queues needed so a queue is taken into considerartion in Dynamic Mode*/
	uint8				 getSetOperation;
	uint8				 reserved[3];
} QoSPdThresholdConfig_t;

typedef struct QosSingleCheckParameters_s
{
	uint16 pdLimitValues[QOS_MAXIMUM_NUMBER_OF_PD_LIMIT_VALUES];

	uint16 freePdsHysteresisNumber;	
	uint8 startingTtl;
	uint8 currentTtl;

	uint32 numberOfLockFailures;
	uint32 numberOfPdsHandledToLiberator;
	uint32 numberOfPdsHandledToUmac;
	
	uint8 currentPdLimitIndex;
	uint8 currentAc;	
	uint8 numberOfPdsLimits;
	uint8 reserved;
} QosSingleCheckParameters_t;

typedef struct QosGeneralParameters_s
{
	uint16 numberOfValidVapsAndStations;
	uint8 isDuringSingleCheck;
	uint8 isPeriodicCheckActive;
#ifdef ENET_INC_ARCH_WAVE600
	uint8 isAtfStaticDistType[NUM_OF_CONFIGURATION_MANAGER_BANDS];    
#else
	uint8 isAtfStaticDistType;	  
#endif
	uint8 staManagerStopTrafficId;
	uint8 isAgerEnabled;
	uint8 restrictedAc;
	uint8 restrictedAcBitmap;	
} QosGeneralParameters_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------


#endif /* QOS_H_ */

