/***************************************************************
 File:			RegAccess_Api.h
 Module:		Register Acess
 Purpose:		Access to Hw Registers
 Description:	This module is the API for accessing registers in the HW 
***************************************************************/
#ifndef REGITER_ACCESS_API_H_
#define REGITER_ACCESS_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
//#define PSD_DEBUG 1

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define REG_INDEX_TO_REG_OFFSET(regIndex) (regIndex << 2); /* */
/**/
#define MT_RdReg(unit, reg) 					(RegAccess_ReadImmediate(unit | reg))
#define MT_WrReg(unit, reg, data )				(RegAccess_Write(unit | reg, data ))
#define MT_WrRegMask(unit, req, mask, data )	(RegAccess_WriteMasked(unit | req, mask, data))
#define MT_WrRegSecur(unit, reg, data ) 		(RegAccess_WriteSecured(unit | reg, data))
#define REGISTER(address) 						*((volatile uint32*)(address))

/********* Antenna bit mask manipulations *********/
#define ANTENNA_BIT(antNum)							(1<<(antNum))						// Antenna bit
#define ANTENNA_MASK_IS_BIT_ON(antMask,antNum)		((antMask) & ANTENNA_BIT(antNum))	// Is antenna bit on in antenna mask


/******************************************************************************/
/***                       		    Debug                                   ***/
/******************************************************************************/
#ifdef PSD_DEBUG

#define DEBUG_MAX_ANTENNA 4
#define DEBUG_TABLE_NUM_OF_ROWS 30

typedef struct RegDebug
{
	uint32 regAddress[DEBUG_TABLE_NUM_OF_ROWS];
	uint32 newdata	 [DEBUG_TABLE_NUM_OF_ROWS];
	uint32 prevdata	 [DEBUG_TABLE_NUM_OF_ROWS];
}RegDebug;

extern RegDebug PhyRegAntDebug[DEBUG_MAX_ANTENNA];
extern uint32 	CurrentRowIndex;

#endif

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void RegAccess_Read(uint32 regAddress, volatile uint32 *regValue);
uint32 RegAccess_ReadImmediate(uint32 regAddress);
void RegAccess_Write(uint32 regAddress, uint32 regValue);
void RegAccess_WriteMasked(uint32 regAddress, uint32 mask, uint32 data);
void RegAccess_WriteSecured(uint32 regAddress,uint32 data);
#if defined (ENET_INC_ARCH_WAVE600)
// Per band APIs
void RegAccess_ReadPerBand(uint32 regAddress, volatile uint32 *regValue, uint32 band);
uint32 RegAccess_ReadImmediatePerBand(uint32 regAddress, uint32 band);
void RegAccess_WritePerBand(uint32 regAddress, uint32 regValue, uint32 band);
void RegAccess_WriteMaskedPerBand(uint32 regAddress, uint32 mask, uint32 data, uint32 band);
void RegAccess_WritePerAntMaskMasked(uint32 regAddress, uint32 mask, uint32 antmask, uint32 data);
void RegAccess_WaitForFieldPerBand(uint32 regAddress, uint8 shift, uint32 mask, uint32 expectedValue, uint32 timeout, bool* pSuccess, uint8 bandId);
void RegAccess_ReadAndVerifyFieldPerBand(uint32 regAddress, uint8 shift, uint32 mask, uint32 value, bool* pSuccess, uint8 bandId);
void RegAccess_ReadFieldPerBand(uint32 regAddress, uint8 shift, uint32 mask, uint32* pFieldValue, uint8 bandId);
#endif
void RegAccess_Write64bitReg(uint32 regAddress, uint32* regValue);
void RegAccess_ReadField(uint32 regAddress, uint8 shift, uint32 mask, uint32* fieldValue);
void RegAccess_ReadAndVerify(uint32 regAddress, uint32 value, bool* success);
void RegAccess_ReadAndVerifyField(uint32 regAddress, uint8 shift, uint32 mask, uint32 value, bool* success);
void RegAccess_WriteInc4(uint32* regAddress, uint32 value);
void RegAccess_WaitForField(uint32 regAddress, uint8 shift, uint32 mask, uint32 expectedValue, uint32 timeout, bool* success);



#endif //REGITER_ACCESS_API_H_
