/* ResourceManager_API.h*/

#ifndef  _RESOURCE_MANAGER_API_
#define  _RESOURCE_MANAGER_API_
	

#include "PacketDescriptor.h"
#include "System_GlobalDefinitions.h"
#include "frame.h"
#include "OSAL_Kmsg.h"

/* The payload must be word alligend */

#define TS_PACKET_SIZE_ALLINGED_TO_WORDS CONVERT_WORDS_TO_BYTES(CEILING(sizeof(TsManPayload_t) + sizeof(MANAGEMENT_BASIC_FRAME_HEADER) + HT_CONTROL_SIZE,sizeof(uint32)))  

#define MANAGEMENT_PACKET_PAYLOAD_SIZE   	512
#define MANAGEMENT_PACKET_SIZE              MANAGEMENT_PACKET_PAYLOAD_SIZE + sizeof(MANAGEMENT_BASIC_FRAME_HEADER) + HT_CONTROL_SIZE
#define CSA_PACKET_SIZE                     sizeof(FM_PAYLOAD_CSA) + sizeof(MANAGEMENT_BASIC_FRAME_HEADER) + HT_CONTROL_SIZE
#define NDPA_PACKET_PAYLOAD_SIZE		 	128
#define INVALID_FREE_PENDING_LIST_ID (MAX_UINT16)

typedef enum DescPoolTypes
{
	DESC_POOL_DATA,
	DESC_POOL_RELIABLE_MCAST,
	DESC_POOL_TS_MANAGER ,
	DESC_POOL_MANAGEMENT_FROM_FW,
	DESC_POOL_MANAGEMENT_FROM_HOST,
	DESC_POOL_CSA_MANAGER,
	DESC_POOL_PS_SETTINGS_NDP,
	DESC_POOL_MC_DEAUTH,			/* This pool holds the PDs for the multicast deauthentication frames sent during CSA (see WLANRTSYS-12518) */
	NUM_OF_DESC_POOLS,
	MAX_DESC_POOLS = MAX_UINT8
}DescPoolTypes_e;

typedef union TsPacketsPayload
{
	FM_PAYLOAD_ADDBA_REQ AddBaReqResource;
	FM_PAYLOAD_ADDBA_RES AddBaResResource;
	FM_PAYLOAD_DELBA	 DelbaResource;
}TsPacketsPayload_u;


typedef struct TsManPayload
{
	TsPacketsPayload_u            PacketPayload;
#if defined(ENET_INC_ARCH_WAVE600)
	FM_PAYLOAD_ADDBA_EXTENSION_ELEMENT AddbaExtension; // Currently we support only this IE. There can be others which we need to skip.
#endif	
}TsManPayload_t;

typedef struct ManPacketsPayload
{
	uint8 manPayload[MANAGEMENT_PACKET_PAYLOAD_SIZE];
}ManPacketsPayload_t;

typedef struct ManPacket
{
	uint8 manPacket[MANAGEMENT_PACKET_SIZE];
}ManPacket_t;


typedef struct NdpaPacketsPayload
{
	uint8 ndpaPayload[NDPA_PACKET_PAYLOAD_SIZE];
}NdpaPacketsPayload_t;

typedef struct CsaFrame
{
	uint8 csaPacket[CSA_PACKET_SIZE];
} CsaFrame_t;

typedef struct NdpaPktPayload
{
	NDPA_FRAME_HEADER       FrameHeader;
	NdpaPacketsPayload_t    PacketPayload;
}NdpaPktPayload_t;



typedef struct RmPdRequestFillParameters_tag
{
	TxPd_t 	*packetDescriptor;
	uint16           	requestId;
	uint16 				context;
	K_MSG_TYPE 			returnMsgType;
	K_TASKID 			returnTaskId;
	
}RmPdRequestFillParameters_t;

typedef struct RmPdFreeDescResponse_tag
{
	TxPd_t 	*packetDescriptor;
	uint16				context;
	
}RmPdFreeDescResponse_t;

//these functions need to be filled with content when resource manager is changed
bool ResourceManager_GetDescriptorRequest(DescPoolTypes_e poolType, RmPdRequestFillParameters_t *pdRequestFillParameters);
bool ResourceManager_RemoveRequest(uint16 requestId, DescPoolTypes_e poolType);
void ResourceManager_ReleaseRequest(uint16 requestId, DescPoolTypes_e poolType);
TxPd_t* ResourceManager_GetDescriptor(DescPoolTypes_e poolType);
void ResourceManager_ReleaseDescriptor(TxPd_t *desc_p, DescPoolTypes_e poolType);
void ResourceManager_Init(void);

#endif //_RESOURCE_MANAGER_API_










