/***********************************************************************************
 File:		RxClassifier_Api.h
 Module:		Rx Classifier
 Purpose: 	Owner for all access to the Rx Classifier
 Description:	This module is the API to the Rx Classifier responbile for frame filtering and classification 
************************************************************************************/
#ifndef RX_CLASSIFIER_API_H_
#define RX_CLASSIFIER_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "mhi_ieee_address.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/* Frame Class Violation Rams Definitions*/
#define RX_CLASSIFIER_FRAME_CLASS_VIOLATION_CACHE_SIZE			(16)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/
#if !defined (ENET_INC_ARCH_WAVE600)

typedef struct classViolationDetails
{
	IEEE_ADDR macAddress;
	uint8 valid;
	uint8 indexInCache;
	uint8 vapId;
	uint8 reserved; 
} classViolationDetails_t; 

#endif
/*---------------------------------------------------------------------------------
/						Externals					
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/

void 	RxClassifier_HandleRxManagerAddVap(UMI_ADD_VAP* addVapStructurePtr);
void 	RxClassifier_Init(void);


#if defined (ENET_INC_ARCH_WAVE600)
void 	RxClassifier_HandleAddWpaPtVap(uint8 vapId);
#endif

#if !defined (ENET_INC_ARCH_WAVE600)
void   	RxClassifier_SetStaFrameClass(uint32 staIndex,uint32 allowedFrameClass);
uint8	RxClassifier_GetStaFrameClass(uint32 staIndex);
bool 	RxClassifier_GetRssiTypeFlag(void);
void 	RxClassifier_ReadClassViolationCache(classViolationDetails_t *frameClassViolationDetails);
void 	RxClassifier_ResetClass3ViolationValidEntry(uint32 cacheIndex);
#endif // #if !defined (ENET_INC_ARCH_WAVE600)





#endif /* RX_CLASSIFIER_API_H_ */



