/***********************************************************************************
 File:		RxClassifier.h
 Module:		Rx Classifier
 Purpose: 	header file for RX Classifier.
 Description:	Rx Classifier header 
 ************************************************************************************/
#ifndef RX_CLASSIFIER_H_
#define RX_CLASSIFIER_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "ieee80211.h"
#include "Pac_Api.h"
#if !defined (ENET_INC_ARCH_WAVE600)
#include "Rtd.h"
#endif


/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/
#if defined(ENET_INC_ARCH_WAVE600)

#define RX_CLASSIFIER_FRAME_CLASS_ENTRY_MASK  					(0x3)  /* Mask of the sta frame class value */
#define RX_CLASSIFIER_FRAME_CLASS_STA_IDX_TO_REG_ADDR_SHIFT  	(4)    /* Shift value to calculate reg addr from sta index  reg Address offset = Sta Index/16*/
#define RX_CLASSIFIER_FRAME_CLASS_STA_IDX_TO_BIT_OFFSET_SHIFT	(1)	   /* Shift value to calculate bit offset in the register  bitoffset  = (Sta Index%16)* 2 */
#define RX_CLASSIFIER_FRAME_CLASS_STA_IDX_TO_BIT_OFFSET_MASK	(0xF)	

#endif

/*---------------------------------------------------------------------------------
/								enums						
/----------------------------------------------------------------------------------*/

typedef enum
{
	MANAGEMENT_SUBTYPE_ASSOCIATION_REQUEST,		// 0x0		
	MANAGEMENT_SUBTYPE_ASSOCIATION_RESPONSE,	// 0x1	
	MANAGEMENT_SUBTYPE_REASSOCIATION_REQUEST,	// 0x2		
	MANAGEMENT_SUBTYPE_REASSOCIATION_RESPONSE,	// 0x3	
	MANAGEMENT_SUBTYPE_PROBE_REQUEST,			// 0x4	
	MANAGEMENT_SUBTYPE_PROBE_RESPONSE,			// 0x5	
	MANAGEMENT_SUBTYPE_TIMING_ADVERTISEMENT,	// 0x6	
	MANAGEMENT_SUBTYPE_RESERVED1,				// 0x7
	MANAGEMENT_SUBTYPE_BEACON,					// 0x8	
	MANAGEMENT_SUBTYPE_ATIM,					// 0x9	
	MANAGEMENT_SUBTYPE_DISASSOCIATION,			// 0xA	
	MANAGEMENT_SUBTYPE_AUTHENTICATION,			// 0xB	
	MANAGEMENT_SUBTYPE_DEAUTHENTICATION,		// 0xC	
	MANAGEMENT_SUBTYPE_ACTION,					// 0xD	
	MANAGEMENT_SUBTYPE_ACTION_NO_ACK,			// 0xE	
	MANAGEMENT_SUBTYPE_RESERVED2,				// 0xF	
	MANAGEMENT_SUBTYPE_NUM_OF_SUBTYPES,			// 16	
} ManagementSubtypes_e;





/*---------------------------------------------------------------------------------
/							Data Type Definition												
/----------------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------------
/						 Function Declaration						
/----------------------------------------------------------------------------------*/

void RxClassifier_ConfigureRegularMode(void);
void RxClassifier_ConfigureNormalMode(void); 	//for NORMAL_AFTER_RSSI configuration
void RxClassifier_ConfigureRssiMode(void);		//for RSSI configuration 
void RxClassifier_ConfigureSnifferMode(void);

#endif /* RX_CLASSIFIER_H_ */
