/***********************************************************************************
 File:		RxClassifierRam.h
 Module:		Rx Classifier
 Purpose: 	Owner for all access to the Rx Classifier
 Description:	Rx Classifier Ram Description
************************************************************************************/
#ifndef RX_CLASSIFIER_RAM_H_
#define RX_CLASSIFIER_RAM_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"



/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/
#define RX_CLASSIFIER_RAM_ADDR_OFFSET 							(0x800)


#if !defined (ENET_INC_ARCH_WAVE600)

/* Rekey Ram Definitions*/
#define RX_CLASSIFIER_RAM_VAP_REKEY_ENTRY_WIDTH					(2)
#define RX_CLASSIFIER_RAM_VAP_REKEY_ENTRY_MASK 					(0x3)
#define RX_CLASSIFIER_RAM_VAP_REKEY_NUM_ROWS					(1)
#define RX_CLASSIFIER_RAM_VAP_IDX_TO_ROW_OFFSET_SHIFT			(4)
#define RX_CLASSIFIER_RAM_VAP_IDX_TO_BIT_OFFSET_SHIFT			(1)
#define RX_CLASSIFIER_RAM_VAP_IDX_TO_BIT_OFFSET_MASK			(0x3)

#define RX_CLASSIFIER_RAM_STA_REKEY_ENTRY_WIDTH					(2)
#define RX_CLASSIFIER_RAM_STA_REKEY_ENTRY_MASK 					(0x3)
#define RX_CLASSIFIER_RAM_STA_REKEY_NUM_ROWS					(8)
#define RX_CLASSIFIER_RAM_STA_IDX_TO_ROW_OFFSET_SHIFT			(4)
#define RX_CLASSIFIER_RAM_STA_IDX_TO_BIT_OFFSET_SHIFT			(1)
#define RX_CLASSIFIER_RAM_STA_IDX_TO_BIT_OFFSET_MASK			(0xF)

#endif //#if !defined (ENET_INC_ARCH_WAVE600)
/*---------------------------------------------------------------------------------
/							Data Type Definition												
/----------------------------------------------------------------------------------*/
	
#if !defined (ENET_INC_ARCH_WAVE600)

typedef union
{
	uint32 val;
	struct
	{
		uint32 vap0rekeyId:2;
		uint32 vap1rekeyId:2;
		uint32 vap2rekeyId:2;
		uint32 vap3rekeyId:2;
		uint32 vap4rekeyId:2;
		uint32 vap5rekeyId:2;
		uint32 vap6rekeyId:2;
		uint32 vap7rekeyId:2;
		uint32 vap8rekeyId:2;
		uint32 vap9rekeyId:2;
		uint32 vap10rekeyId:2;
		uint32 vap11rekeyId:2;	
		uint32 vap12rekeyId:2;
		uint32 vap13rekeyId:2;
		uint32 vap14rekeyId:2;
		uint32 vap15rekeyId:2;
	} bitFields;
} RamRxClassifierVapRekeyId_u;

typedef union
{
	uint32 val;
	struct
	{
		uint32 sta0rekeyId:2;
		uint32 sta1rekeyId:2;
		uint32 sta2rekeyId:2;
		uint32 sta3rekeyId:2;
		uint32 sta4rekeyId:2;
		uint32 sta5rekeyId:2;
		uint32 sta6rekeyId:2;
		uint32 sta7rekeyId:2;
		uint32 sta8rekeyId:2;
		uint32 sta9rekeyId:2;
		uint32 sta10rekeyId:2;
		uint32 sta11rekeyId:2;	
		uint32 sta12rekeyId:2;
		uint32 sta13rekeyId:2;
		uint32 sta14rekeyId:2;
		uint32 sta15rekeyId:2;
	} bitFields;
} RamRxClassifierStaRekeyId_u;


typedef struct RamRxClassifierFrameClassViolationCacheEntry
{
	uint32 macAddr0to4;
	uint32 macAddr5to6:16;
	uint32 violationClass:2;
	uint32 reserved1:2;
	uint32 vapIndex:4;
	uint32 reserved2:8;
} RamRxClassifierFrameClassViolationCacheEntry_t;


typedef struct RxClassifierRdTypeConfigurationEntry
{
	uint32 subType0:4;
	uint32 subType1:4;
	uint32 subType2:4;
	uint32 subType3:4;
	uint32 subType4:4;
	uint32 subType5:4;
	uint32 subType6:4;
	uint32 subType7:4;
	uint32 subType8:4;
	uint32 subType9:4;
	uint32 subType10:4;
	uint32 subType11:4;
	uint32 subType12:4;
	uint32 subType13:4;
	uint32 subType14:4;
	uint32 subType15:4;
} RxClassifierRdTypeConfigurationEntry_t;
#endif // #if !defined (ENET_INC_ARCH_WAVE600)
#if defined (ENET_INC_ARCH_WAVE600)

typedef struct RxClassifierRdTypeConfigurationEntry
{
	uint32 subType0:5;
	uint32 subType1:5;
	uint32 subType2:5;
	uint32 subType3:5;
	uint32 subType4:5;
	uint32 subType5:5;
	uint32 reserved1:2;
	uint32 subType6:5;
	uint32 subType7:5;
	uint32 subType8:5;
	uint32 subType9:5;
	uint32 subType10:5;
	uint32 subType11:5;
	uint32 reserved2:2;
	uint32 subType12:5;
	uint32 subType13:5;
	uint32 subType14:5;
	uint32 subType15:5;
	uint32 reserved3:12;
	
} RxClassifierRdTypeConfigurationEntry_t;
#endif //#if defined (ENET_INC_ARCH_WAVE600)

typedef struct RxClassifierRdTypeConfiguration
{
	RxClassifierRdTypeConfigurationEntry_t	dataUnicat;
	RxClassifierRdTypeConfigurationEntry_t	dataMulticast;
	RxClassifierRdTypeConfigurationEntry_t	managementUnicast;
	RxClassifierRdTypeConfigurationEntry_t	managementMulticast;
	RxClassifierRdTypeConfigurationEntry_t	control;
	RxClassifierRdTypeConfigurationEntry_t	managementUnicastUnAssociated;
	RxClassifierRdTypeConfigurationEntry_t	managementMulticastUnAssociated;
#if defined (ENET_INC_ARCH_WAVE600)
	RxClassifierRdTypeConfigurationEntry_t	managementUnicastProtected;
	RxClassifierRdTypeConfigurationEntry_t	managementMulticastProtected;
	RxClassifierRdTypeConfigurationEntry_t	managementUnicastUnAssociatedProtected;
	RxClassifierRdTypeConfigurationEntry_t	managementMulticastUnAssociatedProtected;
	RxClassifierRdTypeConfigurationEntry_t	dataUnicatProtected;
#endif //#if defined (ENET_INC_ARCH_WAVE600)
} RamRxClassifierRdTypeConfiguration_t;

#if defined (ENET_INC_ARCH_WAVE600)


typedef struct RxClassifierHtControlReference
{
	uint32 reference0;
	uint32 reference1;
	uint32 reference2;
	uint32 reference3;
	uint32 reference4;
	uint32 reference5;
	uint32 reference6;
	uint32 reference7;
} RamRxClassifierHtControlReference_t;

typedef struct RxClassifierHtControlMask
{
	uint32 mask0;
	uint32 mask1;
	uint32 mask2;
	uint32 mask3;
	uint32 mask4;
	uint32 mask5;
	uint32 mask6;
	uint32 mask7;
} RamRxClassifierHtControlMAsk_t;

typedef struct RxClassifierFrameControl
{
	uint32 reference0:16;
	uint32 mask0:16;
	uint32 reference1:16;
	uint32 mask1:16;
	uint32 reference2:16;
	uint32 mask2:16;
	uint32 reference3:16;
	uint32 mask3:16;
	uint32 reference4:16;
	uint32 mask4:16;
	uint32 reference5:16;
	uint32 mask5:16;
	uint32 reference6:16;
	uint32 mask6:16;
	uint32 reference7:16;
	uint32 mask7:16;
} RamRxClassifierFrameControl_t;

typedef struct RxClassifierQosControl
{
	uint32 reference0:16;
	uint32 mask0:16;
	uint32 reference1:16;
	uint32 mask1:16;
	uint32 reference2:16;
	uint32 mask2:16;
	uint32 reference3:16;
	uint32 mask3:16;
	uint32 reference4:16;
	uint32 mask4:16;
	uint32 reference5:16;
	uint32 mask5:16;
	uint32 reference6:16;
	uint32 mask6:16;
	uint32 reference7:16;
	uint32 mask7:16;
} RamRxClassifierQosControl_t;


typedef struct RxClassifierRam
{
	RamRxClassifierHtControlReference_t htControlReferenc;
	RamRxClassifierHtControlMAsk_t		htControlMAsk;
	RamRxClassifierFrameControl_t		FrameControl;
	RamRxClassifierQosControl_t			qosControl;
	RamRxClassifierRdTypeConfiguration_t rdTypeConfiguration;
} RxClassifierRam_t;


#else


typedef struct RxClassifierRam
{
	RamRxClassifierFrameClassViolationCacheEntry_t	ClassViolationCache[RX_CLASSIFIER_FRAME_CLASS_VIOLATION_CACHE_SIZE];
	RamRxClassifierRdTypeConfiguration_t rdTypeConfiguration;
	RamRxClassifierStaRekeyId_u staRekeyId[RX_CLASSIFIER_RAM_STA_REKEY_NUM_ROWS];
	RamRxClassifierVapRekeyId_u vapRekeyId;
} RxClassifierRam_t;
#endif

#endif /* RX_CLASSIFIER_RAM_H_ */
