/***********************************************************************************
 File:		RxCoordinator_Api.h
 Module:		Rx Coordinarot
 Purpose: 	Owner for all access to the Rx Coordinator
 Description:	This module is the API to the Rx Coordinator
************************************************************************************/
#ifndef RX_COORDINATOR_API_H_
#define RX_COORDINATOR_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/


typedef struct classViolationDetails
{
	IEEE_ADDR macAddress;
	uint8 valid;
	uint8 indexInCache;
	uint8 vapId;
	uint8 reserved; 
} classViolationDetails_t; 


/*---------------------------------------------------------------------------------
/						Externals					
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/

void 	RxCoordinator_Init(void);
void 	RxCoordinator_PostInit(void);
void 	RxCoordinator_ReadClassViolationCache(classViolationDetails_t *frameClassViolationDetails, uint8 vapId);
void 	RxCoordinator_ResetClass3ViolationValidEntry(uint32 cacheIndex, uint8 vapId);
void 	RxCoordinator_SetSnifferModeConfiguration(uint8 vapId);

#endif /* RX_COORDINATOR_API_H_ */



