/***********************************************************************************
 File:		RxCoordinatorRam.h
 Module:		Rx Coordinator
 Purpose: 	Owner for all access to the Rx Coordinator
 Description:	Rx Coordinator Ram Description
************************************************************************************/
#ifndef RX_COORDINATOR_RAM_H_
#define RX_COORDINATOR_RAM_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"



/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/							Data Type Definition												
/----------------------------------------------------------------------------------*/

typedef struct RamRxCoordinatorFrameClassViolationCacheEntry
{
	uint32 macAddr0to4;
	uint32 macAddr5to6:16;
	uint32 vapIndex:7;
	uint32 reserved1:1;
	uint32 violationClass:2;
	uint32 reserved2:6;	
} RamRxCoordinatorFrameClassViolationCacheEntry_t;


typedef struct RxCoordinatorRam
{
	RamRxCoordinatorFrameClassViolationCacheEntry_t	ClassViolationCache[RX_COORDINATOR_FRAME_CLASS_VIOLATION_CACHE_SIZE];
} RxCoordinatorRam_t;


#endif /* RX_COORDINATOR_RAM_H_ */
