/***************************************************************
 File:		RxHandler_Api.h
 Module:	  	RxHandler interface
 Purpose: 	interface bof the RxHandler
 Description:  This file is the API to the FW RxHandler module  
***************************************************************/
#ifndef RXH_GENRISC_INTERFACE_API_H_
#define RXH_GENRISC_INTERFACE_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "mhi_umi.h"
#include "RxHandler_MailboxApi.h"
#include "Statistics_Api.h"
#include "InterruptManager_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define RD_DUMMY_DMA_LENGTH	(64)

#define	RX_HANDLER_MINIMAL_NUM_OF_RDS_THRESHOLD	(16)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------





//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
uint16 RxHandler_Halt(void);
void RxHandler_Init(void);
ISR_VOID isr_RxHandler(void);
void RxHandler_SetUdpHeader(UMI_ADD_STREAM_REQ_t* addStreamStructurePtr);

#ifdef ENET_INC_ARCH_WAVE600

void RxHandlerInterface_Mailbox_Push(FwRxHandlerMailboxFifoInMessage_t *message);
K_MSG *RxHandlerInterface_Mailbox_Pop(void);

#else // not wave600
#ifdef FW_RX_HANDLER_MAILBOX_0_ENABLED
void RxHandlerInterface_Mailbox0_Push(FwRxHandlerMailbox0FifoInMessage_t *message);
K_MSG *RxHandlerInterface_Mailbox0_Pop(void);
#endif //FW_RX_HANDLER_MAILBOX_0_ENABLED

#ifdef FW_RX_HANDLER_MAILBOX_1_ENABLED
void RxHandlerInterface_Mailbox1_Push(FwRxHandlerMailbox1FifoInMessage_t *message);
K_MSG *RxHandlerInterface_Mailbox1_Pop(void);
#endif //FW_RX_HANDLER_MAILBOX_1_ENABLED

#endif // ENET_INC_ARCH_WAVE600







#endif /* RXH_GENRISC_INTERFACE_API_H_ */


