/***************************************************************
 File:		RxHandler.h
 Module:	  	Sender interface
 Purpose: 	holds the definions for the FW - sender interface module 
 Description:  This file contains the definions of the FW - sender interface module
***************************************************************/
#ifndef RXH_GENRISC_INTERFACE_H_
#define RXH_GENRISC_INTERFACE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "RxHandler_InitApi.h"
#if !defined (ENET_INC_ARCH_WAVE600)
#include "Rtd.h"
#endif
#include "RxDescriptor.h"
#include "rsn.h"
#include "ccmp.h"
#include "RxMpduStructure.h"
#include "frame.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define RXH_GENRISC_START_VALUE 1
#define RXH_GENRISC_HALT_VALUE 1
#define RXH_GENRISC_MAX_MICROSECONDS_FOR_INITIALIZATION 2500 
#define RXH_GENRISC_COMPLETED_CHI_MAGIC ((uint32)((RX_HANDLER_INIT_FIELD_CHI_MAGIC_READY_VALUE_H << 16) | RX_HANDLER_INIT_FIELD_CHI_MAGIC_READY_VALUE_L))
#define RX_HANDLER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE ((RX_HANDLER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_H << 16) | RX_HANDLER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_L)


#define RXH_ERROR_CAUSE_VALUE_MSDU_LENGTH_UNDER_MINIMUM          0x0
#define RXH_ERROR_CAUSE_VALUE_MSDU_LENGTH_OVER_MAXIMUM           0x1
#define RXH_ERROR_CAUSE_VALUE_MSDU_LENGTH_OVER_REMAINING_PAYLOAD 0x2
#define RXH_ERROR_CAUSE_VALUE_MSDU_HEADER_CONVERSION_FAILED      0x3
#define RXH_ERROR_CAUSE_VALUE_MPDU_LENGTH_UNDER_MINIMUM          0x4
#define RXH_ERROR_CAUSE_VALUE_MPDU_LENGTH_OVER_MAXIMUM           0x5
#define RXH_ERROR_CAUSE_VALUE_MPDU_HEADER_CONVERSION_FAILED      0x6


#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND

#define RX_PHY_HEADER_FIELD_FRAME_MARK_WORD_OFFSET					(0x0)
#define RX_PHY_HEADER_FIELD_TSF_WORD_OFFSET							(0x1)
#define RX_PHY_HEADER_FIELD_RESERVED_FIRST_WORD_WORD_OFFSET			(0x2)
#define RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_FIRST_WORD_WORD_OFFSET + FRAME_PREFIX_RESERVED_LENGTH_IN_WORDS - 0x1)
#define RX_PHY_HEADER_FIELD_PHY_METRICES_WORD_0_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x1)
#define RX_PHY_HEADER_FIELD_PHY_METRICES_WORD_1_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x2)
#define RX_PHY_HEADER_FIELD_PHY_STATUS_WORD_0_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x3)

#define RX_PHY_HEADER_FIELD_PHY_STATUS_WORD_1_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x4)
#define RX_PHY_HEADER_PHY_STATUS_WORD_1_FIELD_PHY_MODE_START_BIT	(0xE)
#define RX_PHY_HEADER_PHY_STATUS_WORD_1_FIELD_PHY_MODE_START_BYTE 	CONVERT_BIT_INDEX_TO_BYTES(RX_PHY_HEADER_PHY_STATUS_WORD_1_FIELD_PHY_MODE_START_BIT)



#define RX_PHY_HEADER_FIELD_PHY_STATUS_WORD_2_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x5)
#define RX_PHY_HEADER_FIELD_PHY_STATUS_WORD_3_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x6)
#define RX_PHY_HEADER_FIELD_PHY_STATUS_WORD_4_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x7)
#define RX_PHY_HEADER_FIELD_PHY_STATUS_WORD_5_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x8)
#define RX_PHY_HEADER_MAC_FRAME_HEADER_START_WORD_OFFSET			(RX_PHY_HEADER_FIELD_RESERVED_LAST_WORD_WORD_OFFSET + 0x9)	

#endif // DYNAMIC_RTS_ISSUE_WORKAROUND

#if defined(ENET_INC_ARCH_WAVE600)
#define RX_HANDLER_SNIFFER_UDP_HEADER_PADDING_BIG_ENDIAN		(0xAFDE) //0XDEAF
#else /*wave500*/
#define RX_HANDLER_SNIFFER_UDP_HEADER_PADDING_BIG_ENDIAN		(0xADDE) //0XDEAD
#endif 

#define RX_HANDLER_NO_ERROR										(0xE)
#define RX_HANDLER_DMA_ALIGNMENT								(8)
//#define RX_HANDLER_DMA_ALIGNMENT								(16)

// Values for action frame category bitmap. 
// LS bit in word0 refers to Category 0. MS bit in word3 refers to Category 127.
#define ACTION_FRAME_CATEGORY_INIT_WORD0                    	(0xFFFFFFFF ^ \
                                                            	((1<<BLOCK_ACK_CATEGORY) | \
                                                            	(1<<HT_CATEGORY) | \
                                                            	(1<<VHT_CATEGORY) | \
                                                            	(1<<HE_TWT_CATEGORY)))    
#define ACTION_FRAME_CATEGORY_INIT_WORD1                    	(0xFFFFFFFF)        
#define ACTION_FRAME_CATEGORY_INIT_WORD2                    	(0xFFFFFFFF)        
#define ACTION_FRAME_CATEGORY_INIT_WORD3                    	(0xFFFFFFFF)        
#if defined(ENET_INC_ARCH_WAVE600)
#define ACTION_FRAME_CATEGORY_INIT_WORD4                    	(0x0)        
#define ACTION_FRAME_CATEGORY_INIT_WORD5                    	(0x0)        
#define ACTION_FRAME_CATEGORY_INIT_WORD6                    	(0x0)        
#define ACTION_FRAME_CATEGORY_INIT_WORD7                    	(0x0)        
#endif //ENET_INC_ARCH_WAVE600

#ifdef SNIFFER_MU_ENABLED
#define TRIGGER_FRAME_BASIC_TYPE								(0)
#define TRIGGER_FRAME_RCR_DEFAULT_BSS_COLOR						(0)
#define TRIGGER_FRAME_NUM_OF_SUPPORTED_RU_ALLOCATIONS 			(68) //values between 0-67 only
#endif //SNIFFER_MU_ENABLED

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
#ifdef SNIFFER_MU_ENABLED

typedef struct _TriggerFrameCpAndLtfTable_t
{
	uint8 cp;
	uint8 ltf;
} TriggerFrameCpAndLtfTable_t;

typedef struct _TriggerFrameManagerRuAllocTable_t
{
	uint8 subBand;
	uint8 startRu;
	uint16 ruSize;
} TriggerFrameManagerRuAllocTable_t;

#endif //SNIFFER_MU_ENABLED

//---------------------------------------------------------------------------------
//						Function Declaration				
//---------------------------------------------------------------------------------




#endif /* RXH_GENRISC_INTERFACE_H_ */

