/***********************************************************************************
 File:			RxManager_Api.h
 Module:		Rx manager 
 Purpose: 		To handle all RDs/errors/indication from MAC Rx HW
 Description:   This file is the API of the Rx manager which is responsible 
 				of handling all the RDs/indications/errors from MAC Rx HW (in wave500)
************************************************************************************/
#ifndef RX_MANAGER_API_H_
#define RX_MANAGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "RxDescriptor.h"
#include "OSAL_Kmsg.h"
#include "frame.h"
#include "InterruptManager_Api.h"

/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/
#if defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)
/* Client Mode MCAST filter */
#define CLIENT_MODE_MCAST_FILTER_RING_SIZE									(32)	/* The number of elements in the ring */						
#endif // defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)

/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/

#if defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)
/* Client Mode MCAST filter */
typedef struct clientModeMcastFilterRingElement_s
{
	IEEE_ADDR	DA;						/* DA MAC Address of this packet */
	IEEE_ADDR	SA;						/* SA MAC Address of this packet */
	uint32 		sequenceNumber	:12;	/*  */	
	uint32		rdPointer		:16;	/* RD Pointer value */	
	uint32		reserved		: 2;	
	uint32		valid			: 1;	/* Is this an error-free RD: '0': RD had error so RXPP dropped it. '1': RD is valid so RXPP sent the RD to FW (this bit is for RX HANDLER usage) */	
	uint32		own				: 1;	/* Sync ring elements. '0': this ring element can be written to by RX HANDLER. '1': this ring element has not been read (yet) by RX MANAGER (little endianes: this is the MSB in the uint32) */	
}clientModeMcastFilterRingElement_t;
#endif

/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
extern void RxManager_TaskEntry(K_MSG *RxManagerMessage);
void RxManager_Initialize(void);
void RxManager_PostInit(void);
void RxManager_SetGroupKey(uint8 vapId, UMI_SET_KEY *psSetKey);
void RxManager_ClearGroupKey(uint8 vapId);
void rxManagerSetPnStaMode(uint8 vapId, uint8 *pnAddress, uint8 keyId);
void rxManagerHandleOmnFrame(OperatingModeNotificationPayload_t *pFramePayload, uint8 rxQueueStaId, uint8 vapId);
UmiOperationMode_e RxManager_GetDutOpeationMode(void);
void RxManager_IncDutRxCount(void);
void rxManagerInitializeRxDescriptorsLoggerPool(uint8 dataPathMode);

#if defined(ENET_INC_ARCH_WAVE600)
void HwEventsRxManager_RdReady(void);
#else // wave500
ISR_VOID isr_RxManager_RdReady(void);
#endif

#endif /* RX_MANAGER_API_H_ */

