/***************************************************************
 File:		SenderInterface_Api.h
 Module:	  	Sender interface
 Purpose: 	interface between the FW and the sender
 Description:  This file is the API to the FW - sender interface module  
***************************************************************/
#ifndef SENDER_INTERFACE_API_H_
#define SENDER_INTERFACE_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

#include "Std.h"
#include "lmi.h"

#include "TxSender_MailboxApi.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef enum LowerSenderEvents
{
	LOWER_SENDER_EVENT_TX_START		= 0,
	LOWER_SENDER_EVENT_TX_END,
	LOWER_SENDER_EVENT_RX_CMPLT,
	LOWER_SENDER_EVENT_WAIT_FOR_ACK_TIMEOUT,
	LOWER_SENDER_EVENT_TX_ABORT,
	LOWER_SENDER_NUM_OF_EVENTS
} LowerSenderEvents_e;

typedef enum LowerSenderStates
{
	LOWER_SENDER_STATE_IDLE		= 0,
	LOWER_SENDER_STATE_RTS_CONFIGURED,
	LOWER_SENDER_STATE_RTS_SENT,
	LOWER_SENDER_STATE_PACKET_CONFIGURED,
	LOWER_SENDER_STATE_PACKET_SENT,
	LOWER_SENDER_NUM_OF_STATES
} LowerSenderStates_e;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
uint16 Sender_Halt(void);
void Sender_Initialize(void);
ISR_VOID isr_Sender(void);


#ifdef ENET_INC_ARCH_WAVE600

void TxSenderInterface_Mailbox_Push(FwTxSenderMailboxFifoInMessage_t *message);
K_MSG *TxSenderInterface_Mailbox_Pop(void);
void TxSenderInterface_Send_Band(uint8 band);

#else

#ifdef FW_TX_SENDER_MAILBOX_0_ENABLED
void TxSenderInterface_Mailbox0_Push(FwTxSenderMailbox0FifoInMessage_t *message);
K_MSG *TxSenderInterface_Mailbox0_Pop(void);
void TxSenderInterface_Send_Band(uint8 band);

#endif //FW_TX_SENDER_MAILBOX_0_ENABLED

#ifdef FW_TX_SENDER_MAILBOX_1_ENABLED
void TxSenderInterface_Mailbox1_Push(FwTxSenderMailbox1FifoInMessage_t *message);
K_MSG *TxSenderInterface_Mailbox1_Pop(void);
#endif //FW_TX_SENDER_MAILBOX_1_ENABLED

#endif //ENET_INC_ARCH_WAVE600

#endif /* SENDER_INTERFACE_API_H_ */


