/***************************************************************
 File:		SenderInterface.h
 Module:	  	Sender interface
 Purpose: 	holds the definions for the FW - sender interface module 
 Description:  This file contains the definions of the FW - sender interface module
***************************************************************/
#ifndef SENDER_INTERFACE_H_
#define SENDER_INTERFACE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "TxSenderInitVector_Descriptors.h"
#endif //ENET_INC_ARCH_WAVE600
#include "TxSender_InitApi.h"
#include "SenderInterface_Api.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define SENDER_START_VALUE 1
#define SENDER_HALT_VALUE 1
#define SENDER_MAX_MICROSECONDS_FOR_INITIALIZATION 25 /* Based on Time Measurment of The Sender Initialization Sequence*/
#define SENDER_COMPLETED_CHI_MAGIC ((uint32)((TX_SENDER_INIT_FIELD_CHI_MAGIC_READY_VALUE_H << 16) | TX_SENDER_INIT_FIELD_CHI_MAGIC_READY_VALUE_L))
#define SENDER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE ((TX_SENDER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_H << 16) | TX_SENDER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_L)
        

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

#endif /* SENDER_INTERFACE_H_ */

