/***********************************************************************************
 File:			ServicesHandler_Api.h
 Module:		Services Module
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef SERVICES_HANDLER_API_H_
#define SERVICES_HANDLER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum
{
	SERVICE_ID_CDB_SYNC_PROCESS_SCHEDULED,
	SERVICE_ID_PAUSE_AC_TX,
	SERVICE_ID_RESUME_AC_TX,
	SERVICE_ID_SEND_CTS_SELF_FRAME,
	SERVICE_ID_PAUSE_VAP_TX,
	SERVICE_ID_RESUME_VAP_TX,
	SERVICE_ID_PAUSE_ALL_TX,
	SERVICE_ID_RESUME_ALL_TX,
	SERVICE_ID_PAUSE_RX,
	SERVICE_ID_RESUME_RX,
	SERVICE_ID_PAUSE_ALL,
	SERVICE_ID_CDB_SYNC_CTS_SENT,
	SERVICE_ID_RESUME_ALL,
	SERVICE_ID_SET_RXD,
	MAX_SERVICES_ID = SERVICE_ID_SET_RXD,
	NUM_OF_SERVICES,
	SERVICE_ID_INVALID= NUM_OF_SERVICES,
} ServicesId_e;

typedef enum
{
	SERVICES_STAUTS_PASSED,
	SERVICES_STAUTS_FAILED,
	NUM_OF_SERVICES_STATUSES,
	MAX_SERVICES_STATUS = 0xFF,
} ServicesStatus_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct ServiceRequestParams_
{
	void* serviceRequesterParams;
	uint32 serviceData; 
	K_TASKID returnTask;
	K_MSG_TYPE returnMsg;
	uint8 vapIndex;	
	ServicesId_e serviceId; 
} ServiceRequestParams_t;


typedef struct
{
	void* serviceRequesterParams;
	ServicesStatus_e serviceStatus; 
} ServiceReturnParams_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void ServicesHandler_RunService(ServiceRequestParams_t* serviceRequestParamas);
void ServicesHandler_ServiceCB(ServicesStatus_e serviceStatus);
void ServicesHandler_PauserCB(ServicesStatus_e serviceStatus);
void ServicesHandler_Init(void);


#endif //SERVICES_HANDLER_API_H_
