/***********************************************************************************
 File:		ServicesHandler.c		
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "ServicesHandler_Api.h"
#include "stringLibApi.h"
#include "ProcessManager_Api.h"
#include "Pauser_Api.h"
#include "CtsManager_Api.h"
#include "shram_man_msgs.h"
#include "init_ifmsg.h"
#include "ErrorHandler_Api.h"
#include "Utils_Api.h"
#include "Pauser_Api.h"
#include "MacHtExtensionsRegs.h"
#include "CtsManager_Api.h"
#include "loggerAPI.h"
#include "Pac_Api.h"
#include "PacketDescriptor.h"
#include "HdkCdbManagerTask_api.h"
#include "ConfigurationManager_api.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_SERVICES_HANDLER
#define LOG_LOCAL_FID 0


typedef enum TxPauseState
{
	TX_PAUSE_STATE_IDLE,
	TX_PAUSE_STATE_PENDING_DCF_PAUSE,
	TX_PAUSE_STATE_PENDING_CTS_SENT,
	TX_PAUSE_STATE_PENDING_ALL_QUEUES_PAUSE,
	TX_PAUSE_STATE_PENDING_RESUME,
	TX_PAUSE_STATE_PENDING_PAUSE_AT_CLOSE_AGGR,
	TX_PAUSE_STATE_PENDING_PAUSE_AT_DISCONNECT,

	TX_PAUSE_STATE_REPITITION_MODE,
	TX_PAUSE_STATE_PENDING_PAUSE_IND,
	TX_PAUSE_STATE_PAUSED_CFM,
	// Do not add states under this line
	TX_PAUSE_STATE_NUM,
	TX_PAUSE_STATE_ILLEGAL
}TxPauseState_e;




/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
typedef struct ServicesHandlerParams_
{
	uint8 currentRunningService;	
	uint32 currentRunningServiceData;	
	K_TASKID servicesReturnTaskId;
	K_MSG_TYPE returnMsg;
	uint8 vapIndex;
	UpperMacMessages_e servicesReturnMsg;
	void *requesterParams;
} ServicesHandlerParams_t;

typedef struct ServiceFunctionEntry
{
	void (* serviceHandler)(void);	
} ServiceFunctionEntry_t;


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void servicesHandlerPauseAcTx(void) ;
static void servicesHandlerResumeAcTx(void) ;
static void servicesHandlerPauseVapTx(void); 
static void servicesHandlerResumeVapTx(void) ;
static void servicesHandlerPauseAllTx(void) ;
static void servicesHandlerResumeAllTx(void) ;
static void servicesHandlerPauseRx(void) ;
static void servicesHandlerResumeRx(void); 
static void servicesHandlerPauseAllTxRx(void);
static void servicesHandlerResumeAllTxRx(void);
static void servicesHandlerSendCTS2Self(void);
static void servicesHandlerError(void);
static void serviceHandlerCdbSyncProcessSched(void);
static void serviceHandlerCdbSyncCtsSent(void);



/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
static const ServiceFunctionEntry_t serviceHandlers[NUM_OF_SERVICES] = 
{
	serviceHandlerCdbSyncProcessSched,	/*SERVICE_ID_CDB_SYNC_PROCESS_SCHEDULED*/
	servicesHandlerPauseAcTx,			/* SERVICE_ID_PAUSE_AC_TX */
	servicesHandlerResumeAcTx, 			/* SERVICE_ID_RESUME_AC_TX */
	servicesHandlerSendCTS2Self,		/* SERVICE_ID_SEND_CTS_SELF_FRAME */
	servicesHandlerPauseVapTx,			/* SERVICE_ID_PAUSE_VAP_TX*/
	servicesHandlerResumeVapTx,			/* SERVICE_ID_RESUME_VAP_TX*/
	servicesHandlerPauseAllTx,			/* SERRVIE_ID_PAUSE_ALL_TX */
	servicesHandlerResumeAllTx,			/* ERVICE_ID_RESUME_ALL_TX */
	servicesHandlerPauseRx,				/* SERVICE_ID_PAUSE_RX */ 
	servicesHandlerResumeRx,			/* SERVICE_ID_RESUME_RX */
	servicesHandlerPauseAllTxRx,		/* SERVICE_ID_PAUSE_ALL */
	serviceHandlerCdbSyncCtsSent,		/*SERVICE_ID_CDB_SYNC_CTS_SENT*/
	servicesHandlerResumeAllTxRx,		/* SERVICE_ID_RESUME_ALL  */ 
	servicesHandlerError,				/* SERVICE_ID_SET_RXD */	
};

static ServicesHandlerParams_t servicesHandlerParams;

//static requestParams;
TxPauserRepetitionParams_t repetitionParams;

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

serviceHandlerCdbSyncProcessSched 

Description:
------------
	Send message to HdkCdbManager for notify it that process scheduled  (before any service ran)

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void serviceHandlerCdbSyncProcessSched(void) 
{
	K_MSG *syncServiceMsg;
	HdkCdbManagerSyncServiceMsg_t* messageParams;
	BandId_e myBand = ConfigurationManager_GetMyBand();
	uint8 vapIndex = ConfigurationManager_GetFirstVapForBand(myBand);
 
	syncServiceMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerSyncServiceMsg_t));
	messageParams = (HdkCdbManagerSyncServiceMsg_t*)pK_MSG_DATA(syncServiceMsg);

	messageParams->servicType = SYNC_SERVICE_PROCESS_SCHEDULED;
	messageParams->band = myBand;
	
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_BAND_SYNC_SERVICE_PROCESS_SCHEDULED_IND, TASK_HDK_CDB_MANAGER,syncServiceMsg, vapIndex);
}
/**********************************************************************************

serviceHandlerCdbSyncCtsSent 

Description:
------------
	Send message to HdkCdbManager for notify it that Cts has sent

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void serviceHandlerCdbSyncCtsSent(void) 
{
	K_MSG *syncServiceMsg;
	HdkCdbManagerSyncServiceMsg_t* messageParams;
	BandId_e myBand = ConfigurationManager_GetMyBand();
	uint8 vapIndex = ConfigurationManager_GetFirstVapForBand(myBand);
 
	syncServiceMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerSyncServiceMsg_t));
	messageParams = (HdkCdbManagerSyncServiceMsg_t*)pK_MSG_DATA(syncServiceMsg);

	messageParams->servicType = SYNC_SERVICE_CTS_SENT;
	messageParams->band = myBand;
	
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_BAND_SYNC_SERVICE_CTS_SENT_IND, TASK_HDK_CDB_MANAGER,syncServiceMsg, vapIndex);
}

/**********************************************************************************

servicesHandlerPauseAcTx 

Description:
------------
	Pause PI to processes which were scheduled by Process Manager to pause/resume traffic
	It is not allow to call use this API without Process Manger scheduling


Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerPauseAcTx(void) 
{
	TxPauserPauseResumeParams_t txPasueParams;

	//pauserSuspendRepitionMode();

	txPasueParams.commandType = TX_PAUSER_PAUSE_ACS;
	txPasueParams.pauseAcType 	= (servicesHandlerParams.currentRunningServiceData & PAUSE_ACVAP_SUBTYPE_MASK) >> PAUSE_ACVAP_SUBTYPE_MASK_SHIFT;/*pauseAcTypes */
	txPasueParams.vapIndex = 0; 

	TxPauser_PauseAc(&txPasueParams);
}

/**********************************************************************************

servicesHandlerResumeAcTx 

Description:
------------
	

Input:
-----
	void
			
**********************************************************************************/
static void servicesHandlerResumeAcTx(void) 
{
	TxPauserPauseResumeParams_t txResumeParams;

	txResumeParams.commandType = TX_PAUSER_RESUME_ACS;
	txResumeParams.pauseAcType 	= (servicesHandlerParams.currentRunningServiceData & PAUSE_ACVAP_SUBTYPE_MASK) >> PAUSE_ACVAP_SUBTYPE_MASK_SHIFT;/*pauseAcTypes */
	txResumeParams.vapIndex = 0; 

	TxPauser_ResumeAc(&txResumeParams);
}

/**********************************************************************************

servicesHandlerPauseVapTx 

Description:
------------
	

Input:
-----
	void
			
**********************************************************************************/
static void servicesHandlerPauseVapTx(void) 
{
	TxPauserPauseResumeParams_t txPasueParams;

	txPasueParams.commandType = TX_PAUSER_PAUSE_VAPS;
	txPasueParams.pauseAcType 	= 0;	
	txPasueParams.vapIndex = (servicesHandlerParams.currentRunningServiceData & PAUSE_ACVAP_SUBTYPE_MASK) >> PAUSE_ACVAP_SUBTYPE_MASK_SHIFT;/*vapIndex */

	TxPauser_PauseVap(&txPasueParams);	
}

/**********************************************************************************

servicesHandlerPauseVapTx 

Description:
------------
	

Input:
-----
	void
			
**********************************************************************************/
static void servicesHandlerResumeVapTx(void) 
{
	TxPauserPauseResumeParams_t txResumeParams;

	txResumeParams.commandType = TX_PAUSER_RESUME_VAPS;
	txResumeParams.pauseAcType = 0;	
	txResumeParams.vapIndex = (servicesHandlerParams.currentRunningServiceData & PAUSE_ACVAP_SUBTYPE_MASK) >> PAUSE_ACVAP_SUBTYPE_MASK_SHIFT;/*vapIndex */

	TxPauser_ResumeVap(&txResumeParams);
}

/**********************************************************************************

servicesHandlerPauseAllTx 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerPauseAllTx(void) 
{
	TxPauserPauseResumeParams_t txPasueParams;

	txPasueParams.commandType = TX_PAUSER_PAUSE_ALL;
	txPasueParams.pauseAcType 	= 0;	
	txPasueParams.vapIndex = 0; 

	TxPauser_PauseAll(&txPasueParams);
}

/**********************************************************************************

servicesHandlerResumeAllTx 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerResumeAllTx(void) 
{
	TxPauserPauseResumeParams_t txResumeParams;

	txResumeParams.commandType = TX_PAUSER_RESUME_ALL;
	txResumeParams.pauseAcType = 0;	
	txResumeParams.vapIndex = 0; 

	TxPauser_ResumeAll(&txResumeParams);
}

/**********************************************************************************

servicesHandlerPauseRx 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerPauseRx(void) 
{
	TxPauser_PauseRx();
}

/**********************************************************************************

servicesHandlerResumeRx 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerResumeRx(void) 
{
	TxPauser_ResumeRx();
}

/**********************************************************************************

servicesHandlerPauseAllTxRx 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerPauseAllTxRx(void) 
{
	servicesHandlerPauseAllTx();
}

/**********************************************************************************

servicesHandlerResumeAllTxRx 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerResumeAllTxRx(void) 
{
	servicesHandlerResumeRx();
}

/**********************************************************************************

servicesHandlerSendCTS2Self 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerSendCTS2Self(void)
{
	K_MSG *ctsManagerMsg;
	CtsManagerTxReqMessage_t *ctsParams;
	uint8 vapIndex = GET_DEFAULT_VAP_FOR_MY_BAND();

	ctsManagerMsg = OSAL_GET_MESSAGE(sizeof(CtsManagerTxReqMessage_t));
	ctsParams = (CtsManagerTxReqMessage_t*)pK_MSG_DATA(ctsManagerMsg);

	ctsParams->timeout	= 500;	/*TBD -What should be the value*/	
	ctsParams->duration = ( (servicesHandlerParams.currentRunningServiceData & CTS2SELF_DURATION_MASK) >> CTS2SELF_DURATION_MASK_SHIFT); 
	ctsParams->msgId	= PROCESS_MANAGER_CTS_TX_CFM;
	ctsParams->taskId = TASK_PROCESS_MANAGER; 	/*Task to send confirmation to*/
	ctsParams->ctrl_bw = PD_CONTROL_20_MHZ;	
	ctsParams->vapIndex = vapIndex;
#ifdef BEEROCK_DEBUG
	ILOG0_DD("[servicesHandlerSendCTS2Self], ctsParams->duration = %d, servicesHandlerParams.currentRunningServiceData = %d", ctsParams->duration, servicesHandlerParams.currentRunningServiceData);
#endif		
	OSAL_SEND_MESSAGE(CTS_MANAGER_START_TX,TASK_TX_MANAGER,ctsManagerMsg, vapIndex);
}

/**********************************************************************************

servicesHandlerError

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void servicesHandlerError(void)
{
	DEBUG_FATAL("servicesHandlerError");
}

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

ServicesHandler_ServiceCB 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

void ServicesHandler_RunService(ServiceRequestParams_t*serviceRequestParamas)
{
	ServicesId_e serviceId;

	serviceId = serviceRequestParamas->serviceId;
	
	ILOG2_D("ServicesHandler_RunService:Service Id %d",serviceId );
	
	servicesHandlerParams.currentRunningService = serviceRequestParamas->serviceId;
	servicesHandlerParams.servicesReturnTaskId = serviceRequestParamas->returnTask;
	servicesHandlerParams.returnMsg = serviceRequestParamas->returnMsg;
	servicesHandlerParams.vapIndex = serviceRequestParamas->vapIndex;
	servicesHandlerParams.requesterParams = serviceRequestParamas->serviceRequesterParams;
	servicesHandlerParams.currentRunningServiceData = serviceRequestParamas->serviceData;

	DEBUG_ASSERT(serviceHandlers[serviceId].serviceHandler);
	serviceHandlers[serviceId].serviceHandler();	
}


/**********************************************************************************

ServicesHandler_ServiceCB 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void ServicesHandler_ServiceCB(ServicesStatus_e serviceStatus)
{	
	K_MSG *servicehandlerMsg	;
	ServiceReturnParams_t * serviceReturnParams;

	servicehandlerMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	serviceReturnParams = (ServiceReturnParams_t*)pK_MSG_DATA(servicehandlerMsg);

	serviceReturnParams->serviceRequesterParams = servicesHandlerParams.requesterParams;
	serviceReturnParams->serviceStatus = serviceStatus;
	servicesHandlerParams.currentRunningService = 0;

	/* Send Meesage to Service Requester*/
	OSAL_SEND_MESSAGE(servicesHandlerParams.returnMsg, servicesHandlerParams.servicesReturnTaskId,servicehandlerMsg, servicesHandlerParams.vapIndex);	

}


/**********************************************************************************

ServicesHandler_PauserCB 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

void ServicesHandler_PauserCB(ServicesStatus_e serviceStatus)
{	

	
	switch (servicesHandlerParams.currentRunningService)
	{
		case SERVICE_ID_PAUSE_ALL: // in pause all: pause TX done. trigger pause rx
			servicesHandlerParams.currentRunningService = SERVICE_ID_PAUSE_RX;
			serviceHandlers[SERVICE_ID_PAUSE_RX].serviceHandler();
			break;
		case SERVICE_ID_RESUME_ALL:// in resume all: resume RX done. trigger resume TX
			servicesHandlerParams.currentRunningService = SERVICE_ID_RESUME_ALL_TX;
			serviceHandlers[SERVICE_ID_RESUME_ALL_TX].serviceHandler();
			break;
		default:
			ServicesHandler_ServiceCB(serviceStatus);

	}

}


/**********************************************************************************

ServicesHandler_Init 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	void
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void ServicesHandler_Init(void)
{
	memset(&servicesHandlerParams,0,sizeof(ServicesHandlerParams_t));
}	
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

