/***********************************************************************************
File:				SharedDbTypes.h
Module:			Shared Files
Purpose:
Description:		This File includes parameters and types shred by Station DB and VAP DB
************************************************************************************/
#ifndef _SHARED_DB_TYPES_H_
#define _SHARED_DB_TYPES_H_

/*---------------------------------------------------------------------------------
/						Includes													 
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h" 
#include "System_GlobalDefinitions.h"
/*---------------------------------------------------------------------------------
/						Defines													 
/----------------------------------------------------------------------------------*/
#define WLAN_SUPP_RATES_MAX    32   
#define RX_MCS_BITMASK_LENGTH  10  /* RX MCS bitmask array length in bytes */

#define MPDU_MAX_LENGTH_EXP_0	8191 
#define MPDU_MAX_LENGTH_EXP_1 	16383
#define MPDU_MAX_LENGTH_EXP_2 	32767
#define MPDU_MAX_LENGTH_EXP_3 	65535
#define MAX_MSDU_IN_AMSDU  		255	

#define AMPDU_LENGTH_EXPONENT   13
#define VHT_MAX_AMPDU_LENGTH_EXPONENT	7
#define HT_MAX_AMPDU_LENGTH_EXPONENT	3
#define HT_MAX_A_MPDU_SIZE  65535
#define VHT_MAX_A_MPDU_SIZE 1048575
#define HE_MAX_A_MPDU_SIZE	6500631
#define MAX_MPDUS_IN_A_MPDU 64
#define SU_NUM_OF_MPDUS_IN_A_MPDU 64
#define MU_NUM_OF_MPDUS_IN_A_MPDU 48


#define SU_HE_NUM_OF_MPDUS_IN_A_MPDU 0 // No limit (256)
#define MU_HE_NUM_OF_MPDUS_IN_A_MPDU 0 // No limit (256)
#ifdef ENET_INC_ARCH_WAVE600
#define VHT_MAX_MSDU_IN_AMSDU 5 //until adaptive power will be implemented we set 5 as some stations (ac88) have problem with working with above than 5 MSDUs in AMSDU
#else
#define VHT_MAX_MSDU_IN_AMSDU 2
#endif

#define MAX_HE_MPDU_IN_A_MPDU_LENGTH_TX  11454
#define MAX_VHT_MPDU_IN_A_MPDU_LENGTH_TX 11454
#define MAX_HT_MPDU_IN_A_MPDU_LENGTH_TX  4095

#define MAX_HE_MPDU_IN_A_MPDU_LENGTH_RX  11454
#define MAX_VHT_MPDU_IN_A_MPDU_LENGTH_RX 11454
#define MAX_HT_MPDU_IN_A_MPDU_LENGTH_RX  4095

#define MAX_MPDU_LENGTH_OPTION1_HT		3839
#define MAX_MPDU_LENGTH_OPTION2_HT	  	7935

#define MAX_MPDU_LENGTH_OPTION1_VHT   	3895
#define MAX_MPDU_LENGTH_OPTION2_VHT	  	7991
#define MAX_MPDU_LENGTH_OPTION3_VHT	  	11454

#define MAX_MSDU_LENGTH			(2304)

#define MAX_PSDU_TX_TIME_LIMIT 5400
#define MAX_PSDU_TX_TIME_LIMIT_11B 0x3FFF // Not final value. Should be provided by system team.

#define MAX_VHT_MCS_FOR_SS_NUM_OF_BITS		2 // 2 bits for every Spatial Stream
#define MAX_VHT_MCS_FOR_SS_MASK				0x3 // 2 bits for every Spatial Stream (Mask)
#define SPATIAL_STREAMS_NOT_SUPPORTED		3
#define NSS_SHIFT_IN_TCR_RATE				4
#define NUM_OF_MAX_MCS_VALUES				3

//mcs
typedef enum
{
	MCS_0,
	MCS_1,
	MCS_2,
	MCS_3,
	MCS_4,
	MCS_5,
	MCS_6,
	MCS_7,
	MCS_8,
	MCS_9,
	NUM_OF_MCS,			/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
} mcs_e;



#define PACKT_DENSITY_NO_RESTRICTION 0

#define DEFAULT_MIMO_GROUP_ID	63 //0 for station, 63 for AP


#define NOT_SUPPORTED 0
#define SUPPORTED 	  1

#define DISABLED	0
#define ENABLED		1	


typedef enum SpatialStreamNum
{
	SPATIAL_STREAM_1,
	SPATIAL_STREAM_2,
	SPATIAL_STREAM_3,
	SPATIAL_STREAM_4,
	SPATIAL_STREAM_NUM,
	SPATIAL_STREAM_MAX,
}	SpatialStreamNum_e;

typedef enum
{
	TX_POSTPONE_NOT_SUPPORTED	= 0,
	TX_POSTPONE_CTS2SELF 		= 1,
	TX_POSTPONE_RTS_CTS 		= 2,
	TX_POSTPONE_NDP_ACK 		= 3,
}TxPostpone_e;

typedef enum Dcm
{
	NO_DCM,
	WITH_DCM,	
	MAX_DCM_OPTIONS
}Dcm_e;

typedef enum StaDbldpcConfig
{
	CONVOLUTIONAL_CODING = 0,
	LDPC,
	MAX_LDPC_OPTIONS,
} StaDbldpcConfig_e;


typedef enum PacketType_e
{
	PACKET_TYPE_DATA,
	PACKET_TYPE_802_11, /*management*/
	PACKET_TYPE_ALL,
} PacketType_e;


/*---------------------------------------------------------------------------------
/			Debug Data Type Definition													 
/----------------------------------------------------------------------------------*/
typedef enum hwDbTcr0DataDebugIds
{
	HW_DB_DEBUG_TCR0_DATA_PHY_MODE 			= 0x0,
	HW_DB_DEBUG_TCR0_DATA_BW 				= 0x1,
	HW_DB_DEBUG_TCR0_DATA_RF_POWER_MHZ 		= 0x2,
	HW_DB_DEBUG_TCR0_DATA_PHY_BF_MODE 		= 0x3,
	HW_DB_DEBUG_TCR0_DATA_ANTENNA_SELECTION = 0x4,
}	hwDbTcr0DebugIds_e;


typedef enum hwDbTcr0ManagementDebugIds
{
	HW_DB_DEBUG_TCR0_MANAGEMENT_PHY_MODE    = 0x0,
	HW_DB_DEBUG_TCR0_MANAGEMENT_BW			= 0x1,
	HW_DB_DEBUG_TCR0_MANAGEMENT_RF_POWERMHZ = 0x2,
	HW_DB_DEBUG_TCR0_MANAGEMENT_PHY_BF_MODE = 0x3,
	HW_DB_DEBUG_TCR0_MANAGEMENT_ANTENNA_SELECTION  = 0x4,
} hwDbTcr0ManagementDebugIds_e;


typedef enum hwDbTcr1DataDebugIds
{
	HW_DB_DEBUG_TCR1_DATA_LDPC,
	HW_DB_DEBUG_TCR1_DATA_STBC,
	HW_DB_DEBUG_TCR1_DATA_PARTIAL_AID,
	HW_DB_DEBUG_TCR1_DATA_TXOP_PS_NOT_ALLOWED,
	HW_DB_DEBUG_TCR1_DATA_GROUP_ID,
	HW_DB_DEBUG_TCR1_DATA_MIMO_PS,
}	hwDbTcr1DataDebugIds_e; 


typedef enum hwDbTcr3DebugIds
{
	HW_DB_DEBUG_TCR3_AGGREGATE,
	HW_DB_DEBUG_TCR3_NOT_SOUNDING,
	HW_DB_DEBUG_TCR3_BF_FOR_SIG_A_SMOTHING,
	HW_DB_DEBUG_TCR3_DYNAMIC_BW,
	HW_DB_DEBUG_TCR3_RATE,
	HW_DB_DEBUG_TCR3_SCP,
}	hwDbTcr3DebugIds_e;


typedef enum hwDbTcr2DebugIds
{
	HW_DB_DEBUG_TCR2_CDD_ANT1,
	HW_DB_DEBUG_TCR2_CDD_ANT2,
	HW_DB_DEBUG_TCR2_CDD_ANT3,
}	hwDbTcr2DebugIds_e;


typedef enum hwDbTcr1DebugIds
{
	HW_DB_DEBUG_TCR1_LDPC,
	HW_DB_DEBUG_TCR1_STBC,
	HW_DB_DEBUG_TCR1_PARTIAL_AID,
	HW_DB_DEBUG_TCR1_TXOP_PS_NOT_ALLOWED,
	HW_DB_DEBUG_TCR1_GROUP_ID,
	HW_DB_DEBUG_TCR1_MIMO_PS,
	HW_DB_DEBUG_TCR1_FRAME_SYNC,
}	hwDbTcr1DebugIds_e;


typedef enum hwDbTidDebugIds
{
	HW_DB_DEBUG_CURRENT_SEQUENCE_NUMBER,
	HW_DB_DEBUG_LOW_SEQUENCE_NUMBER,
	HW_DB_DEBUG_BA_ENABLE,
	HW_DB_DEBUG_PPDU_TX_MODE,
	HW_DB_DEBUG_SP_LENGTH_LIMIT,
	HW_DB_DEBUG_CURRENT_BA_WINDOW_LIMIT,
	HW_DB_DEBUG_MAX_PSDU_LIMIT,
	HW_DB_DEBUG_TXOP_MULTIPLE_DATA_ENABLE,
}	hwDbTidDebugIds_e;


typedef enum hwDbDebugIds
{
	HW_DB_DEBUG_MAX_MPDU_LENGTH_LIMIT     = 0x0, 
	HW_DB_DEBUG_MAX_MSDU_AT_AMSDU_COUNT   = 0x8,
	HW_DB_DEBUG_MAX_PSDU_LENGTH_LIMIT 	  = 0xD, 
}	hwDbDebugIds_e;



/*---------------------------------------------------------------------------------
/						Data Type Definition													 
/----------------------------------------------------------------------------------*/


#endif // _SHARED_DB_TYPES_H_
