/***********************************************************************************
 File:			SmpsManager_Api.h
 Module:		SMPS Manager 
 Purpose: 		To handle Transmission of SMPS Action Frames after CoC transitions
 Description:	
************************************************************************************/
#ifndef SMPS_MANAGER_API_H_
#define SMPS_MANAGER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "PacketDescriptor.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define SMPS_LOGS 1

/*The SM Power Control field sent in SMPS Action frames is composed of 
b0 - SM Power Save Enabled, 0 - Disabled, 1 - Enabled
b1 - SM Power Save Mode, 0 - Static, 1 - Dynamic
Therefore the possible values of this field are
0 - Static Disabled
1 - Static Enabled
2 - Dynamic Disabled - probably 0 and 2 can be just regarded as SM Power Save Disabled ...
3 - Dynamic Enabled*/
typedef enum
{
	SMPS_MODE_DISABLED	= 0x0,
	SMPS_MODE_STATIC	= 0x1,
	SMPS_MODE_DYNAMIC	= 0x3, // Not supported currently
} smpsMode_e;

/*The SM Power save mode field in the HT capabilities info field may
contain the following values
0 - Static
1 - Dynamic
3 - Disabled
In AP this field indicates the SM Power Save mode supported
This field in Assoc REQ indicates the current SM State*/
typedef enum
{
	VAP_SMPS_MODE_STATIC	= 0x0,
	VAP_SMPS_MODE_DYNAMIC 	= 0x1,
	VAP_SMPS_MODE_DISABLED 	= 0x3
} vapSmpsMode_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct _SmpsManagerStartTxReqParams_t
{
       uint8 mode;
	   uint8 numOfAntennas;
	   uint8 maxRxAntsNum;
} SmpsManagerStartTxReqParams_t;

typedef struct SmpsManagerPacketConfirmedMessage
{
	TxPd_t *pd;
} SmpsManagerPacketConfirmedMessage_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void smpsManagerTxStartReq(K_MSG* smpsManagerMessage);
extern void smpsManagerVapOpen(K_MSG* smpsManagerMessage);
extern void smpsManagerVapRemove(K_MSG* smpsManagerMessage);
extern void smpsManagerStaOpen(K_MSG* smpsManagerMessage);
extern void smpsManagerStaRemove(K_MSG* smpsManagerMessage);
extern void smpsManagerLockCfm(K_MSG* smpsManagerMessage);
extern void smpsManagerTxCfm(K_MSG* smpsManagerMessage);
extern void smpsManagerPdAlloc(K_MSG* smpsManagerMessage);
extern void smpsManager_Init(void);
extern void smpsManager_GetChannelWidth(K_MSG* smpsManagerMessage);

#endif /* CSA_MANAGER_API_H_ */





