/***********************************************************************************
 File:			SmpsManager.h
 Module:		SMPS Manager
 Purpose: 		To handle Transmission of SMPS Action Frames after CoC transition
 Description:	
************************************************************************************/
#ifndef SMPS_MANAGER_H_
#define SMPS_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern uint8 SmpsManager_VapSmps(uint8 vapId);
extern void SmpsManager_BuildSmps(TxPd_t *pd);
#ifdef ENET_INC_ARCH_WAVE600
extern uint8 SmpsManager_GetMode(uint8 bandId);
extern uint8 SmpsManager_GetAntennaNumber(uint8 bandId);
extern uint8 SmpsManager_GetMaxAntennaNumber(uint8 bandId);
#else
extern uint8 SmpsManager_GetMode(void);
extern uint8 SmpsManager_GetAntennaNumber(void);
extern uint8 SmpsManager_GetMaxAntennaNumber(void);
#endif
extern void SmpsManager_BuildOmn(TxPd_t *pd);

#endif /* SMPS_MANAGER_H_ */







