/***********************************************************************************
 File:		StatisticsManager_api.h
 Module:		
 Purpose: 	Handle  
 Description:	This file contains all definitions and the structures of the LinkAdaptation  
 				
************************************************************************************/
#ifndef FW_STATISTICS_MANAGER_API_
#define FW_STATISTICS_MANAGER_API_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RxDescriptor.h"
#include "OSAL_Kmsg.h"
#include "PacketDescriptor.h"
#include "Statistics_Descriptors.h"

 // include DMA extenstions
#include "DmaManager_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//--------------------------------------------------------------------------------- 

extern GeneralStatistics_t GeneralStatistics;


 //---------------------------------------------------------------------------------
//						Enums						
//--------------------------------------------------------------------------------- 
typedef enum StatisticsCpuLoadCPUs
{
	STATISTICS_CPU_LOAD_CPUS_UPPERMAC = 0,
	STATISTICS_CPU_LOAD_CPUS_LOWERMAC,
	STATISTICS_CPU_LOAD_CPUS_NUM,
	STATISTICS_CPU_LOAD_CPUS_MAX = MAX_UINT8,
}StatisticsCpuLoadCPUs_t;

typedef struct StatisticsCpuLoadCnf
{
	uint32 					load;
	StatisticsCpuLoadCPUs_t	cpu;
}StatisticsCpuLoadCnf_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void    statisticsManagerInit(void);
void    statisticsManagerPostInit(void);
void statisticsManagerResetAllStatistics(void);
void    statisticsManagerGetStatisticsDataReq(K_MSG* msg);
void    statisticsManagerGetStatisticsDataCfm(K_MSG* msg,uint8 status);
void	statisticsManagerCpuLoadReq(K_MSG *msg_p);
void 	statisticsManagerCpuLoadTimerExpiry(K_MSG *msg_p);
void 	statisticsManagerCpuLoadHandleConfirm(K_MSG *pMsg);
void     statisticsManagerDmaDone(K_MSG* msg_p);
void    StatisticsManagerDebugFunction(uint32 data1, uint32 data2, uint32 data3);

uint32 StatisticsSetPdStatusNackInList(TxPd_t *headPacketDescriptor);
uint32* statisticsGetBaaCountersAddress(void);
uint32* statisticsGetHostIfCountersAddress(void);
uint32* statisticsGetRxCountersAddress(void);
uint32* statisticsGetUpLinkBsrcCountersAddress(void);
#ifdef ENET_INC_ARCH_WAVE600D2
uint32* statisticsGetHostIfQosCountersAddress(void);
uint32* statisticsGetRxCoordinatorCountersAddress(void);
#endif

void statisticsManagerCpuLoadTriggerRequest(void);

#endif /* FW_STATISTICS_MANAGER_API_ */

