/***********************************************************************************
 File:		StatisticsManager.h
 Module:		pacManager
 Purpose: 	Handle PacManager 
 Description:	This file contains all definitions and the structures of the StatisticsManager  
 				
************************************************************************************/
#ifndef STATISTICS_MANAGER_H_
#define STATISTICS_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "MT_Build_Config.h"
#include "HwGlobalDefinitions.h"


// header file for inside FW client
#include "StatisticsManager_api.h"

// include SW/HW TxCounter statistics
#include "StatisticsHandler.h"

// include the logger
#include "loggerAPI.h"

// include TsManager statistics
#include "TsManager_API.h"

// include Macros like MIN,MAX
#include "Utils_Api.h"

// include IRAM extenstions
#include "mt_bcl_task.h"

// include Massage extenstions
#include "OSAL_Kmsg.h"
#include "mhi_umi.h"

// include event messages
#include "EventsManager_api.h"

#include "shram.h"

#include "Statistics_Api.h"


#include "ErrorHandler_Api.h"
#include "queue_utility.h"
#include "OSAL_Kmsg.h"
#include "BSSmanager_API.h"
#include "loggerAPI.h"
#include "StatisticsPhyHandler.h"

//---------------------------------------------------------------------------------
//						Enums						
//--------------------------------------------------------------------------------- 




//Statistic Type - should be synced with Statistics_Descriptors.h, to be in same order as in StatisticsDb_t struct
typedef enum StatisticType
{
	STATISTIC_TYPE_FIRST_STATISTIC,
#ifdef ENET_INC_ARCH_WAVE600D2
	STATISTIC_TYPE_HOSTIF_QOS_COUNTERS = STATISTIC_TYPE_FIRST_STATISTIC,
	STATISTIC_TYPE_HOSTIF_COUNTERS,
	STATISTIC_TYPE_RX_COORDINATOR_COUNTERS,
#else
	STATISTIC_TYPE_HOSTIF_COUNTERS = STATISTIC_TYPE_FIRST_STATISTIC,
#endif
	STATISTIC_TYPE_RX_COUNTERS,
	STATISTIC_TYPE_BAA_COUNTERS,	
	STATISTIC_TYPE_UPLINK_BSRC_COUNTERS,
	STATISTIC_TYPE_TS_MANAGER_INITIATOR_GLOBAL_TID_STATS,
	STATISTIC_TYPE_TS_MANAGER_INITIATOR_GLOBAL_STA_STATS,
	STATISTIC_TYPE_TS_MANAGER_RECIPIENT_GLOBAL_TID_STATS,
	STATISTIC_TYPE_TS_MANAGER_RECIPIENT_GLOBAL_STA_STATS,
	STATISTIC_TYPE_LINK_ADAPTATION_STATS,
	STATISTIC_TYPE_MULTICAST_STATS,
	STATISTIC_TYPE_TRAINING_MANAGER_STATS,
	STATISTIC_TYPE_GROUP_MANAGER_STATS,
	STATISTIC_TYPE_LINK_ADAPTATION_MU_STATS,
	STATISTIC_TYPE_PTA,
	STATISTIC_TYPE_TWT_STATS,
	STATISTIC_TYPE_PLAN_MANAGER_STATS,
	STATISTIC_TYPE_ALPHA_FILTER_STATS,
	STATISTIC_TYPE_PER_CLIENT_TRANSMIT_COUNT,
	STATISTIC_TYPE_GENERAL_STATS,
	STATISTIC_TYPE_DYNAMIC_BW_STATS,
	STATISTIC_TYPE_RX_PHY_STATUS_STATS,
	STATISTIC_TYPE_CHANNEL_STATS,
	STATISTIC_TYPE_TOTAL,
} StatisticType_e;




/* 	
	Table's enum to save space. 				 					
	Please make sure to add coresponding 
	value to look-up table.
*/

// lookup table = ConvertEnumToUnitSize
typedef enum 
{
    UNIT_SIZE_ZERO_BYTE = 0,     // 0 Bytes
	UNIT_SIZE_ONE_BYTE,		     // 1 Bytes
	UNIT_SIZE_TWO_BYTES,		 // 2 Bytes
	UNIT_SIZE_FOUR_BYTES,	  	 // 4 Bytes
	UNIT_SIZE_TOTAL,
} StatisticUnitSize_e;

typedef enum 
{
	STATISTICS_RAW_DATA = 0,	
	STATISTICS_MANIPULATION_DATA,
} statisticComponent_e;


typedef enum 
{
	STATISTICS_TRIGGER_MANAGER = 0,	
	STATISTICS_SPLIT_ON,
	STATISTICS_COPY_STATE_TOTAL,
} statisticCopyState_e;


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/


#define TOTAL_NUMBER_OF_DATA_RAW_TRANSACTIONS   (STATISTIC_TYPE_TOTAL)
#define TOTAL_NUMBER_OF_DATA_MANIPULATION_TRANSACTIONS  (0x0)
#define STATISTIC_TYPE_SUPPORTED(size) (size != 0)
#define STATISTIC_SUBTYPE_ALIGN4_MASK(X) ((X&0x03) == 0)  // 0xFFFFFFFC

//Align to lower dword address
#define STAT_ALIGN_DWORD(X) ((X) & ~0x03)
#define STAT_SHORT_MASK (0xFFFF)
#define STAT_SIZE_OF_BYTE (8)

#define STAT_FOUR_BYTES_ALIGN_MASK	(0x3)

#define DEBUG_STAT_INIT_VALUE	(0xAC)

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
//Entry type to save in table (many) decoded by enums

typedef struct statisticsDmaParams
{
	dmaDirection_e typesArrayDmaDirection[STATISTIC_TYPE_TOTAL]; // Based on the address we determind the DMA direction.
	SourceType_e typesArraySourceType[STATISTIC_TYPE_TOTAL]; 	 // Based on the address we determind the source type.
	K_MSG* pMcMsg;					// pointer to the original MSG from driver
	uint8  dmaClientId;
	uint32 dmaReq;    				// Number of dma requests that were done so far
	uint32 dmaTotal;				// Total expected number of dma activations (not all were triggerred already)
	bool   dmaInUse;				// is DMA in use by statistics or not
	uint32 ddrBufferAddress;		// pointer to the next point in buffer we should DMA to
	uint32 ddrBufferStartAddress; 	// pointer to beginning of buffer
	uint32 sourceCurr;				// pointer to the next source for the DMA. When we split and copy to SHRAM, this changes on the fly.
	uint16 sizeToTransfer;
	uint8  dmaTypeTransaction;
} statisticsDmaParams_t;


typedef struct statisticsManagerDb_s
{
	// A list of pointers to every statistics data, Set as 1Byte type for easy aritmetics (calculating address later by adding number of Bytes)
	uint8 *pTypeDataList[STATISTIC_TYPE_TOTAL];

	// Number of Bytes allocated for each type.
	uint16 typesArraySize[STATISTIC_TYPE_TOTAL];

	statisticsDmaParams_t dmaParams;

	// Total Size need to allocate in host to be enough for all statistics data transactions;
	uint32 totalSizeToAllocate;

	//iram split handler
	statisticCopyState_e   statisticsCopyState;
	uint16 splitTimesRemain;

	// Function pointer to statisticsManagerCopyStatisticsRawData or statisticsManagerCopyStatisticsManipulationData
	void (*triggerManager)(void);

	// Function pointer to statisticsManagerCopyStatisticsRawDataShramHandler or statisticsManagerCopyStatisticsManipulationDataShramHandler	
	uint32 (*triggerCopyToShramBuffer)(uint32, uint16);

	statisticComponent_e  statisticComponent;
} statisticsManagerDb_t;

typedef struct StatisticsCpuLoadDb
{
	uint32	load[STATISTICS_CPU_LOAD_CPUS_NUM];	/* Array of cpu load. Each cell is a CPU */
	uint32	timerPeriod;						/* The period of time in milliseconds where the Statistic Manager updates the cpu load array */
}StatisticsCpuLoadDb_t;

/*---------------------------------------------------------------------------------
/						Function Declaration									
/----------------------------------------------------------------------------------*/
void statisticsManagerCopyStatisticsStart(void);
void statisticsManagerCopyStatisticsManipulationData(void);
void statisticsManagerCopyStatisticsRawData(void);
void statisticsManagerCopyStatisticsToShramHandlerInit(uint16 sizeToTransfer, uint32 source);
void statisticsManagerCopyStatisticsHandler(void);
void statisticsManagerClearQosRxSta(void *pQosRxStaCounter); 
void statisticsManagerDmaTransaction(uint32 source, uint32 destination, uint16 length ,uint8 direction);
uint32 statisticsManagerCopyStatisticsManipulationDataShramHandler(uint32 sourceCurr, uint16 sizeToCopy);
uint32 statisticsManagerCopyStatisticsRawDataShramHandler(uint32 sourceCurr, uint16 sizeToCopy);
void statisticsManagerTaskEntry(K_MSG *statisticsManagerMsg);
void statisticsManagerResetAllStationStatisticsHostIfCounters(StaId stationId);
void statisticsManagerResetAllStationStatisticsRxCounters(StaId stationId);
void statisticsManagerResetAllStationStatisticsBaaCounters(StaId stationId);
void statisticsManagerResetAllStationStatistics(StaId stationId, bool resetHostIFCounters);
void statisticsManagerResetAllVapStatistics(uint8 vapId);
void StatisticsManagerResetAllVapStatisticsHostIfCounters(uint8 vapId);
void StatisticsManagerResetAllVapStatisticsRxCounters(uint8 vapId);
void StatisticsManagerResetAllVapStatisBaaCounters(uint8 vapId);
void statisticsManagerResetAllStationStatisticsLinkAdaptationStatistics(StaId stationId);
void statisticsManagerResetAllStationStatisticsPerClientStatistics(StaId staionId);
void statisticsManagerResetAllStationStatisticsPlanMangerStatistics(StaId staionId);
void statisticsManagerResetAllStationStatisticsUpLinkBsrcStatistics(StaId staionId);



#endif /* STATISTICS_MANAGER_H_ */

