/***************************************************************
 File:		  System_Configuration.h
 Module:	  System
 Purpose: 	  
 Description: 
***************************************************************/
#ifndef SYSTEM_CONFIGURATION_H_
#define SYSTEM_CONFIGURATION_H_

#include "System_GlobalDefinitions.h"

//-=-=-=-=-=-=-=-=-
// Constants
//-=-=-=-=-=-=-=-=-

#define SYSTEM_NUM_OF_CORES 2

#if defined (ENET_INC_UMAC)
#define SYSTEM_CORE_ID		(0)
#else
#define SYSTEM_CORE_ID		(1)
#endif

#define DESCRIPTOR_RAM_ADDR_MASK (0x3FFFFF)
//---------------------------------------------------------------------------------
//						Macros				
//---------------------------------------------------------------------------------
/* Converts KSEG0/1 or physical addr (below 0.5GB) to physical address.*/
#define CONVERT_TO_PHYSICAL_ADDR(addr)				((uint32)(addr)  & ~KSEG_MASK) // TBD - This is MIPS. Can it stay in ARC?
#define	CONVERT_PHYSICAL_TO_SHRAM_OFFSET(addr)		((uint32)(addr) - SHARED_RAM_BASE_ADDR)

#define CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR(x) 				(((x) - SHARED_RAM_BASE_ADDR) + System_GetXbarAddress() + SHARED_RAM_OFFSET_FROM_BAR0) 
#define CONVERT_DMA_SHRAM_ADDR_TO_WLAN_SHRAM_ADDR(x) 				(((x) - SHARED_RAM_OFFSET_FROM_BAR0 - System_GetXbarAddress()) + SHARED_RAM_BASE_ADDR) 
#define CONVERT_WLAN_SHRAM_ADDR_TO_OFFSET_FROM_BAR0(x) 	  			(((x) - SHARED_RAM_BASE_ADDR) + SHARED_RAM_OFFSET_FROM_BAR0) 
#define CONVERT_ADDR_FOR_WLAN_HW(x) 								CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR(x) /* The only Hw which use this field is the DMA */
#define CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(x) 		(((x) - HOST_IF_ACC_BASE_ADDR) + HOST_IF_ACC_OFFSET_FROM_BAR0) 
#define CONVERT_HOST_HOST_IF_ACC_ADDR_TO_WLAN_HOST_IF_ACC_ADDR(x) 	(((x) - HOST_IF_ACC_OFFSET_FROM_BAR0) + HOST_IF_ACC_BASE_ADDR) 

#define CONVERT_WLAN_HOSTIF_ADDR_TO_DMA_HOST_IF_ADDR(x)			(((x) - HOST_IF_COUNTERS_BASE_ADDR) + System_GetXbarAddress() + HOST_IF_COUNTERS_OFFSET_FROM_BAR0) 
#define CONVERT_WLAN_RXCOUNTER_ADDR_TO_DMA_RXCOUNTER_ADDR(x)			(((x) - RX_PP_COUNTERS_BASE_ADDR) + System_GetXbarAddress() + RX_PP_COUNTERS_OFFSET_FROM_BAR0) 

#ifdef ENET_INC_ARCH_WAVE600D2
#define CONVERT_WLAN_HOST_IF_QOS_ADDR_TO_DMA_HOST_IF_QOS_ADDR(x)			(((x) - HOST_IF_QOS_COUNTERS_BASE_ADDR) + System_GetXbarAddress() + HOST_IF_QOS_COUNTERS_OFFSET_FROM_BAR0) 
#define CONVERT_WLAN_RX_COOR_COUNTER_ADDR_TO_DMA_RX_COOR_COUNTER_ADDR(x)			(((x) - RX_COORDINATOR_COUNTERS_BASE_ADDR) + System_GetXbarAddress() + RX_COORDINATOR_COUNTERS_OFFSET_FROM_BAR0) 
#endif

#if defined (ENET_INC_ARCH_WAVE600)
#define CONVERT_WLAN_DESCRIPTOR_ADDR_TO_OFFSET_FROM_BAR0(x) 	  		(((x) - DESCRIPTOR_RAM_BASE_ADDR) + DESCRIPTOR_RAM_OFFSET_FROM_BAR0) 
#define CONVERT_ADDR_TO_MAC_DESCRIPTOR_MEM_ADDR(x) 	  					(((x) & DESCRIPTOR_RAM_ADDR_MASK) | DESCRIPTOR_RAM_BASE_ADDR) // Only 22 lsb are the address 0xA04 is a mapping to the descriptors ram  

#endif

#define CONVERT_WLAN_BAACOUNTER_ADDR_TO_DMA_BAACOUNTER_ADDR(x)			(((x) - BA_ANALYZER_COUNTER_BASE_ADDR) + System_GetXbarAddress() + BA_ANALYZER_COUNTER_OFFSET_FROM_BAR0) 

#define DDR_MEMORY_BASE_ADDR_FROM_ARM_DMA (0x0)

#define CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(x) 		 	((x)| DDR_MEMORY_BASE_ADDR_FROM_ARM_DMA) 


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
uint32 System_ConvertUsToSystemClk(uint32 us);
uint32 System_ConvertNsToSystemClk(uint32 ns);
uint32	System_GetMainCoreFrequency(void);
uint32 System_GetXbarAddress(void);
void	System_ConfigurationInit(void);



#endif //SYSTEM_CONFIGURATION_H_
