/***********************************************************************************
 File:		System_CoreTimersApi.h
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
#ifndef SYSTEM_CORE_TIMER_API_H_
#define SYSTEM_CORE_TIMER_API_H_

/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "InterruptManager_Api.h"

/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/



typedef enum
{
	SYSTEM_CORE_TIMER_0,			// 0x0
	SYSTEM_CORE_TIMER_1,			// 0x1
	SYSTEM_CORE_NUM_OF_TIMERS,	

} systemCoreTimerId_e;


typedef void (*System_coreTimerCallback)(void);

/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

#define CONVERT_MS_TO_SYS_TICK(ms) 		(ms*System_GetMainCoreFrequency()*1000)


/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Function Declaration
/----------------------------------------------------------------------------------*/
void System_CoreTimersDisableTimer(uint8 timerId);

void System_CoreTimersResetTimerCount(uint8 timerId);
void System_CoreTimersSetTimer(uint8 timerId, bool oneShot, uint32 duration, System_coreTimerCallback callbackFunction);
void System_CoreTimersInit(void);
ISR_VOID System_CoreTimersIsrHandlerTimer0(void);
ISR_VOID System_CoreTimersIsrHandlerTimer1(void);


/*---------------------------------------------------------------------------------
/						Variables
/----------------------------------------------------------------------------------*/


#endif //SYSTEM_CORE_TIMER_API_H_

