/***************************************************************
 File:		  System_GlobalDefinitions.h
 Module:	  System
 Purpose: 	  
 Description: 
***************************************************************/
#ifndef SYSTEM_GLOBAL_DEFINITIONS_H_
#define SYSTEM_GLOBAL_DEFINITIONS_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_PlatformConfiguration.h"
#include "mhi_global_definitions.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/


#define HW_REG_SIZE			(4) /* size of a register is four bytes */
#define HW_RESET_BLOCK		(1)

#define TRUE            (1)
#define FALSE           (0)

#define SUPPORT			TRUE
#define NOT_SUPPORT		FALSE

#define MT_TRUE      1
#define MT_FALSE     0
#define MT_NULL      0
#define SUCCESS         TRUE
#define FAIL            FALSE

#ifdef ENET_INC_ARCH_WAVE600
#define INVALID_STA_INDEX GEN6_ALL_STA_SID
#else
#define INVALID_STA_INDEX GEN5_ALL_STA_SID
#endif //ENET_INC_ARCH_WAVE600


#define INVALID_LOGGER_SID	0x0

#define CONVERT_BYTES_TO_WORDS(x)  ((uint32)(x) >> 2)
#define CONVERT_WORDS_TO_BYTES(x)  ((uint32)(x) << 2)
#define CONVERT_BYTES_TO_DOUBLE_WORDS(x)  ((uint32)(x) >> 3) 

#define CONVERT_BIT_INDEX_TO_WORDS(x)  ((uint32)(x) >> 5)
#define CONVERT_WORDS_TO_BIT_INDEX(x)  ((uint32)(x) << 5)
#define CONVERT_BIT_INDEX_TO_BYTES(x)  ((uint32)(x) >> 3)
#define CONVERT_BYTES_TO_BIT_INDEX(x)  ((uint32)(x) << 3)

#define NUM_OF_BITS_IN_BYTE		(0x8)
#define NUM_OF_BITS_IN_UINT32 	(32)
#define FOUR_BYTE_ALIGNED_MASK 	(0x3) /* Used for checking offset is 4 Bytes aligned */
#define NUM_OF_BYTES_IN_WORD	(NUM_OF_BITS_IN_UINT32/NUM_OF_BITS_IN_BYTE)

#define	HUNDRED_PERCENT			(100)

#define ATOMIC_COUNTER_ENABLER


#define DIVIDE_BY_20(x) (((x)*52429)>>20) /*approx - Valid for input < ~80000*/
#define CONVERT_TIME_UNITS_TO_10_MILISECONDS(x)(((x) * 838) >> 13) /* Valid for values < 524,000 */

/* Signature aids - Should Be Removed From Code */
#define IN
#define OUT
#define INOUT

// Mask is formed based on "REG_MAC_GENERAL_WLAN_IP_BASE_ADDR " register 
// WLAN IP Base address (The configured 7 bit field is located in bits 31:25. 
// All other bits are constant zeros), reset value: 0x18000000, access type: RO
// Note:- Should be changed for different chip 
#define MAC_XBAR_WLAN_IP_MASK						0xFE000000

/*-----------------------------
/	Mips General Defiitions					
/-------------------------------*/
#define KUSEG_BASE_ADDR		0x00000000
#define KSEG0_BASE_ADDR		0x80000000
#define KSEG2_BASE_ADDR		0xC0000000
#define KSEG3_BASE_ADDR		0xE0000000
#define KUSEG_MASK			0x80000000
#define KSEG_MASK			0xE0000000


#define VALIDATE_PARAM(Param, lowerlimit, upperlimit,Status) do {\
			if((Param < lowerlimit)||(Param > upperlimit)){\
				Status = UMI_BAD_PARAMETER;\
			}\
		} while (0)\

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
/* Useful MACRO for variables that are not currently referenced
   Prevents compiler warnings and should not produce any code  */
#define VARIABLE_INTENTIONALLY_NOT_REFERENCED(x) x=x;
#define GET_NON_CACHED( X ) (*(( uint32* )((( uint32 )(&X) & 0x0FFFFFFF) | 0xA0000000)))

/* Storage classes and pointers */
#define NULL    ((void *)0)
#define PNULL   ((void *)0)


/* unaligned little endian access */     
#define LE_READ_2(p)                            \
	((uint16)                           \
	((((const uint8 *)(p))[0]    ) | (((const uint8 *)(p))[1]<< 8)))

#define LE_READ_4(p)                            \
	((uint32)                           \
	((((const uint8 *)(p))[0]    ) | (((const uint8 *)(p))[1]<< 8) |\
	(((const uint8 *)(p))[2]<<16) | (((const uint8 *)(p))[3]<<24)))

#define CEILING( numerator, denominator )  ((numerator +  denominator - 1) /  denominator)

/* ends */

#define PRAGMA(x)								_Pragma(#x)

#ifdef CPU_MIPS
#define MAP_TO_SECTION(section1, section_name) 	PRAGMA( ghs section section1 = section_name )
#define MAP_TO_DEFAULT_SECTION(section1) 		PRAGMA( ghs section section1 = default )
#define PRAGMA_START_DATA 						PRAGMA( ghs startdata )
#define PRAGMA_END_DATA 						PRAGMA( ghs enddata )
#endif

#ifdef CPU_ARC
#define MAP_TO_SECTION(section1, section_name) 	PRAGMA( push_default_section(section1, section_name) ) \
												PRAGMA( Push_small_data(0;0))
#define MAP_TO_DEFAULT_SECTION(section1) 		PRAGMA( pop_default_section(section1) ) \
												PRAGMA( Pop_small_data())
#define PRAGMA_START_DATA 
#define PRAGMA_END_DATA 
#endif



/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
typedef unsigned char       uint8;
typedef unsigned short int  uint16;
typedef unsigned long  int  uint32;
typedef unsigned long long	uint64;

typedef signed char         int8;
typedef signed short int    int16;
typedef signed long  int	int32;
typedef long long			int64;

typedef unsigned char		bool;
typedef unsigned char       byte;
typedef unsigned short      word;
typedef unsigned long       dword;

typedef int64 TSF;

#ifdef ENET_INC_ARCH_WAVE600
typedef uint16				StaId;
#define SIZE_OF_STA_ID		(2)
#else
typedef uint8				StaId;
#define SIZE_OF_STA_ID		(1)
#endif //ENET_INC_ARCH_WAVE600

/* Functions Return Value */
typedef enum RetVal
{
	RET_VAL_SUCCESS,
	RET_VAL_FAIL,
	RET_VAL_BAD_ADDRESS,
	RET_VAL_BAD_PARAM,
	RET_VAL_ALREADY_EXISTS,
	RET_VAL_UNINITIALIZED,
	RET_VAL_NOT_SUPPORTED,
	RET_VAL_TIMEOUT,
	RET_VAL_STUCK,
	RET_VAL_FRAGMENTED,
}RetVal_e;


/* Should Be Removed From Code */
typedef enum
{
	STATUS_FAIL = 0x00,
	STATUS_SUCCESS,
	S_SUCCESS,
	S_FAIL,
	S_BAD_ADDRESS,
	S_BAD_PARAM,
	S_ALREADY_EXISTS,
	S_UNINITIALZED,
	S_NOT_SUPPORTED,
	S_TIMEOUT,
	S_STUCK,
} Status_e;

/* Should Be Removed From Code as well */
typedef enum { 
    MT_RET_OK  = 0, 
    MT_RET_FAIL,
    MT_RET_INVALID_PARAMETERS,
    MT_RET_FEATURE_NOT_SUPPORTED

} MT_RET;


/*---------------------------------------------------------------------------------
/						Public Function Declaration				
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Stack Canaries - ARC				
/----------------------------------------------------------------------------------*/

#ifdef ENET_INC_ARCH_WAVE600
// Stack Canary value (protect the RA (return address) on the stack
extern uint32 __stack_chk_guard;

// Stack canaries assert function. 
void __stack_chk_fail(void);
#endif


#endif /*SYSTEM_GLOBAL_DEFINITIONS_H_*/
