/***************************************************************
File:		  System_Information.h
 Module:	  System
 Purpose: 	  
 Description: This module is the API to the dut module which is responsible for handling, 
			  processing and executing all requests sent from the applications (Dut_Gui, Litepoint) 
			  outside the chip during the production procedure
***************************************************************/
#ifndef SYSTEM_INFORMATION_H_
#define SYSTEM_INFORMATION_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#if !defined (ENET_INC_ARCH_WAVE600)
typedef enum
{
  CORE_NUM_0 = 0,			// lm
  CORE_NUM_1 = 1,			// um
  CORE_NUM_2 = CORE_NUM_1,
  CORE_MAX_VALID = CORE_NUM_1,
  CORE_HOST,
  CORE_NUM_INVALID = MAX_UINT8,
}CoreNum_e;
#endif

#if defined (ENET_INC_ARCH_WAVE600)
typedef enum
{
  CORE_NUM_0 = 0,	// lm0
  CORE_NUM_1 = 1,	// lm1
  CORE_NUM_2 = 2,	// um
  CORE_MAX_VALID = CORE_NUM_2,
  CORE_HOST,
  CORE_NUM_INVALID = MAX_UINT8,
}CoreNum_e;
#endif



/* Chip ID table */
typedef enum _SystemInfo_ChipId_e
{
	CHIP_ID_NONE				= 0x0000,
	CHIP_ID_HYPERION_3			= 0x0700,
	CHIP_ID_HYPERION_3_PCIE		= 0x0710,
	CHIP_ID_WAVE400_PCIE_3_3	= 0x0780,
	CHIP_ID_WAVE400_USB_3_3		= 0x07A0,
	CHIP_ID_WAVE400_USB_2_2		= 0x07E0,
	CHIP_ID_WAVE400_PCIE_2_2	= 0x07F0,
	CHIP_ID_AR10				= 0x07C0,
	CHIP_GRX_390				= 0x07D0,	
	CHIP_GRX_350				= 0x07E0,
	CHIP_ID_HYPERION_3_5		= 0x0780,
	CHIP_ID_HYPERION_3_5_FPGA	= 0x1780,
	CHIP_ID_WAVE600				= 0x0900,
} SystemInfo_ChipId_e;


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void	SystemInfo_Init(void);
CoreNum_e	SystemInfo_GetCoreNum(void);
uint32	SystemInfo_GetLocalChipId(void);
void	SystemInfo_GetSwVersion(char *swVersion, uint32 maxLengthOfString);


#endif //SYSTEM_INFORMATION_H_
