/***************************************************************
 File:		  System_PlatformConfiguration.h
 Module:	  System
 Purpose: 	  
 Description: 
***************************************************************/
#ifndef SYSTEM_PLATFORM_CONFIGURATION_H_
#define SYSTEM_PLATFORM_CONFIGURATION_H_

#if defined (ENET_CFG_NONE) || defined(ENET_REAL_PHY) || defined(ENET_FPGA_DISABLE_DUMMY_PHY) || defined(ENET_FPGA_DEFAULT_DUMMY_PHY) || defined(ENET_DUMMY_PHY_USED)
#error ENET_xxx must not be defined before this point
#endif

#define ENET_CFG_CHANNEL_SETTLE     100     /* 100us */

#define PHY_REAL_NOT_USED      1 /* No real PHY used                   */
#define PHY_REAL_MT_11A_11N    6 /*Metalink 802.11N phy                */
#define TTP_DUMMY_PHY		   7 /*TTPCOM Dummy phy                    */
#define MT_DUMMY_PHY    	   8 /*Metalink 802.11N phy                */

// MT_Build_Config.h is created automatically using the new MT Batch Build
#include "MT_Build_Config.h"
/****************************************************************************
 * This section creates internal macros that are based on externally defined
 * configuration macros.
 ****************************************************************************/

#if defined (ENET_FPGA_DEFAULT_DUMMY_PHY) && !defined (ENET_FPGA_DISABLE_DUMMY_PHY)
    #define ENET_USE_DUMMY_PHY /* Build dummy PHY                    */
#endif



#ifdef TX_DATA_UM_PATH
#ifndef ENET_INC_ARCH_WAVE600 // Currently we don't enable this in Gen6 since it was not needed. If it can help - we can try to turn it on, but it was not tested at all in Gen6.
#define TX_DATA_THREAD_PATH	// configures whether incoming PDs will be handled in ISR or thread
#endif
#endif


/* Comilation Definition for GenRisc host IF debug structure*/
//#define HOST_INTERFACE_DEBUG_NUM_OF_COPIED_HDS_HISTOGRAM_ENABLED
#define	HOST_INTERFACE_DEBUG_LOGGER_DMA_COUNTER_ENABLED
#define	HOST_INTERFACE_DEBUG_EVENTS_TRACE_ENABLED


/* Comilation Definition for GenRisc host IF debug structure*/
#define TX_SENDER_DEBUG_TRACE_DMA_FIFO_STATUS_ENABLED
#define	TX_SENDER_DEBUG_COUNT_PDS_PER_TYPE_ENABLED
#define	TX_SENDER_DEBUG_EVENTS_TRACE_ENABLED

/* RX PP output goes to Driver via FW */
//#define RX_LIST_DEBUG

/* PUMA Direct Connect debug */
//#define PUMA_DEBUG_DIRECT_CONNECT

#ifdef PTA_BUILD_IN_PLAT
//#define PTA_TEST
#endif

// Option to remove retransmitted PDs from Unicast STA queue before sending CSA in GPHP
//#define CSA_REMOVE_RETRY


#if !defined (ENET_INC_ARCH_WAVE600) && defined (ENET_INC_LMAC)
#define CALCULATE_CPU_IDLE_TIME
#endif


#endif //SYSTEM_PLATFORM_CONFIGURATION_H_
