/************************************************************************************
*    
*    File:		  System_Timers.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef  System_Timers_H
#define  System_Timers_H

#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"


/**********************************/
/*  constants for MIPS timers     */
/**********************************/


enum MT_REG_TIMERS{
  MT_TIMER_0,
  MT_TIMER_1,
  MT_TIMER_2,
  MT_TIMER_3
};


#define MT_TIMER_DISABLE      0
#define MT_TIMER_ENABLE       1

#define MT_TIMER_MULT_SHOT    0
#define MT_TIMER_ONE_SHOT     1


void MT_SetModeTimer(uint32 timerId, uint32 enableTimer, uint32 shotMode);
void MT_SetTimeTimer(uint32 timerId, uint32 maxCount);
void MT_ClearIsrTimer(uint32 timerId);
void MT_PollTimer(uint32 timerId);
void MT_InitTimers(void);



void updatePrescalersForFullAndReducedFrequencyMode(void);
bool isReducedFrequency(void);
void MT_enableDisableGpTimerIrq(uint32 timerID, bool isEnable);
#ifdef ENET_INC_ARCH_WAVE600
	#if defined(ENET_INC_LMAC)
		ISR_VOID isr_Timers_Timer0(void);
		ISR_VOID isr_Timer1(void);
		ISR_VOID isr_Timer2(void);
		ISR_VOID isr_Timer3(void);
	#endif // ENET_INC_LMAC
	#ifdef ENET_INC_UMAC
		ISR_VOID isr_Timer0(void);
		ISR_VOID isr_Timer1(void);
	#endif // ENET_INC_UMAC	
#else //wave500
	#if defined(ENET_INC_LMAC)
		ISR_VOID MT_vINTTimer1_PromptScheduler(void);
		ISR_VOID GpTimerB_ISR(void);
	#endif // ENET_INC_LMAC
	#if defined(CALCULATE_CPU_IDLE_TIME)
	void LmvKNLintrTimer(void);
	#endif
	#ifdef ENET_INC_UMAC
		ISR_VOID isr_Timers_TimerA(void);
	#endif // ENET_INC_UMAC
#endif // ENET_INC_ARCH_WAVE600
#endif //System_Timers_H

