/************************************************************************************
*    
*    File:		  System_Configuration.c
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HostInterface_API.h"
#include "RegAccess_Api.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#else
#include "EmeraldEnvRegs.h"
#include "MacGeneralRegs.h"
#endif
#include "MacHtExtensionsRegs.h"
#include "stringLibApi.h"
#include "loggerAPI.h"
#if defined (CPU_MIPS)
#include "MT_osutl.h"
#endif
#include "PhyDriver_API.h"
#include "System_Timers.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_SYS
#define LOG_LOCAL_FID 3

/*************************************************************************/
/***               Defines											   ***/
/*************************************************************************/
#define COUNTS_IN_10ms_250MGHZ		500000//500049//166683  /* number of uncreasing instructions in 10 miliseconds*/ 
#define CALC_COUNTS_IN_10ms(freq) 		((250* COUNTS_IN_10ms_250MGHZ)/freq)

/*************************************************************************/
/***               Local Variables                                     ***/
/*************************************************************************/
static uint32 System_MainCoreFrequency = 0xDEADBEAD;
static uint32 System_XbarAddress = 0xDEADBEAD;
/*************************************************************************/
/***               Global Variables                                    ***/
/*************************************************************************/

#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT
extern uint32 countIn10ms; 
#endif
/*************************************************************************/
/***               Prototypes		                                   ***/
/*************************************************************************/

/*************************************************************************/
/***               Public Functions                                    ***/
/*************************************************************************/

/**********************************************************************************

System_ConvertNsToSystemClk

Description:
------------
	Converts nanoseconds to system clks
Input:
-----
	ns - Value to convert in nano seconds

 **********************************************************************************/
uint32 System_ConvertNsToSystemClk(uint32 ns)
{
	return (ns*System_MainCoreFrequency /1000);
}


/**********************************************************************************

System_ConvertNsToSystemClk

Description:
------------
	Converts micro seconds to system clks
Input:
-----
	us - Value to convert in micro seconds

 **********************************************************************************/
uint32 System_ConvertUsToSystemClk(uint32 us)
{	
	return (us*System_MainCoreFrequency);
}


/**********************************************************************************

System_GetMainCoreFrequency

Description:
------------
	Returns the configured system clk

Return:
-----
	 configured system clk

 **********************************************************************************/
uint32 System_GetMainCoreFrequency(void)
{
	return System_MainCoreFrequency;
}


uint32 System_GetXbarAddress(void)
{
	return System_XbarAddress;
}

/**********************************************************************************

System_ConfigurationInit

Description:
------------
	Initilization of the System Configuration module
Input:
-----
	hwMode

 **********************************************************************************/
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif

void System_ConfigurationInit(void)
{
#if !defined (ENET_INC_ARCH_WAVE600)
	uint32 isAcMode; /**/
	 
	isAcMode = PhyDrv_IsAcMode();

	if(isAcMode)
	{
		System_MainCoreFrequency =  320;
	}
	else
	{
		System_MainCoreFrequency =  240;
	}

	RegAccess_Read(REG_MAC_HT_EXTENSIONS_WLAN_IP_BASE_ADDR,&System_XbarAddress);
#endif


#if defined (ENET_INC_ARCH_WAVE600)
	System_MainCoreFrequency =  640;

	RegAccess_Read(REG_MAC_GENERAL_WLAN_IP_BASE_ADDR, &System_XbarAddress);
#endif

}
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif


