/************************************************************************************
*    
*    File:		  System_Information.c
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"

#include "ErrorHandler_Api.h"
#include "System_Information.h"
#include "System_FwVersion.h"
#include "RegAccess_Api.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#else
#include "EmeraldEnvRegs.h"
#endif
#include "stringLibApi.h"
#include "HwMemoryMap.h"

/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_SYS
#define LOG_LOCAL_FID 5


#define SYS_INFO_SIGN   0xabcdefab

typedef struct _sysinfo_t
{
	uint32 				signature;
	CoreNum_e 			coreNum;
	SystemInfo_ChipId_e localChipId;
} sysinfo_t;

//void memcpy (void *destaddr, void const *srcaddr, uint32 len);


sysinfo_t sysinfo;

/*
    SystemInfo_Init: init the system info structure.
    the sysinfo structure will be used for identify the
    chip revsion and capablity.
*/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
#if !defined (ENET_INC_ARCH_WAVE600)
void SystemInfo_Init(void)
{
	sysinfo.localChipId 	= (SystemInfo_ChipId_e)(MT_RdReg(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR, REG_SYSTEM_INFO_CHIP_ID) & REG_SYSTEM_INFO_CHIP_ID_MASK);
	sysinfo.coreNum			= (CoreNum_e)((MT_RdReg(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR, REG_SYSTEM_INFO_UPPER_LOWER_CPU) & REG_SYSTEM_INFO_UPPER_LOWER_CPU_MASK) ? CORE_NUM_1 : CORE_NUM_0);
	sysinfo.signature		= SYS_INFO_SIGN;
	
	ASSERT(sysinfo.coreNum <= CORE_MAX_VALID)
}
#endif

#if defined (ENET_INC_ARCH_WAVE600)
void SystemInfo_Init(void)
{ 
	RegEmeraldEnvSystemInfo_u regEmeraldEnvSystemInfo;

	RegAccess_Read(REG_EMERALD_ENV_SYSTEM_INFO, &regEmeraldEnvSystemInfo.val);

	sysinfo.localChipId		= (SystemInfo_ChipId_e)(regEmeraldEnvSystemInfo.bitFields.chipId & 0xFFFC);//((MT_RdReg(SYSTEM_IF_UPPER_CPU_BASE_ADDR, REG_EMERALD_ENV_SYSTEM_INFO) & REG_SYSTEM_INFO_CHIP_ID_MASK)>>REG_SYSTEM_INFO_CHIP_ID_SHIFT);
	sysinfo.coreNum			= (CoreNum_e)(regEmeraldEnvSystemInfo.bitFields.cpuId);//((MT_RdReg(SYSTEM_IF_UPPER_CPU_BASE_ADDR, REG_SYSTEM_INFO_UPPER_LOWER_CPU) & REG_SYSTEM_INFO_UPPER_LOWER_CPU_MASK)>>REG_SYSTEM_INFO_UPPER_LOWER_CPU_SHIFT);
	sysinfo.signature		= SYS_INFO_SIGN;

	ASSERT(sysinfo.coreNum <= CORE_MAX_VALID)
}
#endif
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

/* version string at bin file */
const char version_info[] = 
	"@@@ VERSION INFO @@@"
	" version number: " MT_WL_SW_VERSION
	" "
#if defined (ENET_INC_LMAC0)
	" Lower0 MAC"
#endif
#if defined(ENET_INC_LMAC1) 
	" Lower1 MAC" 
#endif
#if defined(ENET_INC_UMAC) 
	" Upper CPU"
#endif
#if defined(ENET_INC_HW_FPGA)
	" FPGA"
#endif
#if !defined (ENET_INC_ARCH_WAVE600)
	" WAVE500B"
#endif
#if defined (ENET_INC_ARCH_WAVE600)
	" WAVE600"
#endif
#if defined (ENET_USE_DUMMY_PHY) && (ENET_DUMMY_PHY_USED == MT_DUMMY_PHY)
	 " phy type: dummy phy"
#else
	" phy type: real phy"
#endif
	" on " __DATE__ 
	" at " __TIME__		 
	"@@@ END @@@";



//functions
/**********************************************************************************

System_InfoHandler_GetSwVersion 

Description:
------------
	Returns the the SW Version string
Input:
-----
	void
Output:
-------
	swVersion - 
Returns:
--------
	void - 
	
**********************************************************************************/
void SystemInfo_GetSwVersion(char *swVersion, uint32 maxLengthOfString)
{
	memcpy(swVersion, (char*)(&version_info[SW_VERSION_OFFSET]), maxLengthOfString);
}

/**********************************************************************************

SystemInfo_GetCoreNum 

Description:
------------
	Returns the core Number
**********************************************************************************/
CoreNum_e SystemInfo_GetCoreNum(void)
{
	return (sysinfo.coreNum);
}

/**********************************************************************************
SystemInfo_GetLocalChipId 
**********************************************************************************/
uint32 SystemInfo_GetLocalChipId(void)
{
	return (sysinfo.localChipId);
}



