/************************************************************************************
*	
*	File:		  System_Main.c
*	Class/Module: 
*	Description:	A detailed description of the Module, its  purpose attributes and
*					whatever information the user & maintainer might find valuable.
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any	
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

/*********************************************
*		Library Function Include Files
**********************************************/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Timers.h"
#include "ErrorHandler_Api.h"
#include "System_Information.h"
#include "mt_sysdefs.h"
#include "mt_cachedefs.h"
#include "mt_sysrst.h"
#if defined (CPU_MIPS)
#include "MT_osutl.h"
#endif
#include "OSAL_Api.h"
#include "mt_addr_sharing.h"
#include "HostInterface_API.h"
#include "stringLibApi.h"
#include "lminfra.h"
#include "TpcClbrHndlr.h"
#if defined (ENET_INC_UMAC)
#include "um_init.h"
#include "SenderInterface_Api.h"
#include "lm_interface.h"
#include "TxMulticastHandler_API.h"
#endif
#if defined (ENET_INC_LMAC)
#include "lm_init.h"
#include "lmtimerUtility.h"
#include "BeaconHandler_api.h"
#include "lm_StaDatabase.h"
#include "lm_VapDatabase.h"
#endif
#include "Locker_Api.h"
#include "sysinfo.h"
#include "TsManager_API.h"
#include "TxManager_Api.h"
#include "RxManager_Api.h"
#include "Statistics_Api.h"
#include "StatisticsManager_api.h"
#include "CsaManager_Api.h"
#include "CtsManager_Api.h"
#include "encryptor.h"
#include "SmpsManager_Api.h"
#include "ChannelSwitchManager_Api.h"
#include "CalibrationManager.h"
#include "BSSmanager_API.h"
#include "loggerAPI.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#else
#include "EmeraldEnvRegs.h"
#endif
#include "Qos_Api.h"
#include "Ager_Api.h"
#include "CoC_Api.h"
#include "ipc_api.h"
#include "HwLoggerAPI.h"
#include "GroupManager_API.h"
#include "HdkCdbManagerTask_api.h"
#include "Hdk_Api.h"


#if defined (CPU_ARC)
#include "arc_intrinsics.h"
#endif

#ifdef ENET_INC_ARCH_WAVE600
#include "TwtManager_API.h"
#include "PlanManager_API.h"
#if defined (ENET_INC_UMAC)
#include "RxCoordinator_Api.h"
#include "Liberator_Api.h"
#endif
#endif
#if (((defined (ENET_INC_UMAC)) && (!defined (ENET_INC_ARCH_WAVE600))) || ((defined (ENET_INC_LMAC)) && (defined (ENET_INC_ARCH_WAVE600))))
#include "Dut_Api.h"
#endif

#include "System_MainApi.h"
/*********************************************
*		Local Defines
**********************************************/

#define LOG_LOCAL_GID	GLOBAL_GID_LOWER_MAC
#define LOG_LOCAL_FID 1

#define PHY_GENERAL_DISABLE_VALUE 0
#define PHY_GENERAL_ENABLE_VALUE 1

/*********************************************
* Variables
**********************************************/
uint32 SysMain_InitComplete = FALSE; 
volatile uint32 True_g = TRUE;
/*********************************************
* Function Prototypes
**********************************************/
void System_MainInit(void);
#ifdef ENET_INC_ARCH_WAVE600
void System_MainInitEndWaitForLMs(void);
#endif
#if !defined (ENET_INC_ARCH_WAVE600)
extern char __ghsbegin_initialization[], __ghsend_initialization[];
uint32 initstartAdress= 0;
uint32 endinitAddress = 0;
uint32 sizeOfInitSection = 0;
uint32 allocatedMem = 0;

#pragma ghs section text=".initialization_start" 

void System_MainAllocInitializationMemory(uint8 **allocatedBuff, uint32 numberOfBytes)
{
	/*align number of bytes to words*/
	numberOfBytes = CONVERT_WORDS_TO_BYTES(CEILING(numberOfBytes, 4));
	/*Check if we have room in init section*/
	if (sizeOfInitSection < (allocatedMem + numberOfBytes))
	{
		ASSERT(0);
	}
	*allocatedBuff = (uint8 *)(initstartAdress + allocatedMem);
	allocatedMem += numberOfBytes;
}

#pragma ghs section text=default
#endif

/****************************************************************************
* Function Name:	main
* Description:		Main routine. Do initialization and call OS
*****************************************************************************/
int main(int argc, char *argv[ ], char *envp[ ])
{
	UNUSED_PARAM(argc);	
	UNUSED_PARAM(argv);	
	UNUSED_PARAM(envp);	
	/* This label enables to perform jr at the end of mt_osasm.s thus enabling to 
		jump from uncached to cached memory */
#if defined (CPU_MIPS)
	asm(".globl label_main");
	asm("label_main:");
#endif
	SET_DEBUG_CHI(0x80001001);
	System_MainInit();	

	SET_DEBUG_CHI(0x80005000);
	//this function never returns!
	OSAL_START_SCHEDULER();

	return 0;
}

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif

void System_MainInit(void)
{
	System_MemoryInit();
	SET_DEBUG_CHI(0x80003001); 

	//Identify the CHIP revision
	SystemInfo_Init();
	SET_DEBUG_CHI(0x80003002);

	ErrorHandler_Init();
	SET_DEBUG_CHI(0x80003003);

	// Read the band configuration mode from CHI VECTOR. Need to do it before initializing the rest. Needed in all CPUs.
	ConfigurationManager_ReadConfigurationModeFromDriver();

	SET_DEBUG_CHI(0x80003004);

#ifdef ENET_INC_ARCH_WAVE600
	//read DMA Configuration
	ConfigurationManager_ReadDmaConfiguration();
	
	SET_DEBUG_CHI(0x80003005);
#endif //ENET_INC_ARCH_WAVE600

#if defined(ENET_INC_LMAC0) && defined (ENET_INC_ARCH_WAVE600) 
	ConfigurationManager_Init();
#endif //ENET_INC_ARCH_WAVE600

	System_ConfigurationInit();
	SET_DEBUG_CHI(0x80003006);

	MT_ReleaseCPUGatedUnits();
	SET_DEBUG_CHI(0x80003007);
	
#ifndef ENET_INC_ARCH_WAVE600
	// In gen6 the GCLK and RESETS are only in Initialization_HwHandler_ResetHw().
#if defined (ENET_INC_LMAC)
	//Only LM releases MAC HW gated clocks
	MT_ReleaseMACHWGatedUnits();
	SET_DEBUG_CHI(0x80003008);

#endif
#endif // ENET_INC_ARCH_WAVE600
	MT_ADDR_SHARING_Init();
	SET_DEBUG_CHI(0x80003009);

	InterruptManager_RabInit();
	SET_DEBUG_CHI(0x8000300A);

	InterruptManager_Reset();
	SET_DEBUG_CHI(0x8000300B);
#if (defined (ENET_INC_UMAC))
	BssManager_Init();
	SET_DEBUG_CHI(0x8000300C);
#ifdef ENET_INC_ARCH_WAVE600
	PlanManager_Initialize(); 
#endif
#endif 
	LoggerApi_LoggerInit();
	SET_DEBUG_CHI(0x8000300D);

	Locker_Init();
	SET_DEBUG_CHI(0x8000300E);	
#if defined (ENET_INC_UMAC)
	vHIM_Init();
	SET_DEBUG_CHI(0x8000300F);
#endif
	/* Disable all MIPS timers */
	MT_InitTimers();
	SET_DEBUG_CHI(0x80003010);
#if defined (ENET_INC_LMAC)
	Lm_WaitForUm();
#endif
	/* Standard layers */
#if defined (ENET_INC_LMAC)
	vLM_Init();	 /* Lower MAC */
	SET_DEBUG_CHI(0x80003011);
#endif

#if defined (ENET_INC_UMAC)
#ifdef ENET_INC_ARCH_WAVE600
	Liberator_Initialize(); /* gen6 only */
	SET_DEBUG_CHI(0x80003012);
#endif //ENET_INC_ARCH_WAVE600
	vUMAC_Init();	/* Upper MAC */
	SET_DEBUG_CHI(0x80003013);
#endif

	ipc_init();
	SET_DEBUG_CHI(0x80003014);

#if defined (ENET_INC_UMAC)
	vHIM_Enable();
	SET_DEBUG_CHI(0x80003015);
#endif

#if defined(ENET_INC_LMAC)
	/* Interrupt handler initialisation */
	InterruptManager_Configure();
	SET_DEBUG_CHI(0x80003016);

	/* During startup, the upper MAC busy waits on the LM signature write. A short time later	*/
	/* the first UM->LM message is sent which is received via a lower MAC interrupt. Therefore, */
	/* the Lower MAC must write it's signature AFTER interrupt enable otherwise this first	  */
	/* interrupt may be cleared by the interrupt initialisation code.							*/
	vLM_Enable();
	SET_DEBUG_CHI(0x80003017);
#endif

#if (((defined (ENET_INC_UMAC)) && (!defined (ENET_INC_ARCH_WAVE600))) || ((defined (ENET_INC_LMAC)) && (defined (ENET_INC_ARCH_WAVE600))))
	Dut_Init();
	SET_DEBUG_CHI(0x8000301A);
#endif
}

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif




#if defined (ENET_INC_UMAC)

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization_start" 
#endif

void System_MainPostThreadxInit(void)
{
#if !defined (ENET_INC_ARCH_WAVE600)
	/*Set and calculate these here*/
	initstartAdress = (uint32)__ghsbegin_initialization;
	endinitAddress = (uint32)__ghsend_initialization;
	sizeOfInitSection = endinitAddress - initstartAdress;
    allocatedMem = 0;
#endif
	// Pleace the error handler before enabling interrupts

	SET_DEBUG_CHI(0x80006601);
	ErrorHandler_Ready();
	InterruptManager_Configure();	

	SET_DEBUG_CHI(0x80006603);
	HostInterfaceRings_PostInit();
#if	defined (ENET_INC_ARCH_WAVE600)
	HdkCdbManager_PostInitDmaInit();//in wave600 DMA post init is here. In wave500 DMA  post init is in LM.
#else //WAVE 500 
	ClbrMngr_PostInitDmaInit();//IN wave500 HDK run from UM so DMA init dhould be here
#endif
	/*These modules register with BSS manager so they must be after it*/
	TxManager_Init();

	HostInterface_PostInit();
	RxManager_PostInit();
	SET_DEBUG_CHI(0x80006604);
#ifndef ENET_INC_ARCH_WAVE600		
	ChannelSwitchManager_PostInit();
#endif
	SET_DEBUG_CHI(0x80008601);

	statisticsManagerPostInit();
	SET_DEBUG_CHI(0x80008602);

	GroupManager_PostInit();
	SET_DEBUG_CHI(0x80008604);
#ifdef ENET_INC_ARCH_WAVE600
	RxCoordinator_PostInit();
#endif //#ifdef ENET_INC_ARCH_WAVE600
	/*Put these last - they allocate memory from init section*/
	TsManager_Initialize();
	SET_DEBUG_CHI(0x80008605);

	TsManager_PostInit();
	SET_DEBUG_CHI(0x80008606);	
#if !defined (ENET_INC_ARCH_WAVE600)
	HDK_PostInit();
#endif
#ifdef ENET_INC_ARCH_WAVE600
    TwtManager_PostInit();
#endif
    SET_DEBUG_CHI(0x80008607);
	SysMain_InitComplete = TRUE;
#ifdef ENET_INC_ARCH_WAVE600
	System_MainInitEndWaitForLMs();
#endif
	SET_DEBUG_CHI(0x80008608);
	sendInitializationCompleteToHost();
}

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif

#endif // ENET_INC_UMAC

#if (defined (ENET_INC_LMAC) && defined (ENET_INC_ARCH_WAVE600))

void System_MainPostThreadxInit(void)
{
	// following module are post inited in LM for wave600 and in UM for wave500
	SET_DEBUG_CHI(0x80007600);
	ChannelSwitchManager_PostInit();
	SysMain_InitComplete = TRUE;
	ErrorHandler_Ready();
	SET_DEBUG_CHI(HOST_MAGIC);
}
#endif // defined (ENET_INC_LMAC) && defined (ENET_INC_ARCH_WAVE600)

#ifdef ENET_INC_ARCH_WAVE600

void System_MainInitEndWaitForLMs()
{
	while(1)
    {
   		if ((sCHIvectorArea.sDebugExt.sData.u32Core0_info == HOST_MAGIC) && (sCHIvectorArea.sDebugExt.sData.u32Core1_info == HOST_MAGIC))
        {
        	break;
        }
    }
}
#endif

#if (defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization_start" 
void System_MainPostInit(void)
{
	/*Set and calculate these here*/
	initstartAdress = (uint32)__ghsbegin_initialization;
	endinitAddress = (uint32)__ghsend_initialization;
	sizeOfInitSection = endinitAddress - initstartAdress;
    allocatedMem = 0;
	BeaconHandler_Init();
	TimerUtiltyInit();
	Lm_StadBInit();
	Lm_VapDbInit();

	OSAL_INIT(); // done only for tiny kernel
	
	SysMain_InitComplete = TRUE;
	ErrorHandler_Ready();
	SET_DEBUG_CHI(0x8000301C);
}
#pragma ghs section text=default
#endif
