/*******************************************************************************
*    
*   Source File: fw_utils_queue.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

#ifndef	FW_UTILS_QUEUE_H
#define FW_UTILS_QUEUE_H

#include "tx_api.h"


typedef struct 
{
	K_MSG		*head;
	K_MSG		*tail;
	uint32		maxPayload;
} FwUtils_queue_t;


typedef struct  
{
	TX_TIMER				timer;
	K_TASKID				taskId;
	K_MSG_TYPE				msgType;
} TxApp_timerInfo_t;



void FwUtils_InitQueue(FwUtils_queue_t* pQueue);
void FwUtils_Enqueue(FwUtils_queue_t* pQueue, K_MSG* pNode);
void FwUtils_EnqueueToHead(FwUtils_queue_t* pQueue, K_MSG* pNode);
K_MSG *FwUtils_Dequeue(FwUtils_queue_t* pQueue);


bool FwUtils_IsQueueEmpty( FwUtils_queue_t *psQueue ); 


#define FWUTILS_IS_QUEUE_EMPTY(queue)											FwUtils_IsQueueEmpty(queue)
#define FWUTILS_ENQUEUE(queue, node)											FwUtils_Enqueue(queue, node)
#define FWUTILS_DEQUEUE(queue)													FwUtils_Dequeue(queue)


//*******v******* old queues methodology *******v************/	
	

//******^******** old queues methodology *************^******/

#endif //FW_UTILS_QUEUE_H
