/*******************************************************************************
*    
*   Source File: tx_application_Api.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#ifndef TX_APPLICATION_API_H
#define TX_APPLICATION_API_H


#include "tx_application_msg_pools.h"
#include "tx_api.h"
#include "tx_application_dependencies.h"
#include "OSAL_Kmsg.h"
#include "ErrorHandler_Api.h"


void	TxApp_SendMessage(K_MSG_TYPE msgType, K_TASKID bTo, K_MSG *psKmsg, uint32 wait, uint8 vapId);
void 	TxApp_SendFrontMessage(K_MSG_TYPE msgType, K_TASKID bTo, K_MSG *psKmsg, uint32 wait, uint8 vapId);
void	TxApp_KernelEnter(void);
void	TxApp_SetMessageOriginatorTaskId( K_MSG *psMsg );
void	TxApp_SendNoDataFastMessage(K_MSG_TYPE msgType, K_TASKID taskId, uint32 wait, uint8 vapId);
K_MSG	*TxApp_GetFastMessage(uint16 len);
K_MSG	*TxApp_GetDefaultMessage(uint16 len);
void	TxApp_FreeMessage(K_MSG *psMsg, byte bPersistentMsg);
void	TxApp_GetMessageOriginator(K_MSG *psMsg, K_TASKID *pTask);
void	TxApp_InitPersistentMsg(K_MSG *msg, K_LEN tK_LenLength);
void	TxApp_DecMsgRefCount(K_MSG *psMsg);
void	TxApp_IncMsgRefCount(K_MSG *psMsg);
void 	TxApp_EnableTraceX(VOID);
void 	TxApp_DisableTraceX(VOID);
bool	TxApp_IsThreadsQueueEmpty(uint32 threadId);
void	TxApp_Thread_Relinquish(void);
void    TxApp_ChangeThreadPriority(uint8 taskId, uint8 newPriority);
void	TxApp_OverlayStacksAndQueues(void **pQueueLocation, void **pStackLocation);
VOID    tx_application_define(VOID *);
void 	TxApp_Error(TX_THREAD *thread_ptr);
void 	TxApp_HandleShramErrorIsr(void); 



#define TX_APP_ALIGN_4(x) ((x + 3) & ~0x03)


/*-------- Debug and Trace Definitions ------*/

typedef int32 TX_TIME;    /* must be signed */

/*-------- Timer Api --------*/
//typedef signed long K_TIME;    /* must be signed */


#define TX_APP_INCLUDE_MODULE_IDLE_COUNT


#define NUM_OF_COUNTS_TO_MESURE_CPU 	1000
#define CPU_LOAD_ARRAY_SIZE				100
#define CPU_LOAD_MESUREMANT_FACTOR		1000
#define CPU_LOAD_PRECENT_WITH_FACTOR	CPU_LOAD_MESUREMANT_FACTOR/100


extern uint32 cpuLoadArrayIndex; 
extern uint32 cpuLoadArray[CPU_LOAD_ARRAY_SIZE];  // In gen5 - each entry represent ~0.1 second,  The total array gives perspective on 1sec. In gen6 - each entry is 1 second.

/* Inputs to Timer Task */
#define MS_TO_K_TICKS(ms)           ((ms*K_TICKS_PER_SECOND)/1000)


void 	TxApp_TimerInitialization(void);
void	TxApp_TimerIsr(void);
void	TxApp_SetTimer(K_MSG_TYPE bTimerId, TX_TIME wTimeOut);
void	TxApp_ResetTimer(K_MSG_TYPE bTimerId, K_TASKID bCurrentTaskId);
void	TxApp_TimerExpirationFunc_General(uint32 timerIdx);
uint32	TxApp_GetTimerTicks(void);
void 	MT_SetModeTimer(uint32 timerId, uint32 enableTimer, uint32 shotMode);
void 	MT_SetTimeTimer(uint32 timerId, uint32 maxCount);
void 	MT_ClearIsrTimer(uint32 timerId);
void 	MT_PollTimer(uint32 timerId);

#endif //TX_APPLICATION_API_H

