/*******************************************************************************
*    
*   Source File: tx_application_msg_pools.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#ifndef TX_APPLICATION_MSG_POOLS
#define TX_APPLICATION_MSG_POOLS

#include "tx_application_Api.h"
#include "OSAL_Kmsg.h"


#define TX_APP_MAX_MSG_DATA	(500)
#define K_MSG_NULL	(K_MSG *) 0
#define K_NO_DATA	0
#define pK_MSG_DATA(P)      (P)->abData


/* The following are masks that are applied to the bListNoAndRefCount */
/* element of the K_MSG structure.                                    */
/* Bits 7-4 are used for message pool information                     */
/* Bit  3 is reserved for trapping reference count over/underflow     */
/* Bits 2-0 are used for the reference count (0-7: 0 means 'free')    */

#define bLNARC_FAST_POOL             0xe0
#define bLNARC_DEFAULT_POOL		     0xf0
#define bLNARC_POOL_MASK             0xf0
#define bLNARC_GET_POOL_ID(x)        ((x) & bLNARC_POOL_MASK)

#define bLNARC_POOL_OVERFLOW_BIT     0x08
#define bLNARC_REF_COUNT(x)          (x)
#define bLNARC_REF_COUNT_MASK        0x07
#define bLNARC_GET_REF_COUNT(x)      ((x) & bLNARC_REF_COUNT_MASK)

/* Define a default limit on ref count. A smaller value can be specified
 * in the kernel configuration file to allow a build to specify that it is
 * only intended to use a smaller reference count. */

#define K_MAX_REF_COUNT 			 (7)

#if(K_MAX_REF_COUNT > bLNARC_REF_COUNT_MASK)
#error "K_MAX_REF_COUNT is set to a too big value"
#endif

#endif

