/*******************************************************************************
*    
*   Source File: tx_application_define.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#ifndef TX_APPLICATION_DEFINE_H
#define TX_APPLICATION_DEFINE_H

#include "tx_application_Api.h"
#include "tx_application_queues.h"
#include "tx_application_stacks.h"
#include "tx_application_priorities.h"
#include "fw_utils_queue.h"
#include "kccmsg.h"


typedef enum
{
#if (defined(ENET_INC_UMAC) && defined (ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_HDK_ONLINE_CALIB,
#endif

#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_STATISTICS_MANAGER_PHY_STAT_CHANNEL_LOAD,
#endif	

#if defined(ENET_INC_UMAC) 
	TX_APP_TIMER_RX_MANAGER,
#endif	

#if defined(ENET_INC_UMAC) 
	TX_APP_TIMER_TS_MANAGER,
#endif	

#if defined(ENET_INC_UMAC) && defined(USE_AGER_EMULATOR)
	TX_APP_TIMER_AGER_EMULATOR_PERIODIC_CHECK,
#endif

#if defined(ENET_INC_UMAC)
	TX_APP_TIMER_CTS_MANAGER_STOP_TX,
#endif	

#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_CTS_MANAGER_STOP_TX_B1, // CTS STOP timer for band1 is only in Gen6
#endif	

#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_CHANNEL_SWITCH_MANAGER,
#endif

#if defined(ENET_INC_UMAC)
	TX_APP_TIMER_GROUP_MANAGER_TRAINING,
#endif

#if defined(ENET_INC_UMAC)
	ATF_MANAGER_TIMER,
#endif

#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600))
	ATF_MANAGER_TIMER_B1, //ATF timer for band1 is only in Gen6
#endif	

#if defined (TX_DATA_THREAD_PATH)
	TX_APP_TIMER_STARVATION,
#endif

#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
#if defined RADAR_DETECTION_ENABLED
	TX_APP_TIMER_INTERFERER_DETECTION_RADAR_AGING,
#endif
#endif	

#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_HDK_CONTINUOUS_INTERFERER_DETECTION,
#endif


#if defined(ENET_INC_UMAC) && defined(PTA_BUILD_IN_PLAT)
	PTA_STARV_TIMER,
	PTA_REP_TIMER,
#endif

#if defined(ENET_INC_UMAC)
	TX_APP_TIMER_QOS_PD_THRESOLD,
#endif

#if (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_ERP_TIMER, 
#endif

#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_CPU_LOAD,
#endif

#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600)) 
	TX_APP_TIMER_HE_GROUP_MANAGER,	
#endif 

#if (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	TX_APP_TIMER_DUTY_CYCLE,
#endif

#if defined(ENET_INC_UMAC)
	TX_APP_TIMER_CSA_MANAGER_START_TX_UC_DEAUTH,
	TX_APP_TIMER_CSA_MANAGER_START_TX_MC_DEAUTH,
#endif
#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600)) 
	TX_APP_TIMER_CSA_MANAGER_START_TX_UC_DEAUTH_B1,
	TX_APP_TIMER_CSA_MANAGER_START_TX_MC_DEAUTH_B1,
#endif
	TX_APP_NUMBER_OF_TIMERS,
} TxApp_timerInfo_e;



#if defined (ENET_INC_UMAC)
#define TX_APP_NUMBER_OF_FAST_MSGS	96 // 128
#endif
#if defined (ENET_INC_LMAC)
#define TX_APP_NUMBER_OF_FAST_MSGS	96
#endif
#if defined (CPU_ARC)
#define TIMER_PERIOD_IN_MS 10
#endif

#define TX_APP_NAME_STR_SIZE (13)

typedef void (*TxApp_taskSpecificFunc_t)(K_MSG *pkMsg);

/*structs*/
typedef struct 
{
	K_MSG *p;
} TxApp_interThreadMsg_t;

typedef struct 
{
	TxApp_taskSpecificFunc_t entryFunc;
	uint32					 queueSize;
	uint32					 stackSize;
	TxApp_threadPriority_e	 priority;
	TxApp_threadPriority_e	 preemptThrsld;
	char					 name [TX_APP_NAME_STR_SIZE];
	K_TASKID				 taskId;
}TxApp_threadPeripheralInfo_t;

typedef struct
{
	TX_THREAD	thread;
	TX_QUEUE	queue;
} TxApp_threadInfo_t;


/*definitions*/
#define TX_APP_BLOCK_POOL_FAST_MSG_BLOCK_SIZE	(K_FAST_MSG_SIZE + sizeof(K_MSG_HEADER)) //(sizeof(K_FAST_MSG))

//timer default definitions:
#define TX_APP_TIME_SLICE_NO_TIME_SLICE		(0)
#define TX_APP_TIMER_ONE_SHOT (0)

/* 	Size of pool allocated for ThreadX In Words  =  
	Number of Message(200) * ( Fast Message Block Size (K_FAST_MSG_SIZE(32) + K_MSG_HEADER(16))+ ThreadX Block Overhead (4) / 4 )*/
#define TX_APP_BLOCK_POOL_FAST_MSG_POOL_WORD_SIZE	(((TX_APP_BLOCK_POOL_FAST_MSG_BLOCK_SIZE  + sizeof(ULONG))/4) * TX_APP_NUMBER_OF_FAST_MSGS)


extern uint32 TxApp_BlockPoolFastMsg_location			[TX_APP_BLOCK_POOL_FAST_MSG_POOL_WORD_SIZE];
#define TX_APP_BLOCK_POOL_FAST_MSG_POOL_ADDR			(&(TxApp_BlockPoolFastMsg_location))


//#endif

#endif //TX_APPLICATION_DEFINE_H

