/*******************************************************************************
*    
*   Source File: tx_application_priorities.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#ifndef TX_APPLICATION_PRIORITIES_H
#define TX_APPLICATION_PRIORITIES_H

/*priorities*/

typedef enum 
{
	/*** priority 0 is used by kernel timer thread */
	TX_APP_MAX_PRIORITY = 5,
	TX_APP_MID_PRIORITY = 4,
	TX_APP_NO_PREEMPTION_THRSLD = TX_APP_MAX_PRIORITY,
	/***********************************************/
#ifdef TX_APP_INCLUDE_MODULE_LINK_ADAPTATION
	TX_APP_PRIORITY_LINK_ADAPTATION = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_CHANNEL_SWITCH_MANAGER
	TX_APP_PRIORITY_CHANNEL_SWITCH_MANAGER = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_IF
	TX_APP_PRIORITY_IF = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_BSS
	TX_APP_PRIORITY_BSS = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_ENC
	TX_APP_PRIORITY_ENC = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_IPC
	TX_APP_PRIORITY_IPC = TX_APP_MID_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_HIM
	TX_APP_PRIORITY_HIM = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_INTERFERER_DETECTION
	TX_APP_PRIORITY_INTERFERER_DETECTION = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_COC
	TX_APP_PRIORITY_COC = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_BSSM
	TX_APP_PRIORITY_BSSM = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_HDK
	TX_APP_PRIORITY_HDK = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_LOGGER
	TX_APP_PRIORITY_LOGGER = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_RX_MANAGER
	TX_APP_PRIORITY_RX_MANAGER = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_TX_MANAGER
	TX_APP_PRIORITY_TX_MANAGER = TX_APP_MAX_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_TS_MANAGER
	TX_APP_PRIORITY_TS_MANAGER = TX_APP_MAX_PRIORITY,
#endif	

#ifdef TX_APP_INCLUDE_MODULE_AGER_EMULATOR
	TX_APP_PRIORITY_AGER_EMULATOR = TX_APP_MAX_PRIORITY,
	TX_APP_HIGH_PRIORITY_AGER_EMULATOR = TX_APP_MID_PRIORITY,
#endif
#ifdef TX_APP_INCLUDE_MODULE_QOS
	TX_APP_PRIORITY_QOS = TX_APP_MAX_PRIORITY,
#endif	
#ifdef TX_APP_INCLUDE_MODULE_STATISTICS_MANAGER
	TX_APP_PRIORITY_STAT_MANAGER = TX_APP_MAX_PRIORITY, 
#endif 
#ifdef TX_APP_INCLUDE_MODULE_PROCESS_MANAGER
	TX_APP_PRIORITY_PROCESS_MANAGER = TX_APP_MID_PRIORITY, 
#endif 
#ifdef TX_APP_INCLUDE_MODULE_PAC_MANAGER 
	TX_APP_PRIORITY_PAC_MANAGER = TX_APP_MID_PRIORITY, 
#endif
#ifdef TX_APP_INCLUDE_MODULE_DUT
	TX_APP_PRIORITY_DUT = TX_APP_MAX_PRIORITY, 
#endif 
#ifdef TX_APP_INCLUDE_MODULE_GROUP_MANAGER
	TX_APP_PRIORITY_GROUP_MANAGER = TX_APP_MAX_PRIORITY,
#endif	
#ifdef TX_APP_INCLUDE_MODULE_PTA
#ifdef PTA_BUILD_IN_PLAT
	TX_APP_PRIORITY_PTA = TX_APP_MID_PRIORITY,
#endif	
#endif	

#ifdef TX_APP_INCLUDE_MODULE_ATF
	TX_APP_PRIORITY_ATF = TX_APP_MAX_PRIORITY,
#endif

#ifdef TX_APP_INCLUDE_MODULE_HE_GROUP_MANAGER
	TX_APP_PRIORITY_HE_GROUP_MANAGER = TX_APP_MAX_PRIORITY,
#endif

#ifdef TX_APP_INCLUDE_MODULE_PLAN_MANAGER
	TX_APP_PRIORITY_PLAN_MANAGER = TX_APP_MAX_PRIORITY,
#endif

#ifdef TX_APP_INCLUDE_MODULE_TWT_MANAGER
	TX_APP_PRIORITY_TWT_MANAGER = TX_APP_MAX_PRIORITY,
#endif

#ifdef TX_APP_INCLUDE_HDK_CDB_MANAGER
	TX_APP_PRIORITY_HDK_CDB_MANAGER = TX_APP_MAX_PRIORITY,
#endif	
#ifdef TX_APP_INCLUDE_PROCESS_MANAGER_CDB
	TX_APP_PRIORITY_PROCESS_MANAGER_CDB = TX_APP_MAX_PRIORITY,
#endif	

#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT
	TX_APP_PRIORITY_IDLE = 10, 
#endif
} TxApp_threadPriority_e;

/*preemption thresholds*/
#define TX_APP_PREEMPT_THRSLD_LM				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_LINK_ADAPTATION	            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_IF				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_UMM				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_BSS				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_ENC				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_IPC				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_HIM				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_HIM_DATA_PATH		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_INTERFERER_DETECTION			TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_TLM				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_AOCS				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_COC				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_BSSM				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_BSSMIF			            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_LOGGER			            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_HDK				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_RX_MANAGER		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_TX_MANAGER		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_TS_MANAGER		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_TX  			 	            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_RX_DATA_PATH	 	            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_AGER_EMULATOR	 	            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_QOS        		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_CHANNEL_SWITCH_MANAGER		TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_STATS_MANAGER		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_PROCESS_MANAGER	            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_PAC_MANAGER		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_DUT				            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_GROUP_MANAGER		            TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_HE_GROUP_MANAGER				TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_PLAN_MANAGER					TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_TWT_MANAGER					TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_HDK_CDB_MANAGER		        TX_APP_NO_PREEMPTION_THRSLD
#define TX_APP_PREEMPT_THRSLD_PROCESS_MANAGER_CDB		    TX_APP_NO_PREEMPTION_THRSLD


#ifdef PTA_BUILD_IN_PLAT
#define TX_APP_PREEMPT_THRSLD_PTA							TX_APP_NO_PREEMPTION_THRSLD
#endif
#define TX_APP_PREEMPT_THRSLD_ATF		                    TX_APP_NO_PREEMPTION_THRSLD

#define TX_APP_PREEMPT_THRSLD_IDLE		TX_APP_PRIORITY_IDLE /* let any thread to preemt this one, it should be always assigned with the lowest priority at the system */

#endif //TX_APPLICATION_PRIORITIES_H

